/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.provider.Telephony;
import android.telephony.SmsMessage;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsHeader;
import java.util.Arrays;

public abstract class SmsMessageBase {
    private static final String LOG_TAG = "SMS";
    protected String scAddress;
    protected SmsAddress originatingAddress;
    protected String messageBody;
    protected String pseudoSubject;
    protected String emailFrom;
    protected String emailBody;
    protected boolean isEmail;
    protected long scTimeMillis;
    protected byte[] mPdu;
    protected byte[] userData;
    protected SmsHeader userDataHeader;
    protected boolean isMwi;
    protected boolean mwiSense;
    protected boolean mwiDontStore;
    protected int statusOnIcc = -1;
    protected int indexOnIcc = -1;
    public int messageRef;

    public String getServiceCenterAddress() {
        return this.scAddress;
    }

    public String getOriginatingAddress() {
        if (this.originatingAddress == null) {
            return null;
        }
        return this.originatingAddress.getAddressString();
    }

    public String getDisplayOriginatingAddress() {
        if (this.isEmail) {
            return this.emailFrom;
        }
        return this.getOriginatingAddress();
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public abstract SmsMessage.MessageClass getMessageClass();

    public String getDisplayMessageBody() {
        if (this.isEmail) {
            return this.emailBody;
        }
        return this.getMessageBody();
    }

    public String getPseudoSubject() {
        return this.pseudoSubject == null ? "" : this.pseudoSubject;
    }

    public long getTimestampMillis() {
        return this.scTimeMillis;
    }

    public boolean isEmail() {
        return this.isEmail;
    }

    public String getEmailBody() {
        return this.emailBody;
    }

    public String getEmailFrom() {
        return this.emailFrom;
    }

    public abstract int getProtocolIdentifier();

    public abstract boolean isReplace();

    public abstract boolean isCphsMwiMessage();

    public abstract boolean isMWIClearMessage();

    public abstract boolean isMWISetMessage();

    public abstract boolean isMwiDontStore();

    public byte[] getUserData() {
        return this.userData;
    }

    public SmsHeader getUserDataHeader() {
        return this.userDataHeader;
    }

    public byte[] getPdu() {
        return this.mPdu;
    }

    public abstract int getStatus();

    public abstract boolean isStatusReportMessage();

    public abstract boolean isReplyPathPresent();

    public int getStatusOnIcc() {
        return this.statusOnIcc;
    }

    public int getIndexOnIcc() {
        return this.indexOnIcc;
    }

    protected void parseMessageBody() {
        if (this.originatingAddress != null && this.originatingAddress.couldBeEmailGateway()) {
            this.extractEmailAddressFromMessageBody();
        }
    }

    protected void extractEmailAddressFromMessageBody() {
        String[] parts = this.messageBody.split("( /)|( )", 2);
        if (parts.length < 2) {
            return;
        }
        this.emailFrom = parts[0];
        this.emailBody = parts[1];
        this.isEmail = Telephony.Mms.isEmailAddress(this.emailFrom);
    }

    public static abstract class SubmitPduBase {
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        public String toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }
    }

    public static class TextEncodingDetails {
        public int msgCount;
        public int codeUnitCount;
        public int codeUnitsRemaining;
        public int codeUnitSize;
        public int languageTable;
        public int languageShiftTable;

        public String toString() {
            return "TextEncodingDetails { msgCount=" + this.msgCount + ", codeUnitCount=" + this.codeUnitCount + ", codeUnitsRemaining=" + this.codeUnitsRemaining + ", codeUnitSize=" + this.codeUnitSize + ", languageTable=" + this.languageTable + ", languageShiftTable=" + this.languageShiftTable + " }";
        }
    }
}

