/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cat;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.telephony.cat.AppInterface;
import com.android.internal.telephony.cat.BIPClientParams;
import com.android.internal.telephony.cat.CallSetupParams;
import com.android.internal.telephony.cat.CommandDetails;
import com.android.internal.telephony.cat.CommandParams;
import com.android.internal.telephony.cat.DisplayTextParams;
import com.android.internal.telephony.cat.GetInputParams;
import com.android.internal.telephony.cat.Input;
import com.android.internal.telephony.cat.LaunchBrowserMode;
import com.android.internal.telephony.cat.LaunchBrowserParams;
import com.android.internal.telephony.cat.Menu;
import com.android.internal.telephony.cat.PlayToneParams;
import com.android.internal.telephony.cat.SelectItemParams;
import com.android.internal.telephony.cat.TextMessage;
import com.android.internal.telephony.cat.ToneSettings;

public class CatCmdMessage
implements Parcelable {
    CommandDetails mCmdDet;
    private TextMessage mTextMsg;
    private Menu mMenu;
    private Input mInput;
    private BrowserSettings mBrowserSettings = null;
    private ToneSettings mToneSettings = null;
    private CallSettings mCallSettings = null;
    public static final Parcelable.Creator<CatCmdMessage> CREATOR = new Parcelable.Creator<CatCmdMessage>(){

        @Override
        public CatCmdMessage createFromParcel(Parcel in) {
            return new CatCmdMessage(in);
        }

        public CatCmdMessage[] newArray(int size) {
            return new CatCmdMessage[size];
        }
    };

    CatCmdMessage(CommandParams cmdParams) {
        this.mCmdDet = cmdParams.cmdDet;
        switch (this.getCmdType()) {
            case SET_UP_MENU: 
            case SELECT_ITEM: {
                this.mMenu = ((SelectItemParams)cmdParams).menu;
                break;
            }
            case DISPLAY_TEXT: 
            case SET_UP_IDLE_MODE_TEXT: 
            case SEND_DTMF: 
            case SEND_SMS: 
            case SEND_SS: 
            case SEND_USSD: {
                this.mTextMsg = ((DisplayTextParams)cmdParams).textMsg;
                break;
            }
            case GET_INPUT: 
            case GET_INKEY: {
                this.mInput = ((GetInputParams)cmdParams).input;
                break;
            }
            case LAUNCH_BROWSER: {
                this.mTextMsg = ((LaunchBrowserParams)cmdParams).confirmMsg;
                this.mBrowserSettings = new BrowserSettings();
                this.mBrowserSettings.url = ((LaunchBrowserParams)cmdParams).url;
                this.mBrowserSettings.mode = ((LaunchBrowserParams)cmdParams).mode;
                break;
            }
            case PLAY_TONE: {
                PlayToneParams params = (PlayToneParams)cmdParams;
                this.mToneSettings = params.settings;
                this.mTextMsg = params.textMsg;
                break;
            }
            case SET_UP_CALL: {
                this.mCallSettings = new CallSettings();
                this.mCallSettings.confirmMsg = ((CallSetupParams)cmdParams).confirmMsg;
                this.mCallSettings.callMsg = ((CallSetupParams)cmdParams).callMsg;
                break;
            }
            case OPEN_CHANNEL: 
            case CLOSE_CHANNEL: 
            case RECEIVE_DATA: 
            case SEND_DATA: {
                BIPClientParams param = (BIPClientParams)cmdParams;
                this.mTextMsg = param.textMsg;
            }
        }
    }

    public CatCmdMessage(Parcel in) {
        this.mCmdDet = (CommandDetails)in.readParcelable(null);
        this.mTextMsg = (TextMessage)in.readParcelable(null);
        this.mMenu = (Menu)in.readParcelable(null);
        this.mInput = (Input)in.readParcelable(null);
        switch (this.getCmdType()) {
            case LAUNCH_BROWSER: {
                this.mBrowserSettings = new BrowserSettings();
                this.mBrowserSettings.url = in.readString();
                this.mBrowserSettings.mode = LaunchBrowserMode.values()[in.readInt()];
                break;
            }
            case PLAY_TONE: {
                this.mToneSettings = (ToneSettings)in.readParcelable(null);
                break;
            }
            case SET_UP_CALL: {
                this.mCallSettings = new CallSettings();
                this.mCallSettings.confirmMsg = (TextMessage)in.readParcelable(null);
                this.mCallSettings.callMsg = (TextMessage)in.readParcelable(null);
            }
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mCmdDet, 0);
        dest.writeParcelable(this.mTextMsg, 0);
        dest.writeParcelable(this.mMenu, 0);
        dest.writeParcelable(this.mInput, 0);
        switch (this.getCmdType()) {
            case LAUNCH_BROWSER: {
                dest.writeString(this.mBrowserSettings.url);
                dest.writeInt(this.mBrowserSettings.mode.ordinal());
                break;
            }
            case PLAY_TONE: {
                dest.writeParcelable(this.mToneSettings, 0);
                break;
            }
            case SET_UP_CALL: {
                dest.writeParcelable(this.mCallSettings.confirmMsg, 0);
                dest.writeParcelable(this.mCallSettings.callMsg, 0);
            }
        }
    }

    public int describeContents() {
        return 0;
    }

    public AppInterface.CommandType getCmdType() {
        return AppInterface.CommandType.fromInt(this.mCmdDet.typeOfCommand);
    }

    public Menu getMenu() {
        return this.mMenu;
    }

    public Input geInput() {
        return this.mInput;
    }

    public TextMessage geTextMessage() {
        return this.mTextMsg;
    }

    public BrowserSettings getBrowserSettings() {
        return this.mBrowserSettings;
    }

    public ToneSettings getToneSettings() {
        return this.mToneSettings;
    }

    public CallSettings getCallSettings() {
        return this.mCallSettings;
    }

    public class CallSettings {
        public TextMessage confirmMsg;
        public TextMessage callMsg;
    }

    public class BrowserSettings {
        public String url;
        public LaunchBrowserMode mode;
    }
}

