/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.Parcel;

public class CdmaInformationRecords {
    public Object record;
    public static final int RIL_CDMA_DISPLAY_INFO_REC = 0;
    public static final int RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC = 1;
    public static final int RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC = 2;
    public static final int RIL_CDMA_CONNECTED_NUMBER_INFO_REC = 3;
    public static final int RIL_CDMA_SIGNAL_INFO_REC = 4;
    public static final int RIL_CDMA_REDIRECTING_NUMBER_INFO_REC = 5;
    public static final int RIL_CDMA_LINE_CONTROL_INFO_REC = 6;
    public static final int RIL_CDMA_EXTENDED_DISPLAY_INFO_REC = 7;
    public static final int RIL_CDMA_T53_CLIR_INFO_REC = 8;
    public static final int RIL_CDMA_T53_RELEASE_INFO_REC = 9;
    public static final int RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC = 10;

    public CdmaInformationRecords(Parcel p) {
        int id2 = p.readInt();
        switch (id2) {
            case 0: 
            case 7: {
                this.record = new CdmaDisplayInfoRec(id2, p.readString());
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                this.record = new CdmaNumberInfoRec(id2, p.readString(), p.readInt(), p.readInt(), p.readInt(), p.readInt());
                break;
            }
            case 4: {
                this.record = new CdmaSignalInfoRec(p.readInt(), p.readInt(), p.readInt(), p.readInt());
                break;
            }
            case 5: {
                this.record = new CdmaRedirectingNumberInfoRec(p.readString(), p.readInt(), p.readInt(), p.readInt(), p.readInt(), p.readInt());
                break;
            }
            case 6: {
                this.record = new CdmaLineControlInfoRec(p.readInt(), p.readInt(), p.readInt(), p.readInt());
                break;
            }
            case 8: {
                this.record = new CdmaT53ClirInfoRec(p.readInt());
                break;
            }
            case 10: {
                this.record = new CdmaT53AudioControlInfoRec(p.readInt(), p.readInt());
                break;
            }
            default: {
                throw new RuntimeException("RIL_UNSOL_CDMA_INFO_REC: unsupported record. Got " + CdmaInformationRecords.idToString(id2) + " ");
            }
        }
    }

    public static String idToString(int id2) {
        switch (id2) {
            case 0: {
                return "RIL_CDMA_DISPLAY_INFO_REC";
            }
            case 1: {
                return "RIL_CDMA_CALLED_PARTY_NUMBER_INFO_REC";
            }
            case 2: {
                return "RIL_CDMA_CALLING_PARTY_NUMBER_INFO_REC";
            }
            case 3: {
                return "RIL_CDMA_CONNECTED_NUMBER_INFO_REC";
            }
            case 4: {
                return "RIL_CDMA_SIGNAL_INFO_REC";
            }
            case 5: {
                return "RIL_CDMA_REDIRECTING_NUMBER_INFO_REC";
            }
            case 6: {
                return "RIL_CDMA_LINE_CONTROL_INFO_REC";
            }
            case 7: {
                return "RIL_CDMA_EXTENDED_DISPLAY_INFO_REC";
            }
            case 8: {
                return "RIL_CDMA_T53_CLIR_INFO_REC";
            }
            case 9: {
                return "RIL_CDMA_T53_RELEASE_INFO_REC";
            }
            case 10: {
                return "RIL_CDMA_T53_AUDIO_CONTROL_INFO_REC";
            }
        }
        return "<unknown record>";
    }

    public static class CdmaT53AudioControlInfoRec {
        public byte uplink;
        public byte downlink;

        public CdmaT53AudioControlInfoRec(int uplink, int downlink) {
            this.uplink = (byte)uplink;
            this.downlink = (byte)downlink;
        }

        public String toString() {
            return "CdmaT53AudioControlInfoRec: { uplink: " + this.uplink + " downlink: " + this.downlink + " }";
        }
    }

    public static class CdmaT53ClirInfoRec {
        public byte cause;

        public CdmaT53ClirInfoRec(int cause) {
            this.cause = (byte)cause;
        }

        public String toString() {
            return "CdmaT53ClirInfoRec: { cause: " + this.cause + " }";
        }
    }

    public static class CdmaLineControlInfoRec {
        public byte lineCtrlPolarityIncluded;
        public byte lineCtrlToggle;
        public byte lineCtrlReverse;
        public byte lineCtrlPowerDenial;

        public CdmaLineControlInfoRec(int lineCtrlPolarityIncluded, int lineCtrlToggle, int lineCtrlReverse, int lineCtrlPowerDenial) {
            this.lineCtrlPolarityIncluded = (byte)lineCtrlPolarityIncluded;
            this.lineCtrlToggle = (byte)lineCtrlToggle;
            this.lineCtrlReverse = (byte)lineCtrlReverse;
            this.lineCtrlPowerDenial = (byte)lineCtrlPowerDenial;
        }

        public String toString() {
            return "CdmaLineControlInfoRec: { lineCtrlPolarityIncluded: " + this.lineCtrlPolarityIncluded + " lineCtrlToggle: " + this.lineCtrlToggle + " lineCtrlReverse: " + this.lineCtrlReverse + " lineCtrlPowerDenial: " + this.lineCtrlPowerDenial + " }";
        }
    }

    public static class CdmaRedirectingNumberInfoRec {
        public static final int REASON_UNKNOWN = 0;
        public static final int REASON_CALL_FORWARDING_BUSY = 1;
        public static final int REASON_CALL_FORWARDING_NO_REPLY = 2;
        public static final int REASON_CALLED_DTE_OUT_OF_ORDER = 9;
        public static final int REASON_CALL_FORWARDING_BY_THE_CALLED_DTE = 10;
        public static final int REASON_CALL_FORWARDING_UNCONDITIONAL = 15;
        public CdmaNumberInfoRec numberInfoRec;
        public int redirectingReason;

        public CdmaRedirectingNumberInfoRec(String number, int numberType, int numberPlan, int pi, int si, int reason) {
            this.numberInfoRec = new CdmaNumberInfoRec(5, number, numberType, numberPlan, pi, si);
            this.redirectingReason = reason;
        }

        public String toString() {
            return "CdmaNumberInfoRec: { numberInfoRec: " + this.numberInfoRec + ", redirectingReason: " + this.redirectingReason + " }";
        }
    }

    public static class CdmaNumberInfoRec {
        public int id;
        public String number;
        public byte numberType;
        public byte numberPlan;
        public byte pi;
        public byte si;

        public CdmaNumberInfoRec(int id2, String number, int numberType, int numberPlan, int pi, int si) {
            this.number = number;
            this.numberType = (byte)numberType;
            this.numberPlan = (byte)numberPlan;
            this.pi = (byte)pi;
            this.si = (byte)si;
        }

        public String toString() {
            return "CdmaNumberInfoRec: { id: " + CdmaInformationRecords.idToString(this.id) + ", number: " + this.number + ", numberType: " + this.numberType + ", numberPlan: " + this.numberPlan + ", pi: " + this.pi + ", si: " + this.si + " }";
        }
    }

    public static class CdmaDisplayInfoRec {
        public int id;
        public String alpha;

        public CdmaDisplayInfoRec(int id2, String alpha) {
            this.id = id2;
            this.alpha = alpha;
        }

        public String toString() {
            return "CdmaDisplayInfoRec: { id: " + CdmaInformationRecords.idToString(this.id) + ", alpha: " + this.alpha + " }";
        }
    }

    public static class CdmaSignalInfoRec {
        public boolean isPresent;
        public int signalType;
        public int alertPitch;
        public int signal;

        public CdmaSignalInfoRec() {
        }

        public CdmaSignalInfoRec(int isPresent, int signalType, int alertPitch, int signal) {
            this.isPresent = isPresent != 0;
            this.signalType = signalType;
            this.alertPitch = alertPitch;
            this.signal = signal;
        }

        public String toString() {
            return "CdmaSignalInfo: { isPresent: " + this.isPresent + ", signalType: " + this.signalType + ", alertPitch: " + this.alertPitch + ", signal: " + this.signal + " }";
        }
    }
}

