/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.net.LinkProperties;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.CellLocation;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.util.Log;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DataConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccFileHandler;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.sip.SipCommandInterface;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SipPhoneBase
extends PhoneBase {
    private static final String LOG_TAG = "SipPhone";
    private RegistrantList mRingbackRegistrants = new RegistrantList();
    private Phone.State state = Phone.State.IDLE;

    public SipPhoneBase(Context context, PhoneNotifier notifier) {
        super(notifier, context, new SipCommandInterface(context), false);
    }

    @Override
    public abstract Call getForegroundCall();

    @Override
    public abstract Call getBackgroundCall();

    @Override
    public abstract Call getRingingCall();

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo) throws CallStateException {
        return this.dial(dialString);
    }

    void migrateFrom(SipPhoneBase from) {
        SipPhoneBase.migrate(this.mRingbackRegistrants, from.mRingbackRegistrants);
        SipPhoneBase.migrate(this.mPreciseCallStateRegistrants, from.mPreciseCallStateRegistrants);
        SipPhoneBase.migrate(this.mNewRingingConnectionRegistrants, from.mNewRingingConnectionRegistrants);
        SipPhoneBase.migrate(this.mIncomingRingRegistrants, from.mIncomingRingRegistrants);
        SipPhoneBase.migrate(this.mDisconnectRegistrants, from.mDisconnectRegistrants);
        SipPhoneBase.migrate(this.mServiceStateRegistrants, from.mServiceStateRegistrants);
        SipPhoneBase.migrate(this.mMmiCompleteRegistrants, from.mMmiCompleteRegistrants);
        SipPhoneBase.migrate(this.mMmiRegistrants, from.mMmiRegistrants);
        SipPhoneBase.migrate(this.mUnknownConnectionRegistrants, from.mUnknownConnectionRegistrants);
        SipPhoneBase.migrate(this.mSuppServiceFailedRegistrants, from.mSuppServiceFailedRegistrants);
    }

    static void migrate(RegistrantList to, RegistrantList from) {
        from.removeCleared();
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            to.add((Registrant)from.get(i));
        }
    }

    @Override
    public void registerForRingbackTone(Handler h, int what, Object obj) {
        this.mRingbackRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForRingbackTone(Handler h) {
        this.mRingbackRegistrants.remove(h);
    }

    protected void startRingbackTone() {
        AsyncResult result = new AsyncResult(null, Boolean.TRUE, null);
        this.mRingbackRegistrants.notifyRegistrants(result);
    }

    protected void stopRingbackTone() {
        AsyncResult result = new AsyncResult(null, Boolean.FALSE, null);
        this.mRingbackRegistrants.notifyRegistrants(result);
    }

    @Override
    public ServiceState getServiceState() {
        ServiceState s = new ServiceState();
        s.setState(0);
        return s;
    }

    @Override
    public CellLocation getCellLocation() {
        return null;
    }

    @Override
    public Phone.State getState() {
        return this.state;
    }

    @Override
    public int getPhoneType() {
        return 3;
    }

    @Override
    public SignalStrength getSignalStrength() {
        return new SignalStrength();
    }

    @Override
    public boolean getMessageWaitingIndicator() {
        return false;
    }

    @Override
    public boolean getCallForwardingIndicator() {
        return false;
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return new ArrayList(0);
    }

    @Override
    public Phone.DataState getDataConnectionState() {
        return Phone.DataState.DISCONNECTED;
    }

    @Override
    public Phone.DataState getDataConnectionState(String apnType) {
        return Phone.DataState.DISCONNECTED;
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        return Phone.DataActivityState.NONE;
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    void notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    void notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
    }

    void notifyUnknownConnection() {
        this.mUnknownConnectionRegistrants.notifyResult(this);
    }

    void notifySuppServiceFailed(Phone.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    void notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    @Override
    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    public boolean canDial() {
        int serviceState = this.getServiceState().getState();
        Log.v(LOG_TAG, "canDial(): serviceState = " + serviceState);
        if (serviceState == 3) {
            return false;
        }
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        Log.v(LOG_TAG, "canDial(): disableCall = " + disableCall);
        if (disableCall.equals("true")) {
            return false;
        }
        Log.v(LOG_TAG, "canDial(): ringingCall: " + (Object)((Object)this.getRingingCall().getState()));
        Log.v(LOG_TAG, "canDial(): foregndCall: " + (Object)((Object)this.getForegroundCall().getState()));
        Log.v(LOG_TAG, "canDial(): backgndCall: " + (Object)((Object)this.getBackgroundCall().getState()));
        return !this.getRingingCall().isRinging() && (!this.getForegroundCall().getState().isAlive() || !this.getBackgroundCall().getState().isAlive());
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) throws CallStateException {
        return false;
    }

    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        return false;
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
    }

    @Override
    public void setRadioPower(boolean power) {
    }

    @Override
    public String getVoiceMailNumber() {
        return null;
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return null;
    }

    @Override
    public String getDeviceId() {
        return null;
    }

    @Override
    public String getDeviceSvn() {
        return null;
    }

    @Override
    public String getImei() {
        return null;
    }

    @Override
    public String getEsn() {
        Log.e(LOG_TAG, "[SipPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public String getMeid() {
        Log.e(LOG_TAG, "[SipPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public String getSubscriberId() {
        return null;
    }

    @Override
    public String getIccSerialNumber() {
        return null;
    }

    @Override
    public String getLine1Number() {
        return null;
    }

    @Override
    public String getLine1AlphaTag() {
        return null;
    }

    @Override
    public void setLine1Number(String alphaTag, String number, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        Log.e(LOG_TAG, "call waiting not supported");
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return false;
    }

    @Override
    public IccCard getIccCard() {
        return null;
    }

    @Override
    public void getAvailableNetworks(Message response) {
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message response) {
    }

    @Override
    public void selectNetworkManually(OperatorInfo network, Message response) {
    }

    @Override
    public void getNeighboringCids(Message response) {
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
    }

    @Override
    public void getDataCallList(Message response) {
    }

    public List<DataConnection> getCurrentDataConnectionList() {
        return null;
    }

    @Override
    public void updateServiceLocation() {
    }

    @Override
    public void enableLocationUpdates() {
    }

    @Override
    public void disableLocationUpdates() {
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return false;
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
    }

    public boolean enableDataConnectivity() {
        return false;
    }

    public boolean disableDataConnectivity() {
        return false;
    }

    @Override
    public boolean isDataConnectivityPossible() {
        return false;
    }

    boolean updateCurrentCarrierInProvider() {
        return false;
    }

    public void saveClirSetting(int commandInterfaceCLIRMode) {
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return null;
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return null;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return null;
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return null;
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Log.e(LOG_TAG, "Error! This functionality is not implemented for SIP.");
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return false;
    }

    @Override
    public LinkProperties getLinkProperties(String apnType) {
        return null;
    }

    void updatePhoneState() {
        Phone.State oldState = this.state;
        this.state = this.getRingingCall().isRinging() ? Phone.State.RINGING : (this.getForegroundCall().isIdle() && this.getBackgroundCall().isIdle() ? Phone.State.IDLE : Phone.State.OFFHOOK);
        if (this.state != oldState) {
            Log.d(LOG_TAG, " ^^^ new phone state: " + (Object)((Object)this.state));
            this.notifyPhoneStateChanged();
        }
    }
}

