/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.multiwaveview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityManager;
import com.android.internal.R;
import com.android.internal.widget.multiwaveview.Ease;
import com.android.internal.widget.multiwaveview.TargetDrawable;
import com.android.internal.widget.multiwaveview.Tweener;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiWaveView
extends View {
    private static final String TAG = "MultiWaveView";
    private static final boolean DEBUG = false;
    private static final int STATE_IDLE = 0;
    private static final int STATE_FIRST_TOUCH = 1;
    private static final int STATE_TRACKING = 2;
    private static final int STATE_SNAP = 3;
    private static final int STATE_FINISH = 4;
    private static final float SNAP_MARGIN_DEFAULT = 20.0f;
    private static final int CHEVRON_INCREMENTAL_DELAY = 160;
    private static final int CHEVRON_ANIMATION_DURATION = 850;
    private static final int RETURN_TO_HOME_DELAY = 1200;
    private static final int RETURN_TO_HOME_DURATION = 300;
    private static final int HIDE_ANIMATION_DELAY = 200;
    private static final int HIDE_ANIMATION_DURATION = 1200;
    private static final int SHOW_ANIMATION_DURATION = 0;
    private static final int SHOW_ANIMATION_DELAY = 0;
    private static final float TAP_RADIUS_SCALE_ACCESSIBILITY_ENABLED = 1.3f;
    private TimeInterpolator mChevronAnimationInterpolator = Ease.Quad.easeOut;
    private ArrayList<TargetDrawable> mTargetDrawables = new ArrayList();
    private ArrayList<TargetDrawable> mChevronDrawables = new ArrayList();
    private ArrayList<Tweener> mChevronAnimations = new ArrayList();
    private ArrayList<Tweener> mTargetAnimations = new ArrayList();
    private ArrayList<String> mTargetDescriptions;
    private ArrayList<String> mDirectionDescriptions;
    private Tweener mHandleAnimation;
    private OnTriggerListener mOnTriggerListener;
    private TargetDrawable mHandleDrawable;
    private TargetDrawable mOuterRing;
    private Vibrator mVibrator;
    private int mFeedbackCount = 3;
    private int mVibrationDuration = 0;
    private int mGrabbedState;
    private int mActiveTarget = -1;
    private float mTapRadius;
    private float mWaveCenterX;
    private float mWaveCenterY;
    private float mVerticalOffset;
    private float mHorizontalOffset;
    private float mOuterRadius = 0.0f;
    private float mHitRadius = 0.0f;
    private float mSnapMargin = 0.0f;
    private boolean mDragging;
    private int mNewTargetResources;
    private Animator.AnimatorListener mResetListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            MultiWaveView.this.switchToState(0, MultiWaveView.this.mWaveCenterX, MultiWaveView.this.mWaveCenterY);
        }
    };
    private Animator.AnimatorListener mResetListenerWithPing = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            MultiWaveView.this.ping();
            MultiWaveView.this.switchToState(0, MultiWaveView.this.mWaveCenterX, MultiWaveView.this.mWaveCenterY);
        }
    };
    private ValueAnimator.AnimatorUpdateListener mUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

        public void onAnimationUpdate(ValueAnimator animation) {
            MultiWaveView.this.invalidateGlobalRegion(MultiWaveView.this.mHandleDrawable);
            MultiWaveView.this.invalidate();
        }
    };
    private boolean mAnimatingTargets;
    private Animator.AnimatorListener mTargetUpdateListener = new AnimatorListenerAdapter(){

        public void onAnimationEnd(Animator animator2) {
            if (MultiWaveView.this.mNewTargetResources != 0) {
                MultiWaveView.this.internalSetTargetResources(MultiWaveView.this.mNewTargetResources);
                MultiWaveView.this.mNewTargetResources = 0;
                MultiWaveView.this.hideTargets(false);
            }
            MultiWaveView.this.mAnimatingTargets = false;
        }
    };
    private int mTargetResourceId;
    private int mTargetDescriptionsResourceId;
    private int mDirectionDescriptionsResourceId;

    public MultiWaveView(Context context) {
        this(context, null);
    }

    public MultiWaveView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int resourceId;
        int[] chevrons;
        Resources res = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MultiWaveView);
        this.mOuterRadius = a.getDimension(9, this.mOuterRadius);
        this.mHorizontalOffset = a.getDimension(15, this.mHorizontalOffset);
        this.mVerticalOffset = a.getDimension(14, this.mVerticalOffset);
        this.mHitRadius = a.getDimension(10, this.mHitRadius);
        this.mSnapMargin = a.getDimension(12, this.mSnapMargin);
        this.mVibrationDuration = a.getInt(11, this.mVibrationDuration);
        this.mFeedbackCount = a.getInt(13, this.mFeedbackCount);
        this.mHandleDrawable = new TargetDrawable(res, a.getDrawable(3));
        this.mTapRadius = this.mHandleDrawable.getWidth() / 2;
        this.mOuterRing = new TargetDrawable(res, a.getDrawable(8));
        for (int chevron : chevrons = new int[]{4, 5, 6, 7}) {
            Drawable chevronDrawable = a.getDrawable(chevron);
            for (int i = 0; i < this.mFeedbackCount; ++i) {
                this.mChevronDrawables.add(chevronDrawable != null ? new TargetDrawable(res, chevronDrawable) : null);
            }
        }
        TypedValue outValue = new TypedValue();
        if (a.getValue(2, outValue)) {
            this.internalSetTargetResources(outValue.resourceId);
        }
        if (this.mTargetDrawables == null || this.mTargetDrawables.size() == 0) {
            throw new IllegalStateException("Must specify at least one target drawable");
        }
        if (a.getValue(0, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify target descriptions");
            }
            this.setTargetDescriptionsResourceId(resourceId);
        }
        if (a.getValue(1, outValue)) {
            resourceId = outValue.resourceId;
            if (resourceId == 0) {
                throw new IllegalStateException("Must specify direction descriptions");
            }
            this.setDirectionDescriptionsResourceId(resourceId);
        }
        a.recycle();
        this.setVibrateEnabled(this.mVibrationDuration > 0);
    }

    private void dump() {
        Log.v(TAG, "Outer Radius = " + this.mOuterRadius);
        Log.v(TAG, "HitRadius = " + this.mHitRadius);
        Log.v(TAG, "SnapMargin = " + this.mSnapMargin);
        Log.v(TAG, "FeedbackCount = " + this.mFeedbackCount);
        Log.v(TAG, "VibrationDuration = " + this.mVibrationDuration);
        Log.v(TAG, "TapRadius = " + this.mTapRadius);
        Log.v(TAG, "WaveCenterX = " + this.mWaveCenterX);
        Log.v(TAG, "WaveCenterY = " + this.mWaveCenterY);
        Log.v(TAG, "HorizontalOffset = " + this.mHorizontalOffset);
        Log.v(TAG, "VerticalOffset = " + this.mVerticalOffset);
    }

    @Override
    protected int getSuggestedMinimumWidth() {
        return this.mOuterRing.getWidth() + (this.mTargetDrawables.size() > 0 ? this.mTargetDrawables.get(0).getWidth() / 2 : 0);
    }

    @Override
    protected int getSuggestedMinimumHeight() {
        return this.mOuterRing.getHeight() + (this.mTargetDrawables.size() > 0 ? this.mTargetDrawables.get(0).getHeight() / 2 : 0);
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.min(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int viewWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int viewHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    private void switchToState(int state, float x, float y) {
        switch (state) {
            case 0: {
                this.deactivateTargets();
                this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
                break;
            }
            case 1: {
                this.stopHandleAnimation();
                this.deactivateTargets();
                this.showTargets(true);
                this.mHandleDrawable.setState(TargetDrawable.STATE_ACTIVE);
                this.setGrabbedState(1);
                if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) break;
                this.announceTargets();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.doFinish();
            }
        }
    }

    private void startChevronAnimation() {
        float r = (float)this.mHandleDrawable.getWidth() * 0.4f;
        float chevronAnimationDistance = this.mOuterRadius * 0.9f;
        float[][] from = new float[][]{{this.mWaveCenterX - r, this.mWaveCenterY}, {this.mWaveCenterX + r, this.mWaveCenterY}, {this.mWaveCenterX, this.mWaveCenterY - r}, {this.mWaveCenterX, this.mWaveCenterY + r}};
        float[][] to = new float[][]{{this.mWaveCenterX - chevronAnimationDistance, this.mWaveCenterY}, {this.mWaveCenterX + chevronAnimationDistance, this.mWaveCenterY}, {this.mWaveCenterX, this.mWaveCenterY - chevronAnimationDistance}, {this.mWaveCenterX, this.mWaveCenterY + chevronAnimationDistance}};
        this.mChevronAnimations.clear();
        float startScale = 0.5f;
        float endScale = 2.0f;
        for (int direction = 0; direction < 4; ++direction) {
            for (int count = 0; count < this.mFeedbackCount; ++count) {
                int delay = count * 160;
                TargetDrawable icon = this.mChevronDrawables.get(direction * this.mFeedbackCount + count);
                if (icon == null) continue;
                this.mChevronAnimations.add(Tweener.to(icon, 850L, "ease", this.mChevronAnimationInterpolator, "delay", delay, "x", new float[]{from[direction][0], to[direction][0]}, "y", new float[]{from[direction][1], to[direction][1]}, "alpha", new float[]{1.0f, 0.0f}, "scaleX", new float[]{0.5f, 2.0f}, "scaleY", new float[]{0.5f, 2.0f}, "onUpdate", this.mUpdateListener));
            }
        }
    }

    private void stopChevronAnimation() {
        for (Tweener anim2 : this.mChevronAnimations) {
            anim2.animator.end();
        }
        this.mChevronAnimations.clear();
    }

    private void stopHandleAnimation() {
        if (this.mHandleAnimation != null) {
            this.mHandleAnimation.animator.end();
            this.mHandleAnimation = null;
        }
    }

    private void deactivateTargets() {
        for (TargetDrawable target : this.mTargetDrawables) {
            target.setState(TargetDrawable.STATE_INACTIVE);
        }
        this.mActiveTarget = -1;
    }

    void invalidateGlobalRegion(TargetDrawable drawable2) {
        int width = drawable2.getWidth();
        int height = drawable2.getHeight();
        RectF childBounds = new RectF(0.0f, 0.0f, width, height);
        childBounds.offset(drawable2.getX() - (float)(width / 2), drawable2.getY() - (float)(height / 2));
        View view = this;
        while (view.getParent() != null && view.getParent() instanceof View) {
            view = (View)((Object)view.getParent());
            view.getMatrix().mapRect(childBounds);
            view.invalidate((int)Math.floor(childBounds.left), (int)Math.floor(childBounds.top), (int)Math.ceil(childBounds.right), (int)Math.ceil(childBounds.bottom));
        }
    }

    private void dispatchTriggerEvent(int whichHandle) {
        this.vibrate();
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onTrigger(this, whichHandle);
        }
    }

    private void dispatchGrabbedEvent(int whichHandler) {
        this.vibrate();
        if (this.mOnTriggerListener != null) {
            this.mOnTriggerListener.onGrabbed(this, whichHandler);
        }
    }

    private void doFinish() {
        int activeTarget = this.mActiveTarget;
        boolean targetHit = activeTarget != -1;
        this.hideTargets(true);
        this.mHandleDrawable.setAlpha(targetHit ? 0.0f : 1.0f);
        if (targetHit) {
            this.mTargetDrawables.get(activeTarget).setState(TargetDrawable.STATE_ACTIVE);
            this.hideUnselected(activeTarget);
            this.dispatchTriggerEvent(this.mActiveTarget);
            this.mHandleAnimation = Tweener.to(this.mHandleDrawable, 0L, "ease", Ease.Quart.easeOut, "delay", 1200, "alpha", Float.valueOf(1.0f), "x", Float.valueOf(this.mWaveCenterX), "y", Float.valueOf(this.mWaveCenterY), "onUpdate", this.mUpdateListener, "onComplete", this.mResetListener);
        } else {
            this.mHandleAnimation = Tweener.to(this.mHandleDrawable, 300L, "ease", Ease.Quart.easeOut, "delay", 0, "alpha", Float.valueOf(1.0f), "x", Float.valueOf(this.mWaveCenterX), "y", Float.valueOf(this.mWaveCenterY), "onUpdate", this.mUpdateListener, "onComplete", this.mDragging ? this.mResetListenerWithPing : this.mResetListener);
        }
        this.setGrabbedState(0);
    }

    private void hideUnselected(int active) {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            if (i == active) continue;
            this.mTargetDrawables.get(i).setAlpha(0.0f);
        }
        this.mOuterRing.setAlpha(0.0f);
    }

    private void hideTargets(boolean animate) {
        if (this.mTargetAnimations.size() > 0) {
            this.stopTargetAnimation();
        }
        this.mAnimatingTargets = animate;
        if (animate) {
            int duration = animate ? 1200 : 0;
            for (TargetDrawable target : this.mTargetDrawables) {
                target.setState(TargetDrawable.STATE_INACTIVE);
                this.mTargetAnimations.add(Tweener.to(target, duration, "alpha", Float.valueOf(0.0f), "delay", 200, "onUpdate", this.mUpdateListener));
            }
            this.mTargetAnimations.add(Tweener.to(this.mOuterRing, duration, "alpha", Float.valueOf(0.0f), "delay", 200, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        } else {
            for (TargetDrawable target : this.mTargetDrawables) {
                target.setState(TargetDrawable.STATE_INACTIVE);
                target.setAlpha(0.0f);
            }
            this.mOuterRing.setAlpha(0.0f);
        }
    }

    private void showTargets(boolean animate) {
        if (this.mTargetAnimations.size() > 0) {
            this.stopTargetAnimation();
        }
        this.mAnimatingTargets = animate;
        if (animate) {
            for (TargetDrawable target : this.mTargetDrawables) {
                target.setState(TargetDrawable.STATE_INACTIVE);
                this.mTargetAnimations.add(Tweener.to(target, 0L, "alpha", Float.valueOf(1.0f), "delay", 0, "onUpdate", this.mUpdateListener));
            }
            this.mTargetAnimations.add(Tweener.to(this.mOuterRing, 0L, "alpha", Float.valueOf(1.0f), "delay", 0, "onUpdate", this.mUpdateListener, "onComplete", this.mTargetUpdateListener));
        } else {
            for (TargetDrawable target : this.mTargetDrawables) {
                target.setState(TargetDrawable.STATE_INACTIVE);
                target.setAlpha(1.0f);
            }
            this.mOuterRing.setAlpha(1.0f);
        }
    }

    private void stopTargetAnimation() {
        for (Tweener anim2 : this.mTargetAnimations) {
            anim2.animator.end();
        }
        this.mTargetAnimations.clear();
    }

    private void vibrate() {
        if (this.mVibrator != null) {
            this.mVibrator.vibrate(this.mVibrationDuration);
        }
    }

    private void internalSetTargetResources(int resourceId) {
        Resources res = this.getContext().getResources();
        TypedArray array2 = res.obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<TargetDrawable> targetDrawables = new ArrayList<TargetDrawable>(count);
        for (int i = 0; i < count; ++i) {
            Drawable drawable2 = array2.getDrawable(i);
            targetDrawables.add(new TargetDrawable(res, drawable2));
        }
        array2.recycle();
        this.mTargetResourceId = resourceId;
        this.mTargetDrawables = targetDrawables;
        this.updateTargetPositions();
    }

    public void setTargetResources(int resourceId) {
        if (this.mAnimatingTargets) {
            this.mNewTargetResources = resourceId;
        } else {
            this.internalSetTargetResources(resourceId);
        }
    }

    public int getTargetResourceId() {
        return this.mTargetResourceId;
    }

    public void setTargetDescriptionsResourceId(int resourceId) {
        this.mTargetDescriptionsResourceId = resourceId;
        if (this.mTargetDescriptions != null) {
            this.mTargetDescriptions.clear();
        }
    }

    public int getTargetDescriptionsResourceId() {
        return this.mTargetDescriptionsResourceId;
    }

    public void setDirectionDescriptionsResourceId(int resourceId) {
        this.mDirectionDescriptionsResourceId = resourceId;
        if (this.mDirectionDescriptions != null) {
            this.mDirectionDescriptions.clear();
        }
    }

    public int getDirectionDescriptionsResourceId() {
        return this.mDirectionDescriptionsResourceId;
    }

    public void setVibrateEnabled(boolean enabled) {
        this.mVibrator = enabled && this.mVibrator == null ? (Vibrator)this.getContext().getSystemService("vibrator") : null;
    }

    public void ping() {
        this.stopChevronAnimation();
        this.startChevronAnimation();
    }

    public void reset(boolean animate) {
        this.stopChevronAnimation();
        this.stopHandleAnimation();
        this.stopTargetAnimation();
        this.hideChevrons();
        this.hideTargets(animate);
        this.mHandleDrawable.setX(this.mWaveCenterX);
        this.mHandleDrawable.setY(this.mWaveCenterY);
        this.mHandleDrawable.setState(TargetDrawable.STATE_INACTIVE);
        Tweener.reset();
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        boolean handled = false;
        switch (action) {
            case 0: {
                this.handleDown(event);
                handled = true;
                break;
            }
            case 2: {
                this.handleMove(event);
                handled = true;
                break;
            }
            case 1: {
                this.handleMove(event);
                this.handleUp(event);
                handled = true;
                break;
            }
            case 3: {
                this.handleMove(event);
                handled = true;
            }
        }
        this.invalidate();
        return handled ? true : super.onTouchEvent(event);
    }

    private void moveHandleTo(float x, float y, boolean animate) {
        this.mHandleDrawable.setX(x);
        this.mHandleDrawable.setY(y);
    }

    private void handleDown(MotionEvent event) {
        if (!this.trySwitchToFirstTouchState(event)) {
            this.mDragging = false;
            this.stopTargetAnimation();
            this.ping();
        }
    }

    private void handleUp(MotionEvent event) {
        this.switchToState(4, event.getX(), event.getY());
    }

    private void handleMove(MotionEvent event) {
        if (!this.mDragging) {
            this.trySwitchToFirstTouchState(event);
            return;
        }
        int activeTarget = -1;
        int historySize = event.getHistorySize();
        for (int k = 0; k < historySize + 1; ++k) {
            boolean singleTarget;
            float x = k < historySize ? event.getHistoricalX(k) : event.getX();
            float y = k < historySize ? event.getHistoricalY(k) : event.getY();
            float tx = x - this.mWaveCenterX;
            float ty = y - this.mWaveCenterY;
            float touchRadius = (float)Math.sqrt(this.dist2(tx, ty));
            float scale = touchRadius > this.mOuterRadius ? this.mOuterRadius / touchRadius : 1.0f;
            float limitX = this.mWaveCenterX + tx * scale;
            float limitY = this.mWaveCenterY + ty * scale;
            boolean bl = singleTarget = this.mTargetDrawables.size() == 1;
            if (singleTarget) {
                float snapRadius = this.mOuterRadius - this.mSnapMargin;
                if (touchRadius > snapRadius) {
                    activeTarget = 0;
                    x = limitX;
                    y = limitY;
                }
            } else {
                float best = Float.MAX_VALUE;
                float hitRadius2 = this.mHitRadius * this.mHitRadius;
                for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
                    TargetDrawable target = this.mTargetDrawables.get(i);
                    float dx = limitX - target.getX();
                    float dy = limitY - target.getY();
                    float dist2 = dx * dx + dy * dy;
                    if (!target.isValid() || !(dist2 < hitRadius2) || !(dist2 < best)) continue;
                    activeTarget = i;
                    best = dist2;
                }
                x = limitX;
                y = limitY;
            }
            if (activeTarget != -1) {
                this.switchToState(3, x, y);
                float newX = singleTarget ? limitX : this.mTargetDrawables.get(activeTarget).getX();
                float newY = singleTarget ? limitY : this.mTargetDrawables.get(activeTarget).getY();
                this.moveHandleTo(newX, newY, false);
                TargetDrawable currentTarget = this.mTargetDrawables.get(activeTarget);
                if (!currentTarget.hasState(TargetDrawable.STATE_FOCUSED)) continue;
                currentTarget.setState(TargetDrawable.STATE_FOCUSED);
                this.mHandleDrawable.setAlpha(0.0f);
                continue;
            }
            this.switchToState(2, x, y);
            this.moveHandleTo(x, y, false);
            this.mHandleDrawable.setAlpha(1.0f);
        }
        this.invalidateGlobalRegion(this.mHandleDrawable);
        if (this.mActiveTarget != activeTarget && activeTarget != -1) {
            this.dispatchGrabbedEvent(activeTarget);
            if (AccessibilityManager.getInstance(this.mContext).isEnabled()) {
                String targetContentDescription = this.getTargetDescription(activeTarget);
                this.announceText(targetContentDescription);
            }
        }
        this.mActiveTarget = activeTarget;
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action = event.getAction();
            switch (action) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action);
        }
        return super.onHoverEvent(event);
    }

    private void setGrabbedState(int newState) {
        if (newState != this.mGrabbedState) {
            if (newState != 0) {
                this.vibrate();
            }
            this.mGrabbedState = newState;
            if (this.mOnTriggerListener != null) {
                this.mOnTriggerListener.onGrabbedStateChange(this, this.mGrabbedState);
            }
        }
    }

    private boolean trySwitchToFirstTouchState(MotionEvent event) {
        float y;
        float dy;
        float x = event.getX();
        float dx = x - this.mWaveCenterX;
        if (this.dist2(dx, dy = (y = event.getY()) - this.mWaveCenterY) <= this.getScaledTapRadiusSquared()) {
            this.switchToState(1, x, y);
            this.moveHandleTo(x, y, false);
            this.mDragging = true;
            return true;
        }
        return false;
    }

    private void performInitialLayout(float centerX, float centerY) {
        if (this.mOuterRadius == 0.0f) {
            this.mOuterRadius = 0.5f * (float)Math.sqrt(this.dist2(centerX, centerY));
        }
        if (this.mHitRadius == 0.0f) {
            this.mHitRadius = (float)this.mTargetDrawables.get(0).getWidth() / 2.0f;
        }
        if (this.mSnapMargin == 0.0f) {
            this.mSnapMargin = TypedValue.applyDimension(1, 20.0f, this.getContext().getResources().getDisplayMetrics());
        }
        this.hideChevrons();
        this.hideTargets(false);
        this.moveHandleTo(centerX, centerY, false);
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        int width = right - left;
        int height = bottom - top;
        float newWaveCenterX = this.mHorizontalOffset + (float)(Math.max(width, this.mOuterRing.getWidth()) / 2);
        float newWaveCenterY = this.mVerticalOffset + (float)(Math.max(height, this.mOuterRing.getHeight()) / 2);
        if (newWaveCenterX != this.mWaveCenterX || newWaveCenterY != this.mWaveCenterY) {
            if (this.mWaveCenterX == 0.0f && this.mWaveCenterY == 0.0f) {
                this.performInitialLayout(newWaveCenterX, newWaveCenterY);
            }
            this.mWaveCenterX = newWaveCenterX;
            this.mWaveCenterY = newWaveCenterY;
            this.mOuterRing.setX(this.mWaveCenterX);
            this.mOuterRing.setY(Math.max(this.mWaveCenterY, this.mWaveCenterY));
            this.updateTargetPositions();
        }
    }

    private void updateTargetPositions() {
        for (int i = 0; i < this.mTargetDrawables.size(); ++i) {
            TargetDrawable targetIcon = this.mTargetDrawables.get(i);
            double angle = Math.PI * -2 * (double)i / (double)this.mTargetDrawables.size();
            float xPosition = this.mWaveCenterX + this.mOuterRadius * (float)Math.cos(angle);
            float yPosition = this.mWaveCenterY + this.mOuterRadius * (float)Math.sin(angle);
            targetIcon.setX(xPosition);
            targetIcon.setY(yPosition);
        }
    }

    private void hideChevrons() {
        for (TargetDrawable chevron : this.mChevronDrawables) {
            if (chevron == null) continue;
            chevron.setAlpha(0.0f);
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        this.mOuterRing.draw(canvas);
        for (TargetDrawable target : this.mTargetDrawables) {
            if (target == null) continue;
            target.draw(canvas);
        }
        for (TargetDrawable target : this.mChevronDrawables) {
            if (target == null) continue;
            target.draw(canvas);
        }
        this.mHandleDrawable.draw(canvas);
    }

    public void setOnTriggerListener(OnTriggerListener listener) {
        this.mOnTriggerListener = listener;
    }

    private float square(float d) {
        return d * d;
    }

    private float dist2(float dx, float dy) {
        return dx * dx + dy * dy;
    }

    private float getScaledTapRadiusSquared() {
        float scaledTapRadius = AccessibilityManager.getInstance(this.mContext).isEnabled() ? 1.3f * this.mTapRadius : this.mTapRadius;
        return this.square(scaledTapRadius);
    }

    private void announceTargets() {
        StringBuilder utterance = new StringBuilder();
        int targetCount = this.mTargetDrawables.size();
        for (int i = 0; i < targetCount; ++i) {
            String targetDescription = this.getTargetDescription(i);
            String directionDescription = this.getDirectionDescription(i);
            if (!TextUtils.isEmpty(targetDescription) && !TextUtils.isEmpty(directionDescription)) {
                String text = String.format(directionDescription, targetDescription);
                utterance.append(text);
            }
            if (utterance.length() <= 0) continue;
            this.announceText(utterance.toString());
        }
    }

    private void announceText(String text) {
        this.setContentDescription(text);
        this.sendAccessibilityEvent(8);
        this.setContentDescription(null);
    }

    private String getTargetDescription(int index) {
        if (this.mTargetDescriptions == null || this.mTargetDescriptions.isEmpty()) {
            this.mTargetDescriptions = this.loadDescriptions(this.mTargetDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mTargetDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be euqal to the number of target descriptions.");
                return null;
            }
        }
        return this.mTargetDescriptions.get(index);
    }

    private String getDirectionDescription(int index) {
        if (this.mDirectionDescriptions == null || this.mDirectionDescriptions.isEmpty()) {
            this.mDirectionDescriptions = this.loadDescriptions(this.mDirectionDescriptionsResourceId);
            if (this.mTargetDrawables.size() != this.mDirectionDescriptions.size()) {
                Log.w(TAG, "The number of target drawables must be euqal to the number of direction descriptions.");
                return null;
            }
        }
        return this.mDirectionDescriptions.get(index);
    }

    private ArrayList<String> loadDescriptions(int resourceId) {
        TypedArray array2 = this.getContext().getResources().obtainTypedArray(resourceId);
        int count = array2.length();
        ArrayList<String> targetContentDescriptions = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            String contentDescription = array2.getString(i);
            targetContentDescriptions.add(contentDescription);
        }
        array2.recycle();
        return targetContentDescriptions;
    }

    public static interface OnTriggerListener {
        public static final int NO_HANDLE = 0;
        public static final int CENTER_HANDLE = 1;

        public void onGrabbed(View var1, int var2);

        public void onReleased(View var1, int var2);

        public void onTrigger(View var1, int var2);

        public void onGrabbedStateChange(View var1, int var2);
    }
}

