/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Bitmap_Delegate;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.ResourceHelper;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class CustomBar
extends LinearLayout {
    protected abstract TextView getStyleableTextView();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomBar(Context context, Density density, String string2, String string3) throws XmlPullParserException {
        super(context);
        this.setOrientation(0);
        this.setGravity(16);
        LayoutInflater layoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        XmlPullParser xmlPullParser = ParserFactory.create(this.getClass().getResourceAsStream(string2), string3);
        BridgeXmlBlockParser bridgeXmlBlockParser = new BridgeXmlBlockParser(xmlPullParser, (BridgeContext)context, false);
        try {
            layoutInflater.inflate(bridgeXmlBlockParser, (ViewGroup)this, true);
        }
        finally {
            bridgeXmlBlockParser.ensurePopped();
        }
    }

    private InputStream getIcon(String string2, Density[] densityArray, String[] stringArray, boolean bl) {
        Density density = densityArray[0];
        stringArray[0] = "/bars/" + density.getResourceValue() + "/" + string2;
        InputStream inputStream = this.getClass().getResourceAsStream(stringArray[0]);
        if (inputStream == null && bl) {
            for (Density density2 : Density.values()) {
                if (density2 == density) continue;
                densityArray[0] = density2;
                inputStream = this.getIcon(string2, densityArray, stringArray, false);
                if (inputStream == null) continue;
                return inputStream;
            }
        }
        return inputStream;
    }

    protected void loadIcon(int n, String string2, Density density) {
        View view = this.getChildAt(n);
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            String[] stringArray = new String[1];
            Density[] densityArray = new Density[]{density};
            InputStream inputStream = this.getIcon(string2, densityArray, stringArray, true);
            density = densityArray[0];
            if (inputStream != null) {
                Bitmap bitmap = Bridge.getCachedBitmap(stringArray[0], true);
                if (bitmap == null) {
                    try {
                        bitmap = Bitmap_Delegate.createBitmap(inputStream, false, density);
                        Bridge.setCachedBitmap(stringArray[0], bitmap, true);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                }
                if (bitmap != null) {
                    BitmapDrawable bitmapDrawable = new BitmapDrawable(this.getContext().getResources(), bitmap);
                    imageView.setBackgroundDrawable(bitmapDrawable);
                }
            }
        }
    }

    protected void loadIcon(int n, String string2) {
        ResourceValue resourceValue = this.getResourceValue(string2);
        if (resourceValue != null) {
            this.loadIcon(n, resourceValue);
        }
    }

    protected void loadIconById(int n, String string2) {
        ResourceValue resourceValue = this.getResourceValue(string2);
        if (resourceValue != null) {
            this.loadIconById(n, resourceValue);
        }
    }

    protected Drawable loadIcon(int n, ResourceType resourceType, String string2) {
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources renderResources = bridgeContext.getRenderResources();
        ResourceValue resourceValue = renderResources.getFrameworkResource(resourceType, string2);
        resourceValue = renderResources.resolveResValue(resourceValue);
        return this.loadIcon(n, resourceValue);
    }

    private Drawable loadIcon(int n, ResourceValue resourceValue) {
        View view = this.getChildAt(n);
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            return this.loadIcon(imageView, resourceValue);
        }
        return null;
    }

    private Drawable loadIconById(int n, ResourceValue resourceValue) {
        View view = this.findViewById(n);
        if (view instanceof ImageView) {
            ImageView imageView = (ImageView)view;
            return this.loadIcon(imageView, resourceValue);
        }
        return null;
    }

    private Drawable loadIcon(ImageView imageView, ResourceValue resourceValue) {
        Drawable drawable2 = ResourceHelper.getDrawable(resourceValue, (BridgeContext)this.mContext);
        if (drawable2 != null) {
            imageView.setImageDrawable(drawable2);
        }
        return drawable2;
    }

    protected TextView setText(int n, String string2) {
        View view = this.getChildAt(n);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            this.setText(textView, string2);
            return textView;
        }
        return null;
    }

    protected TextView setTextById(int n, String string2) {
        View view = this.findViewById(n);
        if (view instanceof TextView) {
            TextView textView = (TextView)view;
            this.setText(textView, string2);
            return textView;
        }
        return null;
    }

    private void setText(TextView textView, String string2) {
        ResourceValue resourceValue = this.getResourceValue(string2);
        if (resourceValue != null) {
            textView.setText(resourceValue.getValue());
        } else {
            textView.setText(string2);
        }
    }

    protected void setStyle(String string2) {
        Object object;
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources renderResources = bridgeContext.getRenderResources();
        ResourceValue resourceValue = renderResources.findItemInTheme(string2);
        if (!((resourceValue = renderResources.resolveResValue(resourceValue)) instanceof StyleResourceValue)) {
            return;
        }
        StyleResourceValue styleResourceValue = (StyleResourceValue)resourceValue;
        ResourceValue resourceValue2 = renderResources.findItemInStyle(styleResourceValue, "background");
        if ((resourceValue2 = renderResources.resolveResValue(resourceValue2)) != null && (object = ResourceHelper.getDrawable(resourceValue2, bridgeContext)) != null) {
            this.setBackgroundDrawable((Drawable)object);
        }
        if ((object = this.getStyleableTextView()) != null) {
            ResourceValue resourceValue3 = renderResources.findItemInStyle(styleResourceValue, "titleTextStyle");
            if ((resourceValue3 = renderResources.resolveResValue(resourceValue3)) instanceof StyleResourceValue) {
                ColorStateList colorStateList;
                TypedValue typedValue;
                StyleResourceValue styleResourceValue2 = (StyleResourceValue)resourceValue3;
                ResourceValue resourceValue4 = renderResources.findItemInStyle(styleResourceValue2, "textSize");
                if ((resourceValue4 = renderResources.resolveResValue(resourceValue4)) != null) {
                    typedValue = new TypedValue();
                    if (ResourceHelper.parseFloatAttribute("textSize", resourceValue4.getValue(), typedValue, true)) {
                        ((TextView)object).setTextSize(typedValue.getDimension(bridgeContext.getResources().getDisplayMetrics()));
                    }
                }
                typedValue = renderResources.findItemInStyle(styleResourceValue2, "textColor");
                if ((typedValue = renderResources.resolveResValue((ResourceValue)typedValue)) != null && (colorStateList = ResourceHelper.getColorStateList((ResourceValue)typedValue, bridgeContext)) != null) {
                    ((TextView)object).setTextColor(colorStateList);
                }
            }
        }
    }

    private ResourceValue getResourceValue(String string2) {
        BridgeContext bridgeContext = (BridgeContext)this.mContext;
        RenderResources renderResources = bridgeContext.getRenderResources();
        ResourceValue resourceValue = renderResources.findResValue(string2, false);
        return renderResources.resolveResValue(resourceValue);
    }
}

