/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.impl.binding;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.ImageView;
import android.widget.TextView;
import com.android.ide.common.rendering.api.AdapterBinding;
import com.android.ide.common.rendering.api.DataBindingItem;
import com.android.ide.common.rendering.api.IProjectCallback;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import com.android.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BaseAdapter {
    private final AdapterBinding mBinding;
    private final IProjectCallback mCallback;
    private final ResourceReference mAdapterRef;
    private boolean mSkipCallbackParser = false;
    protected final List<AdapterItem> mItems = new ArrayList<AdapterItem>();

    protected BaseAdapter(ResourceReference resourceReference, AdapterBinding adapterBinding, IProjectCallback iProjectCallback) {
        this.mAdapterRef = resourceReference;
        this.mBinding = adapterBinding;
        this.mCallback = iProjectCallback;
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean hasStableIds() {
        return true;
    }

    public boolean isEmpty() {
        return this.mItems.size() == 0;
    }

    public void registerDataSetObserver(DataSetObserver dataSetObserver) {
    }

    public void unregisterDataSetObserver(DataSetObserver dataSetObserver) {
    }

    protected AdapterBinding getBinding() {
        return this.mBinding;
    }

    protected View getView(AdapterItem adapterItem, AdapterItem adapterItem2, View view, ViewGroup viewGroup) {
        DataBindingItem dataBindingItem = adapterItem.getDataBindingItem();
        BridgeContext bridgeContext = RenderAction.getCurrentContext();
        Pair<View, Boolean> pair = bridgeContext.inflateView(dataBindingItem.getViewReference(), viewGroup, false, this.mSkipCallbackParser);
        View view2 = (View)pair.getFirst();
        this.mSkipCallbackParser |= ((Boolean)pair.getSecond()).booleanValue();
        if (view2 != null) {
            this.fillView(bridgeContext, view2, adapterItem, adapterItem2);
        } else {
            TextView textView = new TextView(bridgeContext);
            textView.setText("Unable to find layout: " + dataBindingItem.getViewReference().getName());
            view2 = textView;
        }
        return view2;
    }

    private void fillView(BridgeContext bridgeContext, View view, AdapterItem adapterItem, AdapterItem adapterItem2) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.fillView(bridgeContext, viewGroup.getChildAt(i), adapterItem, adapterItem2);
            }
        } else {
            ResourceReference resourceReference;
            int n = view.getId();
            if (n != 0 && (resourceReference = bridgeContext.resolveId(n)) != null) {
                Object object;
                Object object2;
                int n2;
                int n3 = adapterItem.getFullPosition();
                int n4 = adapterItem.getPositionPerType();
                int n5 = adapterItem2 != null ? adapterItem2.getFullPosition() : 0;
                int n6 = n2 = adapterItem2 != null ? adapterItem2.getPositionPerType() : 0;
                if (view instanceof TextView) {
                    object2 = (TextView)view;
                    object = this.mCallback.getAdapterItemValue(this.mAdapterRef, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference, IProjectCallback.ViewAttribute.TEXT, (Object)((Object)((TextView)object2).getText()).toString());
                    if (object != null) {
                        if (object.getClass() != IProjectCallback.ViewAttribute.TEXT.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected String, got %s", object.getClass().getName()), null);
                        } else {
                            ((TextView)object2).setText((String)object);
                        }
                    }
                }
                if (view instanceof Checkable) {
                    object2 = (Checkable)((Object)view);
                    object = this.mCallback.getAdapterItemValue(this.mAdapterRef, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference, IProjectCallback.ViewAttribute.IS_CHECKED, (Object)object2.isChecked());
                    if (object != null) {
                        if (object.getClass() != IProjectCallback.ViewAttribute.IS_CHECKED.getAttributeClass()) {
                            Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", object.getClass().getName()), null);
                        } else {
                            object2.setChecked((Boolean)object);
                        }
                    }
                }
                if (view instanceof ImageView) {
                    object2 = (ImageView)view;
                    object = this.mCallback.getAdapterItemValue(this.mAdapterRef, bridgeContext.getViewKey(view), adapterItem.getDataBindingItem().getViewReference(), n3, n4, n5, n2, resourceReference, IProjectCallback.ViewAttribute.SRC, (Object)((ImageView)object2).getDrawable());
                    if (object != null && object.getClass() != IProjectCallback.ViewAttribute.SRC.getAttributeClass()) {
                        Bridge.getLog().error("broken", String.format("Wrong Adapter Item value class for TEXT. Expected Boolean, got %s", object.getClass().getName()), null);
                    }
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static final class AdapterItem {
        private final DataBindingItem mItem;
        private final int mType;
        private final int mFullPosition;
        private final int mPositionPerType;
        private List<AdapterItem> mChildren;

        protected AdapterItem(DataBindingItem dataBindingItem, int n, int n2, int n3) {
            this.mItem = dataBindingItem;
            this.mType = n;
            this.mFullPosition = n2;
            this.mPositionPerType = n3;
        }

        void addChild(AdapterItem adapterItem) {
            if (this.mChildren == null) {
                this.mChildren = new ArrayList<AdapterItem>();
            }
            this.mChildren.add(adapterItem);
        }

        List<AdapterItem> getChildren() {
            if (this.mChildren != null) {
                return this.mChildren;
            }
            return Collections.emptyList();
        }

        int getType() {
            return this.mType;
        }

        int getFullPosition() {
            return this.mFullPosition;
        }

        int getPositionPerType() {
            return this.mPositionPerType;
        }

        DataBindingItem getDataBindingItem() {
            return this.mItem;
        }
    }
}

