/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.xml;

import com.android.tools.layoutlib.create.OverrideMethod;
import org.xml.sax.Attributes;

abstract class ExpatAttributes
implements Attributes {
    private static final String CDATA = "CDATA";

    ExpatAttributes() {
    }

    public abstract int getLength();

    abstract int getParserPointer();

    public abstract int getPointer();

    public String getURI(int index) {
        if (index < 0 || index >= this.getLength()) {
            return null;
        }
        return ExpatAttributes.getURI(this.getParserPointer(), this.getPointer(), index);
    }

    public String getLocalName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getLocalName(this.getParserPointer(), this.getPointer(), index);
    }

    public String getQName(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getQName(this.getParserPointer(), this.getPointer(), index);
    }

    public String getType(int index) {
        return index < 0 || index >= this.getLength() ? null : CDATA;
    }

    public String getValue(int index) {
        return index < 0 || index >= this.getLength() ? null : ExpatAttributes.getValueByIndex(this.getPointer(), index);
    }

    public int getIndex(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return -1;
        }
        return ExpatAttributes.getIndex(pointer, uri, localName);
    }

    public int getIndex(String qName) {
        if (qName == null) {
            throw new NullPointerException("uri");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return -1;
        }
        return ExpatAttributes.getIndexForQName(pointer, qName);
    }

    public String getType(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        return this.getIndex(uri, localName) == -1 ? null : CDATA;
    }

    public String getType(String qName) {
        return this.getIndex(qName) == -1 ? null : CDATA;
    }

    public String getValue(String uri, String localName) {
        if (uri == null) {
            throw new NullPointerException("uri");
        }
        if (localName == null) {
            throw new NullPointerException("local name");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return null;
        }
        return ExpatAttributes.getValue(pointer, uri, localName);
    }

    public String getValue(String qName) {
        if (qName == null) {
            throw new NullPointerException("qName");
        }
        int pointer = this.getPointer();
        if (pointer == 0) {
            return null;
        }
        return ExpatAttributes.getValueForQName(pointer, qName);
    }

    private static String getURI(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getURI(III)Ljava/lang/String;", true, null);
    }

    private static String getLocalName(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getLocalName(III)Ljava/lang/String;", true, null);
    }

    private static String getQName(int n, int n2, int n3) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getQName(III)Ljava/lang/String;", true, null);
    }

    private static String getValueByIndex(int n, int n2) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValueByIndex(II)Ljava/lang/String;", true, null);
    }

    private static int getIndex(int n, String string2, String string3) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatAttributes#getIndex(ILjava/lang/String;Ljava/lang/String;)I", true, null);
    }

    private static int getIndexForQName(int n, String string2) {
        return OverrideMethod.invokeI("org.apache.harmony.xml.ExpatAttributes#getIndexForQName(ILjava/lang/String;)I", true, null);
    }

    private static String getValue(int n, String string2, String string3) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValue(ILjava/lang/String;Ljava/lang/String;)Ljava/lang/String;", true, null);
    }

    private static String getValueForQName(int n, String string2) {
        return (String)OverrideMethod.invokeA("org.apache.harmony.xml.ExpatAttributes#getValueForQName(ILjava/lang/String;)Ljava/lang/String;", true, null);
    }

    protected void freeAttributes(int n) {
        OverrideMethod.invokeV("org.apache.harmony.xml.ExpatAttributes#freeAttributes(I)V", true, this);
    }
}

