package com.baidu.mapapi.demo;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import com.baidu.mapapi.MyLocationOverlay;
import com.baidu.mapapi.ItemizedOverlay;
import com.baidu.mapapi.MKLocationManager;
import com.baidu.mapapi.OverlayItem;
import com.baidu.mapapi.GeoPoint;
import com.baidu.mapapi.MapController;
import com.baidu.mapapi.MapView;
import com.baidu.mapapi.BMapManager;
import com.baidu.mapapi.MapActivity;
import com.baidu.mapapi.Projection;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.location.Location;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import android.widget.Toast;

public class BMapApiDemo extends MapActivity implements com.baidu.mapapi.LocationListener  {
	
	BMapManager mBMapMan = null;
	MKLocationManager mLocationManager = null;
	String mStrLog = null;
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);

        mBMapMan = ((Mapdemo)getApplication()).mBMapMan;
        if (mBMapMan == null) {
        	((Mapdemo)getApplication()).mBMapMan = new BMapManager(getApplication());
        	//keyַhttp://dev.baidu.com/wiki/static/imap/key/
        	((Mapdemo)getApplication()).mBMapMan.init("Чkey", new Mapdemo.MyGeneralListener());
        	mBMapMan = ((Mapdemo)getApplication()).mBMapMan;
        }
        // ʹõͼSDKʼͼActivity
        super.initMapActivity(mBMapMan);
        mLocationManager = mBMapMan.getLocationManager();
        mLocationManager.requestLocationUpdates(this);

        // ҪʹöλܣʼLocationģ
        mLocationManager.disableProvider((int) MKLocationManager.MK_GPS_PROVIDER);
        
        MapView mMapView = (MapView) findViewById(R.id.bmapsView);
		mMapView.setBuiltInZoomControls(true);  //õſؼ
		//mMapView.setTraffic(true);
		
		MapController mMapController = mMapView.getController();  // õmMapViewĿȨ,ƺƽƺ
		GeoPoint point = new GeoPoint((int) (39.915 * 1E6),
				(int) (116.404 * 1E6));  //øľγȹһGeoPointλ΢ ( * 1E6)
		mMapController.setCenter(point);  //õͼĵ
		mMapController.setZoom(12);    //õͼzoom
		
		Drawable marker = getResources().getDrawable(R.drawable.iconmarka);  //õҪڵͼϵԴ
		marker.setBounds(0, 0, marker.getIntrinsicWidth(), marker
				.getIntrinsicHeight());   //Ϊmakerλúͱ߽
		
		mMapView.getOverlays().add(new OverItemT(marker, this)); //ItemizedOverlayʵmMapView

		// Ӷλͼ
		MyLocationOverlay mylocTest = new MyLocationOverlay(this, mMapView);
		mylocTest.enableMyLocation();
		mylocTest.enableCompass(); // ָ
		mMapView.getOverlays().add(mylocTest);
    }
	@Override
	protected void onDestroy() {
		if (mBMapMan != null) {
			mBMapMan.destroy();
			((Mapdemo)getApplication()).mBMapMan = null;
			mBMapMan = null;
		}
		mLocationManager = null;
		
		super.onDestroy();
	}
	@Override
	protected void onPause() {
		if (mBMapMan != null) {
			mBMapMan.stop();
		}
		super.onPause();
	}
	@Override
	protected void onResume() {
		if (mBMapMan != null) {
			mBMapMan.start();
		}
		super.onResume();
	}

	class OverItemT extends ItemizedOverlay<OverlayItem> {
		private List<OverlayItem> GeoList = new ArrayList<OverlayItem>();
		private Context mContext;
	
		private double mLat1 = 39.90923;//39.9022; // point1γ
		private double mLon1 = 116.397428;//116.3822; // point1
	
		private double mLat2 = 39.9022;
		private double mLon2 = 116.3922;
	
		private double mLat3 = 39.917723;
		private double mLon3 = 116.3722;
	
		public OverItemT(Drawable marker, Context context) {
			super(boundCenterBottom(marker));

			this.mContext = context;
	
			// øľγȹGeoPointλ΢ ( * 1E6)
			GeoPoint p1 = new GeoPoint((int) (mLat1 * 1E6), (int) (mLon1 * 1E6));
			GeoPoint p2 = new GeoPoint((int) (mLat2 * 1E6), (int) (mLon2 * 1E6));
			GeoPoint p3 = new GeoPoint((int) (mLat3 * 1E6), (int) (mLon3 * 1E6));
	
			GeoList.add(new OverlayItem(p1, "P1", "point1"));
			GeoList.add(new OverlayItem(p2, "P2", "point2"));
			GeoList.add(new OverlayItem(p3, "P3", "point3"));		
			populate();  //createItem(int)itemһݣڵǰȵ
		}
	
		@Override
		public void draw(Canvas canvas, MapView mapView, boolean shadow) {
	
			// ProjectionӿĻصϵͳ͵澭γȵϵͳ֮ı任
			Projection projection = mapView.getProjection(); 
			for (int index = size() - 1; index >= 0; index--) { // GeoList
				OverlayItem overLayItem = getItem(index); // õitem
	
				String title = overLayItem.getTitle();
				// Ѿγȱ任MapViewϽǵĻ
				Point point = projection.toPixels(overLayItem.getPoint(), null); 
	
				Paint paintCircle = new Paint();
				paintCircle.setColor(Color.RED);
				canvas.drawCircle(point.x, point.y, 5, paintCircle); // Բ
	
				Paint paintText = new Paint();
				paintText.setColor(Color.BLACK);
				paintText.setTextSize(15);
				canvas.drawText(title, point.x, point.y - 25, paintText); // ı
	
			}
	
			super.draw(canvas, mapView, shadow);
		}
	
		@Override
		protected OverlayItem createItem(int i) {
			return GeoList.get(i);
		}
	
		@Override
		public int size() {
			return GeoList.size();
		}
	
		@Override
		// ¼
		protected boolean onTap(int i) {
			setFocus(GeoList.get(i));
			Toast.makeText(this.mContext, GeoList.get(i).getSnippet(),
					Toast.LENGTH_SHORT).show();
			return true;
		}
	
		@Override
		public boolean onSnapToItem(int i, int j, Point point, MapView mapview) {
			return false;
		}
	}

	@Override
	protected boolean isRouteDisplayed() {
		return false;
	}
	@Override
	public void onLocationChanged(Location location) {
		if (location != null) {
			Calendar cal = Calendar.getInstance();
			int m = cal.get(Calendar.MONTH);
			int d = cal.get(Calendar.DATE);
			int h = cal.get(Calendar.HOUR_OF_DAY);
			int mi = cal.get(Calendar.MINUTE);
			int s = cal.get(Calendar.SECOND);
			String strLog = String.format("%d-%d,%d:%d:%d x:%f,y%f", m,d,h,mi,s, 
					location.getLongitude(), location.getLatitude());
	
			TextView mainText = (TextView)findViewById(R.id.textview);
	        Log.d("location", strLog);
	        mStrLog = strLog;
	        mainText.setText(mStrLog);
			
		}
	}
}

