/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.AndrolibException;
import brut.androlib.err.CantFindFrameworkResException;
import brut.androlib.res.ResSmaliUpdater;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.data.value.ResXmlSerializable;
import brut.androlib.res.decoder.ARSCDecoder;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResAttrDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtFile;
import brut.androlib.res.util.ExtMXSerializer;
import brut.common.BrutException;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import brut.util.Duo;
import brut.util.Jar;
import brut.util.OS;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.xmlpull.v1.XmlSerializer;

public final class AndrolibResources {
    public static boolean sKeepBroken = false;
    private static final Logger LOGGER = Logger.getLogger(AndrolibResources.class.getName());

    public ResTable getResTable(ExtFile extFile) throws AndrolibException {
        ResTable resTable = new ResTable(this);
        this.loadMainPkg(resTable, extFile);
        return resTable;
    }

    public ResPackage loadMainPkg(ResTable resTable, ExtFile extFile) throws AndrolibException {
        LOGGER.info("Loading resource table...");
        ResPackage[] resPackageArray = this.getResPackagesFromApk(extFile, resTable, sKeepBroken);
        ResPackage resPackage = null;
        switch (resPackageArray.length) {
            case 1: {
                resPackage = resPackageArray[0];
                break;
            }
            case 2: {
                if (!resPackageArray[0].getName().equals("android")) break;
                LOGGER.warning("Skipping \"android\" package group");
                resPackage = resPackageArray[1];
            }
        }
        if (resPackage == null) {
            throw new AndrolibException("Arsc files with zero or multiple packages");
        }
        resTable.addPackage(resPackage, true);
        return resPackage;
    }

    public ResPackage loadFrameworkPkg(ResTable resTable, int n, String string) throws AndrolibException {
        File file = this.getFrameworkApk(n, string);
        LOGGER.info("Loading resource table from file: " + file);
        ResPackage[] resPackageArray = this.getResPackagesFromApk(new ExtFile(file), resTable, true);
        if (resPackageArray.length != 1) {
            throw new AndrolibException("Arsc files with zero or multiple packages");
        }
        ResPackage resPackage = resPackageArray[0];
        if (resPackage.getId() != n) {
            throw new AndrolibException("Expected pkg of id: " + String.valueOf(n) + ", got: " + resPackage.getId());
        }
        resTable.addPackage(resPackage, false);
        return resPackage;
    }

    public void decode(ResTable resTable, ExtFile extFile, File file) throws AndrolibException {
        Directory directory;
        Duo<ResFileDecoder, AXmlResourceParser> duo = this.getResFileDecoder();
        ResFileDecoder resFileDecoder = (ResFileDecoder)duo.m1;
        ResAttrDecoder resAttrDecoder = ((AXmlResourceParser)duo.m2).getAttrDecoder();
        resAttrDecoder.setCurrentPackage(resTable.listMainPackages().iterator().next());
        Directory directory2 = null;
        try {
            Directory directory3 = extFile.getDirectory();
            directory = new FileDirectory(file);
            resFileDecoder.decode(directory3, "AndroidManifest.xml", directory, "AndroidManifest.xml", "xml");
            if (directory3.containsDir("res")) {
                directory2 = directory3.getDir("res");
            }
            directory = directory.createDir("res");
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException(directoryException);
        }
        ExtMXSerializer extMXSerializer = this.getResXmlSerializer();
        for (ResPackage resPackage : resTable.listMainPackages()) {
            resAttrDecoder.setCurrentPackage(resPackage);
            for (ResResource resResource : resPackage.listFiles()) {
                resFileDecoder.decode(resResource, directory2, directory);
            }
            for (ResValuesFile resValuesFile : resPackage.listValuesFiles()) {
                this.generateValuesFile(resValuesFile, directory, extMXSerializer);
            }
            this.generatePublicXml(resPackage, directory, extMXSerializer);
        }
        AndrolibException androlibException = ((AXmlResourceParser)duo.m2).getFirstError();
        if (androlibException != null) {
            throw androlibException;
        }
    }

    public void aaptPackage(File file, File file2, File file3, File file4, File file5, File[] fileArray, boolean bl, boolean bl2) throws AndrolibException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("aapt");
        arrayList.add("p");
        if (bl) {
            arrayList.add("-u");
        }
        arrayList.add("-F");
        arrayList.add(file.getAbsolutePath());
        if (bl2) {
            arrayList.add("-x");
        }
        if (fileArray != null) {
            for (File file6 : fileArray) {
                arrayList.add("-I");
                arrayList.add(file6.getPath());
            }
        }
        if (file3 != null) {
            arrayList.add("-S");
            arrayList.add(file3.getAbsolutePath());
        }
        if (file2 != null) {
            arrayList.add("-M");
            arrayList.add(file2.getAbsolutePath());
        }
        if (file5 != null) {
            arrayList.add("-A");
            arrayList.add(file5.getAbsolutePath());
        }
        if (file4 != null) {
            arrayList.add(file4.getAbsolutePath());
        }
        try {
            OS.exec(arrayList.toArray(new String[0]));
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public boolean detectWhetherAppIsFramework(File file) throws AndrolibException {
        LineIterator lineIterator;
        File file2 = new File(file, "res/values/public.xml");
        if (!file2.exists()) {
            return false;
        }
        try {
            lineIterator = IOUtils.lineIterator(new FileReader(new File(file, "res/values/public.xml")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new AndrolibException("Could not detect whether app is framework one", fileNotFoundException);
        }
        lineIterator.next();
        lineIterator.next();
        return ((String)lineIterator.next()).contains("0x01");
    }

    public void tagSmaliResIDs(ResTable resTable, File file) throws AndrolibException {
        new ResSmaliUpdater().tagResIDs(resTable, file);
    }

    public void updateSmaliResIDs(ResTable resTable, File file) throws AndrolibException {
        new ResSmaliUpdater().updateResIDs(resTable, file);
    }

    public Duo<ResFileDecoder, AXmlResourceParser> getResFileDecoder() {
        ResStreamDecoderContainer resStreamDecoderContainer = new ResStreamDecoderContainer();
        resStreamDecoderContainer.setDecoder("raw", new ResRawStreamDecoder());
        resStreamDecoderContainer.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser aXmlResourceParser = new AXmlResourceParser();
        aXmlResourceParser.setAttrDecoder(new ResAttrDecoder());
        resStreamDecoderContainer.setDecoder("xml", new XmlPullStreamDecoder(aXmlResourceParser, this.getResXmlSerializer()));
        return new Duo<ResFileDecoder, AXmlResourceParser>(new ResFileDecoder(resStreamDecoderContainer), aXmlResourceParser);
    }

    public ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer extMXSerializer = new ExtMXSerializer();
        extMXSerializer.getClass();
        extMXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        extMXSerializer.getClass();
        extMXSerializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        extMXSerializer.setProperty("DEFAULT_ENCODING", "UTF-8");
        return extMXSerializer;
    }

    private void generateValuesFile(ResValuesFile resValuesFile, Directory directory, XmlSerializer xmlSerializer) throws AndrolibException {
        try {
            OutputStream outputStream = directory.getFileOutput(resValuesFile.getPath());
            xmlSerializer.setOutput(outputStream, null);
            xmlSerializer.startDocument(null, null);
            xmlSerializer.startTag(null, "resources");
            for (ResResource resResource : resValuesFile.listResources()) {
                if (resValuesFile.isSynthesized(resResource)) continue;
                ((ResXmlSerializable)((Object)resResource.getValue())).serializeToXml(xmlSerializer, resResource);
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not generate: " + resValuesFile.getPath(), iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not generate: " + resValuesFile.getPath(), directoryException);
        }
    }

    private void generatePublicXml(ResPackage resPackage, Directory directory, XmlSerializer xmlSerializer) throws AndrolibException {
        try {
            OutputStream outputStream = directory.getFileOutput("values/public.xml");
            xmlSerializer.setOutput(outputStream, null);
            xmlSerializer.startDocument(null, null);
            xmlSerializer.startTag(null, "resources");
            for (ResResSpec resResSpec : resPackage.listResSpecs()) {
                xmlSerializer.startTag(null, "public");
                xmlSerializer.attribute(null, "type", resResSpec.getType().getName());
                xmlSerializer.attribute(null, "name", resResSpec.getName());
                xmlSerializer.attribute(null, "id", String.format("0x%08x", resResSpec.getId().id));
                xmlSerializer.endTag(null, "public");
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new AndrolibException("Could not generate public.xml file", iOException);
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not generate public.xml file", directoryException);
        }
    }

    private ResPackage[] getResPackagesFromApk(ExtFile extFile, ResTable resTable, boolean bl) throws AndrolibException {
        try {
            return ARSCDecoder.decode(extFile.getDirectory().getFileInput("resources.arsc"), false, bl, resTable).getPackages();
        }
        catch (DirectoryException directoryException) {
            throw new AndrolibException("Could not load resources.arsc from file: " + extFile, directoryException);
        }
    }

    public File getFrameworkApk(int n, String string) throws AndrolibException {
        File file;
        File file2 = this.getFrameworkDir();
        if (string != null && (file = new File(file2, String.valueOf(n) + '-' + string + ".apk")).exists()) {
            return file;
        }
        file = new File(file2, String.valueOf(n) + ".apk");
        if (file.exists()) {
            return file;
        }
        if (n == 1) {
            InputStream inputStream = null;
            FileOutputStream fileOutputStream = null;
            try {
                inputStream = AndrolibResources.class.getResourceAsStream("/brut/androlib/android-framework.jar");
                fileOutputStream = new FileOutputStream(file);
                IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
                File file3 = file;
                return file3;
            }
            catch (IOException iOException) {
                throw new AndrolibException(iOException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (fileOutputStream != null) {
                    try {
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        throw new CantFindFrameworkResException(n);
    }

    public void installFramework(File file, String string) throws AndrolibException {
        InputStream inputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            ZipFile zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("resources.arsc");
            if (zipEntry == null) {
                throw new AndrolibException("Can't find resources.arsc file");
            }
            inputStream = zipFile.getInputStream(zipEntry);
            byte[] byArray = IOUtils.toByteArray(inputStream);
            ARSCDecoder.ARSCData aRSCData = ARSCDecoder.decode(new ByteArrayInputStream(byArray), true, true);
            this.publicizeResources(byArray, aRSCData.getFlagsOffsets());
            File file2 = new File(this.getFrameworkDir(), String.valueOf(aRSCData.getOnePackage().getId()) + (string == null ? "" : '-' + string) + ".apk");
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            zipOutputStream.setMethod(0);
            CRC32 cRC32 = new CRC32();
            cRC32.update(byArray);
            zipEntry = new ZipEntry("resources.arsc");
            zipEntry.setSize(byArray.length);
            zipEntry.setCrc(cRC32.getValue());
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(byArray);
            LOGGER.info("Framework installed to: " + file2);
        }
        catch (ZipException zipException) {
            throw new AndrolibException(zipException);
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void publicizeResources(File file) throws AndrolibException {
        byte[] byArray = new byte[(int)file.length()];
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            ((InputStream)fileInputStream).read(byArray);
            this.publicizeResources(byArray);
            outputStream = new FileOutputStream(file);
            outputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new AndrolibException(iOException);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void publicizeResources(byte[] byArray) throws AndrolibException {
        this.publicizeResources(byArray, ARSCDecoder.decode(new ByteArrayInputStream(byArray), true, true).getFlagsOffsets());
    }

    public void publicizeResources(byte[] byArray, ARSCDecoder.FlagsOffset[] flagsOffsetArray) throws AndrolibException {
        for (ARSCDecoder.FlagsOffset flagsOffset : flagsOffsetArray) {
            int n;
            int n2 = n + 4 * flagsOffset.count;
            for (n = flagsOffset.offset + 3; n < n2; n += 4) {
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x40);
            }
        }
    }

    private File getFrameworkDir() throws AndrolibException {
        File file = new File(System.getProperty("user.home") + File.separatorChar + "apktool" + File.separatorChar + "framework");
        if (!file.exists() && !file.mkdirs()) {
            throw new AndrolibException("Can't create directory: " + file);
        }
        return file;
    }

    public File getAndroidResourcesFile() throws AndrolibException {
        try {
            return Jar.getResourceAsFile("/brut/androlib/android-framework.jar");
        }
        catch (BrutException brutException) {
            throw new AndrolibException(brutException);
        }
    }

    public static String escapeTextForResXml(String string) {
        return AndrolibResources.escapeTextForResXml(string, true);
    }

    public static String escapeTextForResXml(String string, boolean bl) {
        if (string.isEmpty()) {
            return string;
        }
        if (bl) {
            string = AndrolibResources.escapeCharsForResXml(string);
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        char[] cArray = string.toCharArray();
        switch (cArray[0]) {
            case '#': 
            case '?': 
            case '@': {
                stringBuilder.append('\\');
            }
        }
        boolean bl2 = true;
        for (char c : cArray) {
            if (c == ' ') {
                if (bl2) {
                    stringBuilder.append("\\u0020");
                    continue;
                }
                stringBuilder.append(c);
                bl2 = true;
                continue;
            }
            bl2 = false;
            stringBuilder.append(c);
        }
        if (bl2 && stringBuilder.charAt(stringBuilder.length() - 1) == ' ') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            stringBuilder.append("\\u0020");
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escapeCharsForResXml(String string) {
        if (string.isEmpty()) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 10);
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (true) {
            block9: {
                if (n2 >= n) {
                    return stringBuilder.toString();
                }
                char c = cArray[n2];
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuilder.append('\\');
                        break;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        break block9;
                    }
                    case '&': {
                        stringBuilder.append("&amp;");
                        break block9;
                    }
                    case '<': {
                        stringBuilder.append("&lt;");
                        break block9;
                    }
                }
                stringBuilder.append(c);
            }
            ++n2;
        }
    }
}

