/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.data.value;

import brut.androlib.AndrolibException;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.value.ResAttr;
import brut.androlib.res.data.value.ResIntValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.util.Duo;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.xmlpull.v1.XmlSerializer;

public class ResEnumAttr
extends ResAttr {
    private final Duo<ResReferenceValue, ResIntValue>[] mItems;
    private final Map<Integer, String> mItemsCache = new HashMap<Integer, String>();

    ResEnumAttr(ResReferenceValue resReferenceValue, int n, Integer n2, Integer n3, Boolean bl, Duo<ResReferenceValue, ResIntValue>[] duoArray) {
        super(resReferenceValue, n, n2, n3, bl);
        this.mItems = duoArray;
    }

    @Override
    public String convertToResXmlFormat(ResScalarValue resScalarValue) throws AndrolibException {
        String string;
        if (resScalarValue instanceof ResIntValue && (string = this.decodeValue(((ResIntValue)resScalarValue).getValue())) != null) {
            return string;
        }
        return super.convertToResXmlFormat(resScalarValue);
    }

    @Override
    protected void serializeBody(XmlSerializer xmlSerializer, ResResource resResource) throws AndrolibException, IOException {
        for (Duo<ResReferenceValue, ResIntValue> duo : this.mItems) {
            int n = ((ResIntValue)duo.m2).getValue();
            xmlSerializer.startTag(null, "enum");
            xmlSerializer.attribute(null, "name", ((ResReferenceValue)duo.m1).getReferent().getName());
            xmlSerializer.attribute(null, "value", String.valueOf(n));
            xmlSerializer.endTag(null, "enum");
        }
    }

    private String decodeValue(int n) throws AndrolibException {
        String string = this.mItemsCache.get(n);
        if (string == null) {
            ResReferenceValue resReferenceValue = null;
            for (Duo<ResReferenceValue, ResIntValue> duo : this.mItems) {
                if (((ResIntValue)duo.m2).getValue() != n) continue;
                resReferenceValue = (ResReferenceValue)duo.m1;
                break;
            }
            if (resReferenceValue != null) {
                string = resReferenceValue.getReferent().getName();
                this.mItemsCache.put(n, string);
            }
        }
        return string;
    }
}

