/*
 * Decompiled with CFR 0.152.
 */
package ds.tree;

import ds.tree.DuplicateKeyException;
import ds.tree.RadixTree;
import ds.tree.RadixTreeNode;
import ds.tree.Visitor;
import ds.tree.VisitorImpl;
import java.util.ArrayList;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedList;

public class RadixTreeImpl<T>
implements RadixTree<T>,
Formattable {
    protected RadixTreeNode<T> root = new RadixTreeNode();
    protected long size;

    public RadixTreeImpl() {
        this.root.setKey("");
        this.size = 0L;
    }

    @Override
    public T find(String string) {
        VisitorImpl visitorImpl = new VisitorImpl<T, T>(){

            @Override
            public void visit(String string, RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
                if (radixTreeNode2.isReal()) {
                    this.result = radixTreeNode2.getValue();
                }
            }
        };
        this.visit(string, visitorImpl);
        return (T)visitorImpl.getResult();
    }

    @Override
    public boolean replace(String string, final T t) {
        VisitorImpl visitorImpl = new VisitorImpl<T, T>(){

            @Override
            public void visit(String string, RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
                if (radixTreeNode2.isReal()) {
                    radixTreeNode2.setValue(t);
                    this.result = t;
                } else {
                    this.result = null;
                }
            }
        };
        this.visit(string, visitorImpl);
        return visitorImpl.getResult() != null;
    }

    @Override
    public boolean delete(String string) {
        VisitorImpl visitorImpl = new VisitorImpl<T, Boolean>(Boolean.FALSE){

            @Override
            public void visit(String string, RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
                this.result = radixTreeNode2.isReal();
                if (((Boolean)this.result).booleanValue()) {
                    if (radixTreeNode2.getChildern().size() == 0) {
                        Iterator iterator = radixTreeNode.getChildern().iterator();
                        while (iterator.hasNext()) {
                            if (!iterator.next().getKey().equals(radixTreeNode2.getKey())) continue;
                            iterator.remove();
                            break;
                        }
                        if (radixTreeNode.getChildern().size() == 1 && !radixTreeNode.isReal()) {
                            this.mergeNodes(radixTreeNode, radixTreeNode.getChildern().get(0));
                        }
                    } else if (radixTreeNode2.getChildern().size() == 1) {
                        this.mergeNodes(radixTreeNode2, radixTreeNode2.getChildern().get(0));
                    } else {
                        radixTreeNode2.setReal(false);
                    }
                }
            }

            private void mergeNodes(RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
                radixTreeNode.setKey(radixTreeNode.getKey() + radixTreeNode2.getKey());
                radixTreeNode.setReal(radixTreeNode2.isReal());
                radixTreeNode.setValue(radixTreeNode2.getValue());
                radixTreeNode.setChildern(radixTreeNode2.getChildern());
            }
        };
        this.visit(string, visitorImpl);
        if (((Boolean)visitorImpl.getResult()).booleanValue()) {
            --this.size;
        }
        return (Boolean)visitorImpl.getResult();
    }

    @Override
    public void insert(String string, T t) throws DuplicateKeyException {
        try {
            this.insert(string, this.root, t);
        }
        catch (DuplicateKeyException duplicateKeyException) {
            throw new DuplicateKeyException("Duplicate key: '" + string + "'");
        }
        ++this.size;
    }

    private void insert(String string, RadixTreeNode<T> radixTreeNode, T t) throws DuplicateKeyException {
        int n = radixTreeNode.getNumberOfMatchingCharacters(string);
        if (radixTreeNode.getKey().equals("") || n == 0 || n < string.length() && n >= radixTreeNode.getKey().length()) {
            boolean bl = false;
            String string2 = string.substring(n, string.length());
            for (RadixTreeNode<T> radixTreeNode2 : radixTreeNode.getChildern()) {
                if (!radixTreeNode2.getKey().startsWith(string2.charAt(0) + "")) continue;
                bl = true;
                this.insert(string2, radixTreeNode2, t);
                break;
            }
            if (!bl) {
                RadixTreeNode radixTreeNode3 = new RadixTreeNode();
                radixTreeNode3.setKey(string2);
                radixTreeNode3.setReal(true);
                radixTreeNode3.setValue(t);
                radixTreeNode.getChildern().add(radixTreeNode3);
            }
        } else if (n == string.length() && n == radixTreeNode.getKey().length()) {
            if (radixTreeNode.isReal()) {
                throw new DuplicateKeyException("Duplicate key");
            }
            radixTreeNode.setReal(true);
            radixTreeNode.setValue(t);
        } else if (n > 0 && n < radixTreeNode.getKey().length()) {
            RadixTreeNode<T> radixTreeNode4 = new RadixTreeNode<T>();
            radixTreeNode4.setKey(radixTreeNode.getKey().substring(n, radixTreeNode.getKey().length()));
            radixTreeNode4.setReal(radixTreeNode.isReal());
            radixTreeNode4.setValue(radixTreeNode.getValue());
            radixTreeNode4.setChildern(radixTreeNode.getChildern());
            radixTreeNode.setKey(string.substring(0, n));
            radixTreeNode.setReal(false);
            radixTreeNode.setChildern(new ArrayList());
            radixTreeNode.getChildern().add(radixTreeNode4);
            if (n < string.length()) {
                RadixTreeNode<T> radixTreeNode5 = new RadixTreeNode<T>();
                radixTreeNode5.setKey(string.substring(n, string.length()));
                radixTreeNode5.setReal(true);
                radixTreeNode5.setValue(t);
                radixTreeNode.getChildern().add(radixTreeNode5);
            } else {
                radixTreeNode.setValue(t);
                radixTreeNode.setReal(true);
            }
        } else {
            RadixTreeNode<T> radixTreeNode6 = new RadixTreeNode<T>();
            radixTreeNode6.setKey(radixTreeNode.getKey().substring(n, radixTreeNode.getKey().length()));
            radixTreeNode6.setChildern(radixTreeNode.getChildern());
            radixTreeNode6.setReal(radixTreeNode.isReal());
            radixTreeNode6.setValue(radixTreeNode.getValue());
            radixTreeNode.setKey(string);
            radixTreeNode.setReal(true);
            radixTreeNode.setValue(t);
            radixTreeNode.getChildern().add(radixTreeNode6);
        }
    }

    @Override
    public ArrayList<T> searchPrefix(String string, int n) {
        ArrayList<T> arrayList = new ArrayList<T>();
        RadixTreeNode<T> radixTreeNode = this.searchPefix(string, this.root);
        if (radixTreeNode != null) {
            if (radixTreeNode.isReal()) {
                arrayList.add(radixTreeNode.getValue());
            }
            this.getNodes(radixTreeNode, arrayList, n);
        }
        return arrayList;
    }

    private void getNodes(RadixTreeNode<T> radixTreeNode, ArrayList<T> arrayList, int n) {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(radixTreeNode.getChildern());
        while (!linkedList.isEmpty()) {
            RadixTreeNode radixTreeNode2 = (RadixTreeNode)linkedList.remove();
            if (radixTreeNode2.isReal()) {
                arrayList.add(radixTreeNode2.getValue());
            }
            if (arrayList.size() == n) break;
            linkedList.addAll(radixTreeNode2.getChildern());
        }
    }

    private RadixTreeNode<T> searchPefix(String string, RadixTreeNode<T> radixTreeNode) {
        RadixTreeNode<T> radixTreeNode2 = null;
        int n = radixTreeNode.getNumberOfMatchingCharacters(string);
        if (n == string.length() && n <= radixTreeNode.getKey().length()) {
            radixTreeNode2 = radixTreeNode;
        } else if (radixTreeNode.getKey().equals("") || n < string.length() && n >= radixTreeNode.getKey().length()) {
            String string2 = string.substring(n, string.length());
            for (RadixTreeNode<T> radixTreeNode3 : radixTreeNode.getChildern()) {
                if (!radixTreeNode3.getKey().startsWith(string2.charAt(0) + "")) continue;
                radixTreeNode2 = this.searchPefix(string2, radixTreeNode3);
                break;
            }
        }
        return radixTreeNode2;
    }

    @Override
    public boolean contains(String string) {
        VisitorImpl visitorImpl = new VisitorImpl<T, Boolean>(Boolean.FALSE){

            @Override
            public void visit(String string, RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
                this.result = radixTreeNode2.isReal();
            }
        };
        this.visit(string, visitorImpl);
        return (Boolean)visitorImpl.getResult();
    }

    public <R> void visit(String string, Visitor<T, R> visitor) {
        if (this.root != null) {
            this.visit(string, visitor, null, this.root);
        }
    }

    private <R> void visit(String string, Visitor<T, R> visitor, RadixTreeNode<T> radixTreeNode, RadixTreeNode<T> radixTreeNode2) {
        int n = radixTreeNode2.getNumberOfMatchingCharacters(string);
        if (n == string.length() && n == radixTreeNode2.getKey().length()) {
            visitor.visit(string, radixTreeNode, radixTreeNode2);
        } else if (radixTreeNode2.getKey().equals("") || n < string.length() && n >= radixTreeNode2.getKey().length()) {
            String string2 = string.substring(n, string.length());
            for (RadixTreeNode<T> radixTreeNode3 : radixTreeNode2.getChildern()) {
                if (!radixTreeNode3.getKey().startsWith(string2.charAt(0) + "")) continue;
                this.visit(string2, visitor, radixTreeNode2, radixTreeNode3);
                break;
            }
        }
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Deprecated
    public void display() {
        this.formatNodeTo(new Formatter(System.out), 0, this.root);
    }

    @Deprecated
    private void display(int n, RadixTreeNode<T> radixTreeNode) {
        this.formatNodeTo(new Formatter(System.out), n, radixTreeNode);
    }

    private void formatNodeTo(Formatter formatter, int n, RadixTreeNode<T> radixTreeNode) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            formatter.format(" ", new Object[0]);
        }
        formatter.format("|", new Object[0]);
        for (n2 = 0; n2 < n; ++n2) {
            formatter.format("-", new Object[0]);
        }
        if (radixTreeNode.isReal()) {
            formatter.format("%s[%s]*%n", radixTreeNode.getKey(), radixTreeNode.getValue());
        } else {
            formatter.format("%s%n", radixTreeNode.getKey());
        }
        for (RadixTreeNode<T> radixTreeNode2 : radixTreeNode.getChildern()) {
            this.formatNodeTo(formatter, n + 1, radixTreeNode2);
        }
    }

    @Override
    public void formatTo(Formatter formatter, int n, int n2, int n3) {
        this.formatNodeTo(formatter, 0, this.root);
    }

    @Override
    public String complete(String string) {
        return this.complete(string, this.root, "");
    }

    private String complete(String string, RadixTreeNode<T> radixTreeNode, String string2) {
        int n;
        int n2 = string.length();
        int n3 = radixTreeNode.getKey().length();
        for (n = 0; n < n2 && n < n3 && string.charAt(n) == radixTreeNode.getKey().charAt(n); ++n) {
        }
        if (n == n2 && n <= n3) {
            return string2 + radixTreeNode.getKey();
        }
        if (n3 == 0 || n < n2 && n >= n3) {
            String string3 = string.substring(0, n);
            String string4 = string.substring(n, n2);
            for (RadixTreeNode<T> radixTreeNode2 : radixTreeNode.getChildern()) {
                if (!radixTreeNode2.getKey().startsWith(string4.charAt(0) + "")) continue;
                return this.complete(string4, radixTreeNode2, string2 + string3);
            }
        }
        return "";
    }
}

