/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.Parser;

public class PosixParser
extends Parser {
    private List tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
    }

    @Override
    protected String[] flatten(Options options, String[] stringArray, boolean bl) {
        this.init();
        this.options = options;
        Iterator<String> iterator = Arrays.asList(stringArray).iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            if (string.startsWith("--")) {
                String string2;
                int n = string.indexOf(61);
                String string3 = string2 = n == -1 ? string : string.substring(0, n);
                if (!options.hasOption(string2)) {
                    this.processNonOptionToken(string, bl);
                } else {
                    this.currentOption = options.getOption(string2);
                    this.tokens.add(string2);
                    if (n != -1) {
                        this.tokens.add(string.substring(n + 1));
                    }
                }
            } else if ("-".equals(string)) {
                this.tokens.add(string);
            } else if (string.startsWith("-")) {
                if (string.length() == 2 || options.hasOption(string)) {
                    this.processOptionToken(string, bl);
                } else {
                    this.burstToken(string, bl);
                }
            } else {
                this.processNonOptionToken(string, bl);
            }
            this.gobble(iterator);
        }
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    private void gobble(Iterator iterator) {
        if (this.eatTheRest) {
            while (iterator.hasNext()) {
                this.tokens.add(iterator.next());
            }
        }
    }

    private void processNonOptionToken(String string, boolean bl) {
        if (bl && (this.currentOption == null || !this.currentOption.hasArg())) {
            this.eatTheRest = true;
            this.tokens.add("--");
        }
        this.tokens.add(string);
    }

    private void processOptionToken(String string, boolean bl) {
        if (bl && !this.options.hasOption(string)) {
            this.eatTheRest = true;
        }
        if (this.options.hasOption(string)) {
            this.currentOption = this.options.getOption(string);
        }
        this.tokens.add(string);
    }

    protected void burstToken(String string, boolean bl) {
        for (int i = 1; i < string.length(); ++i) {
            String string2 = String.valueOf(string.charAt(i));
            if (this.options.hasOption(string2)) {
                this.tokens.add("-" + string2);
                this.currentOption = this.options.getOption(string2);
                if (!this.currentOption.hasArg() || string.length() == i + 1) continue;
                this.tokens.add(string.substring(i + 1));
                break;
            }
            if (bl) {
                this.processNonOptionToken(string.substring(i), true);
                break;
            }
            this.tokens.add(string);
            break;
        }
    }
}

