/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors.Format;

import org.jf.baksmali.Adaptors.Format.ArrayDataMethodItem;
import org.jf.baksmali.Adaptors.Format.InstructionMethodItem;
import org.jf.baksmali.Adaptors.Format.OffsetInstructionFormatMethodItem;
import org.jf.baksmali.Adaptors.Format.PackedSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.SparseSwitchMethodItem;
import org.jf.baksmali.Adaptors.Format.UnresolvedOdexInstructionMethodItem;
import org.jf.baksmali.Adaptors.MethodDefinition;
import org.jf.dexlib.Code.Format.ArrayDataPseudoInstruction;
import org.jf.dexlib.Code.Format.PackedSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.SparseSwitchDataPseudoInstruction;
import org.jf.dexlib.Code.Format.UnresolvedOdexInstruction;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.CodeItem;

public class InstructionMethodItemFactory {
    private InstructionMethodItemFactory() {
    }

    public static InstructionMethodItem makeInstructionFormatMethodItem(MethodDefinition methodDefinition, CodeItem codeItem, int n, Instruction instruction) {
        if (instruction instanceof OffsetInstruction) {
            return new OffsetInstructionFormatMethodItem<Instruction>(methodDefinition.getLabelCache(), codeItem, n, instruction);
        }
        switch (instruction.getFormat()) {
            case ArrayData: {
                return new ArrayDataMethodItem(codeItem, n, (ArrayDataPseudoInstruction)instruction);
            }
            case PackedSwitchData: {
                return new PackedSwitchMethodItem(methodDefinition, codeItem, n, (PackedSwitchDataPseudoInstruction)instruction);
            }
            case SparseSwitchData: {
                return new SparseSwitchMethodItem(methodDefinition, codeItem, n, (SparseSwitchDataPseudoInstruction)instruction);
            }
            case UnresolvedOdexInstruction: {
                return new UnresolvedOdexInstructionMethodItem(codeItem, n, (UnresolvedOdexInstruction)instruction);
            }
        }
        return new InstructionMethodItem<Instruction>(codeItem, n, instruction);
    }
}

