/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import java.util.BitSet;
import org.jf.baksmali.Adaptors.MethodItem;
import org.jf.baksmali.Adaptors.RegisterFormatter;
import org.jf.baksmali.IndentingWriter;
import org.jf.baksmali.baksmali;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.Code.Analysis.AnalyzedInstruction;
import org.jf.dexlib.Code.Analysis.MethodAnalyzer;
import org.jf.dexlib.Code.Analysis.RegisterType;
import org.jf.dexlib.Code.FiveRegisterInstruction;
import org.jf.dexlib.Code.RegisterRangeInstruction;
import org.jf.dexlib.Code.SingleRegisterInstruction;
import org.jf.dexlib.Code.ThreeRegisterInstruction;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.Util.AccessFlags;

public class PreInstructionRegisterInfoMethodItem
extends MethodItem {
    private static AnalyzedInstruction lastInstruction;
    private final AnalyzedInstruction analyzedInstruction;
    private final MethodAnalyzer methodAnalyzer;

    public PreInstructionRegisterInfoMethodItem(AnalyzedInstruction analyzedInstruction, MethodAnalyzer methodAnalyzer, int n) {
        super(n);
        this.analyzedInstruction = analyzedInstruction;
        this.methodAnalyzer = methodAnalyzer;
    }

    @Override
    public double getSortOrder() {
        return 99.9;
    }

    @Override
    public boolean writeTo(IndentingWriter indentingWriter) throws IOException {
        int n = baksmali.registerInfo;
        int n2 = this.analyzedInstruction.getRegisterCount();
        BitSet bitSet = new BitSet(n2);
        if ((n & 1) != 0) {
            bitSet.set(0, n2);
        } else if ((n & 2) != 0) {
            bitSet.set(0, n2);
        } else {
            if ((n & 8) != 0) {
                this.addArgsRegs(bitSet);
            }
            if ((n & 0x80) != 0) {
                this.addDiffRegs(bitSet);
            }
            if ((n & 0x20) != 0) {
                this.addMergeRegs(bitSet, n2);
            } else if ((n & 0x40) != 0 && this.analyzedInstruction.isBeginningInstruction()) {
                this.addParamRegs(bitSet, n2);
            }
        }
        boolean bl = false;
        if ((n & 0x40) != 0) {
            bl = this.writeFullMergeRegs(indentingWriter, bitSet, n2);
        }
        bl |= this.writeRegisterInfo(indentingWriter, bitSet, bl);
        return bl;
    }

    private void addArgsRegs(BitSet bitSet) {
        if (this.analyzedInstruction.getInstruction() instanceof RegisterRangeInstruction) {
            RegisterRangeInstruction registerRangeInstruction = (RegisterRangeInstruction)((Object)this.analyzedInstruction.getInstruction());
            bitSet.set(registerRangeInstruction.getStartRegister(), registerRangeInstruction.getStartRegister() + registerRangeInstruction.getRegCount());
        } else if (this.analyzedInstruction.getInstruction() instanceof FiveRegisterInstruction) {
            FiveRegisterInstruction fiveRegisterInstruction = (FiveRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            byte by = fiveRegisterInstruction.getRegCount();
            switch (by) {
                case 5: {
                    bitSet.set(fiveRegisterInstruction.getRegisterA());
                }
                case 4: {
                    bitSet.set(fiveRegisterInstruction.getRegisterG());
                }
                case 3: {
                    bitSet.set(fiveRegisterInstruction.getRegisterF());
                }
                case 2: {
                    bitSet.set(fiveRegisterInstruction.getRegisterE());
                }
                case 1: {
                    bitSet.set(fiveRegisterInstruction.getRegisterD());
                }
            }
        } else if (this.analyzedInstruction.getInstruction() instanceof ThreeRegisterInstruction) {
            ThreeRegisterInstruction threeRegisterInstruction = (ThreeRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            bitSet.set(threeRegisterInstruction.getRegisterA());
            bitSet.set(threeRegisterInstruction.getRegisterB());
            bitSet.set(threeRegisterInstruction.getRegisterC());
        } else if (this.analyzedInstruction.getInstruction() instanceof TwoRegisterInstruction) {
            TwoRegisterInstruction twoRegisterInstruction = (TwoRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            bitSet.set(twoRegisterInstruction.getRegisterA());
            bitSet.set(twoRegisterInstruction.getRegisterB());
        } else if (this.analyzedInstruction.getInstruction() instanceof SingleRegisterInstruction) {
            SingleRegisterInstruction singleRegisterInstruction = (SingleRegisterInstruction)((Object)this.analyzedInstruction.getInstruction());
            bitSet.set(singleRegisterInstruction.getRegisterA());
        }
    }

    private void addDiffRegs(BitSet bitSet) {
        if (!this.analyzedInstruction.isBeginningInstruction()) {
            for (int i = 0; i < this.analyzedInstruction.getRegisterCount(); ++i) {
                if (PreInstructionRegisterInfoMethodItem.lastInstruction.getPreInstructionRegisterType((int)i).category == this.analyzedInstruction.getPreInstructionRegisterType((int)i).category) continue;
                bitSet.set(i);
            }
        }
        lastInstruction = this.analyzedInstruction;
    }

    private void addMergeRegs(BitSet bitSet, int n) {
        if (this.analyzedInstruction.isBeginningInstruction()) {
            this.addParamRegs(bitSet, n);
        }
        if (this.analyzedInstruction.getPredecessorCount() <= 1) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            RegisterType registerType = this.analyzedInstruction.getPreInstructionRegisterType(i);
            for (AnalyzedInstruction analyzedInstruction : this.analyzedInstruction.getPredecessors()) {
                if (analyzedInstruction.getPostInstructionRegisterType(i) == registerType) continue;
                bitSet.set(i);
            }
        }
    }

    private void addParamRegs(BitSet bitSet, int n) {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int n2 = encodedMethod.method.getPrototype().getParameterRegisterCount();
        if ((encodedMethod.accessFlags & AccessFlags.STATIC.getValue()) == 0) {
            ++n2;
        }
        bitSet.set(n - n2, n);
    }

    private boolean writeFullMergeRegs(IndentingWriter indentingWriter, BitSet bitSet, int n) throws IOException {
        if (this.analyzedInstruction.getPredecessorCount() <= 1) {
            return false;
        }
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            RegisterType registerType = this.analyzedInstruction.getPreInstructionRegisterType(i);
            boolean bl2 = false;
            for (AnalyzedInstruction analyzedInstruction : this.analyzedInstruction.getPredecessors()) {
                Object object = analyzedInstruction.getPostInstructionRegisterType(i);
                if (((RegisterType)object).category == RegisterType.Category.Unknown || object == registerType) continue;
                bl2 = true;
                break;
            }
            if (!bl2) continue;
            if (bl) {
                bl = false;
            } else {
                indentingWriter.write(10);
            }
            indentingWriter.write(35);
            RegisterFormatter.writeTo(indentingWriter, encodedMethod.codeItem, i);
            indentingWriter.write(61);
            this.analyzedInstruction.getPreInstructionRegisterType(i).writeTo(indentingWriter);
            indentingWriter.write(":merge{");
            boolean bl3 = true;
            for (Object object : this.analyzedInstruction.getPredecessors()) {
                RegisterType registerType2 = ((AnalyzedInstruction)object).getPostInstructionRegisterType(i);
                if (!bl3) {
                    indentingWriter.write(44);
                }
                if (((AnalyzedInstruction)object).getInstructionIndex() == -1) {
                    indentingWriter.write("Start:");
                } else {
                    indentingWriter.write("0x");
                    indentingWriter.printLongAsHex(this.methodAnalyzer.getInstructionAddress((AnalyzedInstruction)object));
                    indentingWriter.write(58);
                }
                registerType2.writeTo(indentingWriter);
                bl3 = false;
            }
            indentingWriter.write(125);
            bitSet.clear(i);
        }
        return !bl;
    }

    private boolean writeRegisterInfo(IndentingWriter indentingWriter, BitSet bitSet, boolean bl) throws IOException {
        ClassDataItem.EncodedMethod encodedMethod = this.methodAnalyzer.getMethod();
        int n = bitSet.nextSetBit(0);
        if (n < 0) {
            return false;
        }
        if (bl) {
            indentingWriter.write(10);
        }
        indentingWriter.write(35);
        while (n >= 0) {
            RegisterType registerType = this.analyzedInstruction.getPreInstructionRegisterType(n);
            RegisterFormatter.writeTo(indentingWriter, encodedMethod.codeItem, n);
            indentingWriter.write(61);
            if (registerType == null) {
                indentingWriter.write("null");
            } else {
                registerType.writeTo(indentingWriter);
            }
            indentingWriter.write(59);
            n = bitSet.nextSetBit(n + 1);
        }
        return true;
    }
}

