/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali;

import ds.tree.RadixTree;
import ds.tree.RadixTreeImpl;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.CharBuffer;

public class fileNameHandler {
    private PackageNameEntry top;

    public fileNameHandler(File file) {
        this.top = new PackageNameEntry(file);
    }

    public File getUniqueFilenameForClass(String string) {
        if (string.charAt(0) != 'L' || string.charAt(string.length() - 1) != ';') {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        int n = 1;
        for (int i = 1; i < string.length() - 1; ++i) {
            if (string.charAt(i) != '/') continue;
            ++n;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        int n3 = 1;
        for (int i = 1; i < string.length() - 1; ++i) {
            if (string.charAt(i) != '/') continue;
            if (i - n3 == 0) {
                throw new RuntimeException("Not a valid dalvik class name");
            }
            stringArray[n2++] = string.substring(n3, i);
            n3 = ++i;
        }
        if (n3 >= string.length() - 1) {
            throw new RuntimeException("Not a valid dalvik class name");
        }
        stringArray[n2] = string.substring(n3, string.length() - 1);
        return this.top.addUniqueChild(stringArray, 0);
    }

    private static class ClassNameEntry
    extends FileSystemEntry {
        public ClassNameEntry(File file, String string) {
            super(new File(file, string));
        }

        @Override
        public File addUniqueChild(String[] stringArray, int n) {
            assert (false);
            return this.file;
        }
    }

    private static class VirtualGroupEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> groupEntries = new RadixTreeImpl<FileSystemEntry>();
        private int isCaseSensitive = -1;

        public VirtualGroupEntry(FileSystemEntry fileSystemEntry, File file) {
            super(file);
            this.groupEntries.insert(fileSystemEntry.file.getName(), fileSystemEntry);
        }

        @Override
        public File addUniqueChild(String[] stringArray, int n) {
            FileSystemEntry fileSystemEntry;
            String string = stringArray[n];
            if (n == stringArray.length - 1) {
                string = string + ".smali";
            }
            if ((fileSystemEntry = this.groupEntries.find(string)) != null) {
                if (n == stringArray.length - 1) {
                    return fileSystemEntry.file;
                }
                return fileSystemEntry.addUniqueChild(stringArray, n + 1);
            }
            if (n == stringArray.length - 1) {
                String string2 = !this.isCaseSensitive() ? stringArray[n] + "." + (this.groupEntries.getSize() + 1L) + ".smali" : string;
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, string2);
                this.groupEntries.insert(string, classNameEntry);
                return classNameEntry.file;
            }
            String string3 = !this.isCaseSensitive() ? stringArray[n] + "." + (this.groupEntries.getSize() + 1L) : string;
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, string3);
            this.groupEntries.insert(string, packageNameEntry);
            return packageNameEntry.addUniqueChild(stringArray, n + 1);
        }

        private boolean isCaseSensitive() {
            if (this.isCaseSensitive != -1) {
                return this.isCaseSensitive == 1;
            }
            File file = this.file;
            if (file.exists() && file.isFile()) {
                file = file.getParentFile();
            }
            if (!this.file.exists() && !this.file.mkdirs()) {
                return false;
            }
            try {
                boolean bl = VirtualGroupEntry.testCaseSensitivity(file);
                this.isCaseSensitive = bl ? 1 : 0;
                return bl;
            }
            catch (IOException iOException) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean testCaseSensitivity(File file) throws IOException {
            File file2;
            File file3;
            int n = 1;
            do {
                file3 = new File(file, "test." + n);
                file2 = new File(file, "TEST." + n++);
            } while (file3.exists() || file2.exists());
            try {
                Appendable appendable;
                try {
                    appendable = new FileWriter(file3);
                    ((Writer)appendable).write("test");
                    ((OutputStreamWriter)appendable).flush();
                    ((OutputStreamWriter)appendable).close();
                }
                catch (IOException iOException) {
                    try {
                        file3.delete();
                        throw iOException;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw iOException;
                }
                if (file2.exists()) {
                    boolean bl = false;
                    return bl;
                }
                if (file2.createNewFile()) {
                    boolean bl = true;
                    return bl;
                }
                appendable = CharBuffer.allocate(32);
                FileReader fileReader = new FileReader(file2);
                while (fileReader.read((CharBuffer)appendable) != -1 && ((CharBuffer)appendable).length() < 4) {
                }
                if (((CharBuffer)appendable).length() == 4 && ((CharBuffer)appendable).toString().equals("test")) {
                    boolean bl = false;
                    return bl;
                }
                assert (false);
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    file3.delete();
                }
                catch (Exception exception) {}
                try {
                    file2.delete();
                }
                catch (Exception exception) {}
            }
        }

        @Override
        public FileSystemEntry makeVirtual(File file) {
            return this;
        }
    }

    private static class PackageNameEntry
    extends FileSystemEntry {
        private RadixTree<FileSystemEntry> children = new RadixTreeImpl<FileSystemEntry>();

        public PackageNameEntry(File file, String string) {
            super(new File(file, string));
        }

        public PackageNameEntry(File file) {
            super(file);
        }

        @Override
        public File addUniqueChild(String[] stringArray, int n) {
            String string = n == stringArray.length - 1 ? stringArray[n] + ".smali" : stringArray[n];
            String string2 = string.toLowerCase();
            FileSystemEntry fileSystemEntry = this.children.find(string2);
            if (fileSystemEntry != null) {
                FileSystemEntry fileSystemEntry2 = fileSystemEntry;
                if (!(fileSystemEntry instanceof VirtualGroupEntry)) {
                    if (fileSystemEntry.file.getName().equals(string)) {
                        if (n == stringArray.length - 1) {
                            return fileSystemEntry.file;
                        }
                        return fileSystemEntry.addUniqueChild(stringArray, n + 1);
                    }
                    fileSystemEntry2 = fileSystemEntry.makeVirtual(this.file);
                    this.children.replace(string2, fileSystemEntry2);
                }
                return fileSystemEntry2.addUniqueChild(stringArray, n);
            }
            if (n == stringArray.length - 1) {
                ClassNameEntry classNameEntry = new ClassNameEntry(this.file, string);
                this.children.insert(string2, classNameEntry);
                return classNameEntry.file;
            }
            PackageNameEntry packageNameEntry = new PackageNameEntry(this.file, string);
            this.children.insert(string2, packageNameEntry);
            return packageNameEntry.addUniqueChild(stringArray, n + 1);
        }
    }

    private static abstract class FileSystemEntry {
        public final File file;

        public FileSystemEntry(File file) {
            this.file = file;
        }

        public abstract File addUniqueChild(String[] var1, int var2);

        public FileSystemEntry makeVirtual(File file) {
            return new VirtualGroupEntry(this, file);
        }
    }
}

