/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import java.util.Iterator;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class ArrayDataPseudoInstruction
extends Instruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private int elementWidth;
    private byte[] encodedValues;

    @Override
    public int getSize(int n) {
        return (this.encodedValues.length + 1) / 2 + 4 + n % 2;
    }

    public ArrayDataPseudoInstruction(int n, byte[] byArray) {
        super(Opcode.NOP);
        if (byArray.length % n != 0) {
            throw new RuntimeException("There are not a whole number of " + n + " byte elements");
        }
        this.elementWidth = n;
        this.encodedValues = byArray;
    }

    public ArrayDataPseudoInstruction(byte[] byArray, int n) {
        super(Opcode.NOP);
        byte by = byArray[n];
        if (by != 0) {
            throw new RuntimeException("Invalid opcode byte for an ArrayData pseudo-instruction");
        }
        byte by2 = byArray[n + 1];
        if (by2 != 3) {
            throw new RuntimeException("Invalid sub-opcode byte for an ArrayData pseudo-instruction");
        }
        this.elementWidth = NumberUtils.decodeUnsignedShort(byArray, n + 2);
        int n2 = NumberUtils.decodeInt(byArray, n + 4);
        this.encodedValues = new byte[n2 * this.elementWidth];
        System.arraycopy(byArray, n + 8, this.encodedValues, 0, n2 * this.elementWidth);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.alignTo(4);
        int n2 = this.encodedValues.length / this.elementWidth;
        annotatedOutput.writeByte(0);
        annotatedOutput.writeByte(3);
        annotatedOutput.writeShort(this.elementWidth);
        annotatedOutput.writeInt(n2);
        annotatedOutput.write(this.encodedValues);
        annotatedOutput.alignTo(2);
    }

    @Override
    protected void annotateInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.annotate(this.getSize(n) * 2, "[0x" + Integer.toHexString(n) + "] " + "fill-array-data instruction");
    }

    @Override
    public Format getFormat() {
        return Format.ArrayData;
    }

    public int getElementWidth() {
        return this.elementWidth;
    }

    public int getElementCount() {
        return this.encodedValues.length / this.elementWidth;
    }

    public Iterator<ArrayElement> getElements() {
        return new Iterator<ArrayElement>(){
            final int elementCount;
            int i;
            int position;
            final ArrayElement arrayElement;
            {
                this.elementCount = ArrayDataPseudoInstruction.this.getElementCount();
                this.i = 0;
                this.position = 0;
                this.arrayElement = new ArrayElement(ArrayDataPseudoInstruction.this.encodedValues, ArrayDataPseudoInstruction.this.getElementWidth());
            }

            @Override
            public boolean hasNext() {
                return this.i < this.elementCount;
            }

            @Override
            public ArrayElement next() {
                this.arrayElement.bufferIndex = this.position;
                this.position += this.arrayElement.elementWidth;
                ++this.i;
                return this.arrayElement;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            if (opcode != Opcode.NOP) {
                throw new RuntimeException("The opcode for an ArrayDataPseudoInstruction must be NOP");
            }
            return new ArrayDataPseudoInstruction(byArray, n);
        }
    }

    public static class ArrayElement {
        public final byte[] buffer;
        public int bufferIndex;
        public final int elementWidth;

        public ArrayElement(byte[] byArray, int n) {
            this.buffer = byArray;
            this.elementWidth = n;
        }
    }
}

