/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.OffsetInstruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22t
extends Instruction
implements OffsetInstruction,
TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private byte regB;
    private short targetAddressOffset;

    public Instruction22t(Opcode opcode, byte by, byte by2, short s) {
        super(opcode);
        if (by >= 16 || by2 >= 16) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (s == 0) {
            throw new RuntimeException("The address offset cannot be 0.");
        }
        this.regA = by;
        this.regB = by2;
        this.targetAddressOffset = s;
    }

    private Instruction22t(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        assert (byArray[n] == opcode.value);
        this.regA = NumberUtils.decodeLowUnsignedNibble(byArray[n + 1]);
        this.regB = NumberUtils.decodeHighUnsignedNibble(byArray[n + 1]);
        this.targetAddressOffset = NumberUtils.decodeShort(byArray, n + 2);
        assert (this.targetAddressOffset != 0);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regB << 4 | this.regA);
        annotatedOutput.writeShort(this.targetAddressOffset);
    }

    @Override
    public void updateTargetAddressOffset(int n) {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new RuntimeException("The address offset " + n + " is out of range. It must be in [-32768, 32767]");
        }
        if (n == 0) {
            throw new RuntimeException("The address offset cannot be 0");
        }
        this.targetAddressOffset = (short)n;
    }

    @Override
    public Format getFormat() {
        return Format.Format22t;
    }

    @Override
    public int getRegisterA() {
        return this.regA;
    }

    @Override
    public int getRegisterB() {
        return this.regB;
    }

    @Override
    public int getTargetAddressOffset() {
        return this.targetAddressOffset;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction22t(opcode, byArray, n);
        }
    }
}

