/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code.Format;

import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.Instruction;
import org.jf.dexlib.Code.Opcode;
import org.jf.dexlib.Code.TwoRegisterInstruction;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.NumberUtils;

public class Instruction22x
extends Instruction
implements TwoRegisterInstruction {
    public static final Instruction.InstructionFactory Factory = new Factory();
    private byte regA;
    private short regB;

    public Instruction22x(Opcode opcode, short s, int n) {
        super(opcode);
        if (s >= 256) {
            throw new RuntimeException("The register number must be less than v16");
        }
        if (n >= 65536) {
            throw new RuntimeException("The register number must be less than v65536");
        }
        this.regA = (byte)s;
        this.regB = (short)n;
    }

    private Instruction22x(Opcode opcode, byte[] byArray, int n) {
        super(opcode);
        this.regA = byArray[n + 1];
        this.regB = (short)NumberUtils.decodeUnsignedShort(byArray, n + 2);
    }

    @Override
    protected void writeInstruction(AnnotatedOutput annotatedOutput, int n) {
        annotatedOutput.writeByte(this.opcode.value);
        annotatedOutput.writeByte(this.regA);
        annotatedOutput.writeShort(this.regB);
    }

    @Override
    public Format getFormat() {
        return Format.Format22x;
    }

    @Override
    public int getRegisterA() {
        return this.regA & 0xFF;
    }

    @Override
    public int getRegisterB() {
        return this.regB & 0xFFFF;
    }

    private static class Factory
    implements Instruction.InstructionFactory {
        private Factory() {
        }

        @Override
        public Instruction makeInstruction(DexFile dexFile, Opcode opcode, byte[] byArray, int n) {
            return new Instruction22x(opcode, byArray, n);
        }
    }
}

