/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Debug;

import org.jf.dexlib.Debug.DebugOpcode;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.Input;

public class DebugInstructionIterator {
    public static void IterateInstructions(Input input, ProcessRawDebugInstructionDelegate processRawDebugInstructionDelegate) {
        block12: while (true) {
            int n;
            int n2 = input.getCursor();
            byte by = input.readByte();
            switch (by) {
                case 0: {
                    processRawDebugInstructionDelegate.ProcessEndSequence(n2);
                    return;
                }
                case 1: {
                    n = input.readUnsignedLeb128();
                    processRawDebugInstructionDelegate.ProcessAdvancePC(n2, input.getCursor() - n2, n);
                    continue block12;
                }
                case 2: {
                    n = input.readSignedLeb128();
                    processRawDebugInstructionDelegate.ProcessAdvanceLine(n2, input.getCursor() - n2, n);
                    continue block12;
                }
                case 3: {
                    n = input.readUnsignedOrSignedLeb128();
                    boolean bl = false;
                    if (n < 0) {
                        bl = true;
                        n ^= 0xFFFFFFFF;
                    }
                    int n3 = input.readUnsignedLeb128() - 1;
                    int n4 = input.readUnsignedLeb128() - 1;
                    processRawDebugInstructionDelegate.ProcessStartLocal(n2, input.getCursor() - n2, n, n3, n4, bl);
                    continue block12;
                }
                case 4: {
                    n = input.readUnsignedOrSignedLeb128();
                    boolean bl = false;
                    if (n < 0) {
                        bl = true;
                        n ^= 0xFFFFFFFF;
                    }
                    int n3 = input.readUnsignedLeb128() - 1;
                    int n4 = input.readUnsignedLeb128() - 1;
                    int n5 = input.readUnsignedLeb128() - 1;
                    processRawDebugInstructionDelegate.ProcessStartLocalExtended(n2, input.getCursor() - n2, n, n3, n4, n5, bl);
                    continue block12;
                }
                case 5: {
                    n = input.readUnsignedOrSignedLeb128();
                    boolean bl = false;
                    if (n < 0) {
                        bl = true;
                        n ^= 0xFFFFFFFF;
                    }
                    processRawDebugInstructionDelegate.ProcessEndLocal(n2, input.getCursor() - n2, n, bl);
                    continue block12;
                }
                case 6: {
                    n = input.readUnsignedOrSignedLeb128();
                    boolean bl = false;
                    if (n < 0) {
                        bl = true;
                        n ^= 0xFFFFFFFF;
                    }
                    processRawDebugInstructionDelegate.ProcessRestartLocal(n2, input.getCursor() - n2, n, bl);
                    continue block12;
                }
                case 7: {
                    processRawDebugInstructionDelegate.ProcessSetPrologueEnd(n2);
                    continue block12;
                }
                case 8: {
                    processRawDebugInstructionDelegate.ProcessSetEpilogueBegin(n2);
                    continue block12;
                }
                case 9: {
                    n = input.readUnsignedLeb128();
                    processRawDebugInstructionDelegate.ProcessSetFile(n2, input.getCursor() - n2, n);
                    continue block12;
                }
            }
            n = (by & 0xFF) - 10;
            processRawDebugInstructionDelegate.ProcessSpecialOpcode(n2, by, n % 15 - 4, n / 15);
        }
    }

    public static void DecodeInstructions(DebugInfoItem debugInfoItem, int n, ProcessDecodedDebugInstructionDelegate processDecodedDebugInstructionDelegate) {
        int n2 = 0;
        int n3 = debugInfoItem.getLineStart();
        ByteArrayInput byteArrayInput = new ByteArrayInput(debugInfoItem.getEncodedDebugInfo());
        DexFile dexFile = debugInfoItem.getDexFile();
        Local[] localArray = new Local[n];
        while (true) {
            int n4 = byteArrayInput.getCursor();
            byte by = byteArrayInput.readByte();
            switch (DebugOpcode.getDebugOpcodeByValue(by)) {
                case DBG_END_SEQUENCE: {
                    return;
                }
                case DBG_ADVANCE_PC: {
                    int n5 = byteArrayInput.readUnsignedLeb128();
                    n2 += n5;
                    break;
                }
                case DBG_ADVANCE_LINE: {
                    int n6 = byteArrayInput.readSignedLeb128();
                    n3 += n6;
                    break;
                }
                case DBG_START_LOCAL: {
                    int n7 = byteArrayInput.readUnsignedLeb128();
                    Object object = dexFile.StringIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    TypeIdItem typeIdItem = dexFile.TypeIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    localArray[n7] = new Local(n7, (StringIdItem)object, typeIdItem, null);
                    processDecodedDebugInstructionDelegate.ProcessStartLocal(n2, byteArrayInput.getCursor() - n4, n7, (StringIdItem)object, typeIdItem);
                    break;
                }
                case DBG_START_LOCAL_EXTENDED: {
                    int n8 = byteArrayInput.readUnsignedLeb128();
                    Object object = dexFile.StringIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    TypeIdItem typeIdItem = dexFile.TypeIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    StringIdItem stringIdItem = dexFile.StringIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    localArray[n8] = new Local(n8, (StringIdItem)object, typeIdItem, stringIdItem);
                    processDecodedDebugInstructionDelegate.ProcessStartLocalExtended(n2, byteArrayInput.getCursor() - n4, n8, (StringIdItem)object, typeIdItem, stringIdItem);
                    break;
                }
                case DBG_END_LOCAL: {
                    int n9 = byteArrayInput.readUnsignedLeb128();
                    Object object = localArray[n9];
                    if (object == null) {
                        processDecodedDebugInstructionDelegate.ProcessEndLocal(n2, byteArrayInput.getCursor() - n4, n9, null, null, null);
                        break;
                    }
                    processDecodedDebugInstructionDelegate.ProcessEndLocal(n2, byteArrayInput.getCursor() - n4, n9, ((Local)object).name, ((Local)object).type, ((Local)object).signature);
                    break;
                }
                case DBG_RESTART_LOCAL: {
                    int n10 = byteArrayInput.readUnsignedLeb128();
                    Object object = localArray[n10];
                    if (object == null) {
                        processDecodedDebugInstructionDelegate.ProcessRestartLocal(n2, byteArrayInput.getCursor() - n4, n10, null, null, null);
                        break;
                    }
                    processDecodedDebugInstructionDelegate.ProcessRestartLocal(n2, byteArrayInput.getCursor() - n4, n10, ((Local)object).name, ((Local)object).type, ((Local)object).signature);
                    break;
                }
                case DBG_SET_PROLOGUE_END: {
                    processDecodedDebugInstructionDelegate.ProcessSetPrologueEnd(n2);
                    break;
                }
                case DBG_SET_EPILOGUE_BEGIN: {
                    processDecodedDebugInstructionDelegate.ProcessSetEpilogueBegin(n2);
                    break;
                }
                case DBG_SET_FILE: {
                    StringIdItem stringIdItem = dexFile.StringIdsSection.getOptionalItemByIndex(byteArrayInput.readUnsignedLeb128() - 1);
                    processDecodedDebugInstructionDelegate.ProcessSetFile(n2, byteArrayInput.getCursor() - n4, stringIdItem);
                    break;
                }
                case DBG_SPECIAL_OPCODE: {
                    int n11 = (by & 0xFF) - 10;
                    processDecodedDebugInstructionDelegate.ProcessLineEmit(n2 += n11 / 15, n3 += n11 % 15 - 4);
                }
            }
        }
    }

    private static class Local {
        public final int register;
        public final StringIdItem name;
        public final TypeIdItem type;
        public final StringIdItem signature;

        public Local(int n, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
            this.register = n;
            this.name = stringIdItem;
            this.type = typeIdItem;
            this.signature = stringIdItem2;
        }
    }

    public static class ProcessDecodedDebugInstructionDelegate {
        public void ProcessStartLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem) {
        }

        public void ProcessStartLocalExtended(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
        }

        public void ProcessEndLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
        }

        public void ProcessRestartLocal(int n, int n2, int n3, StringIdItem stringIdItem, TypeIdItem typeIdItem, StringIdItem stringIdItem2) {
        }

        public void ProcessSetPrologueEnd(int n) {
        }

        public void ProcessSetEpilogueBegin(int n) {
        }

        public void ProcessSetFile(int n, int n2, StringIdItem stringIdItem) {
        }

        public void ProcessLineEmit(int n, int n2) {
        }
    }

    public static class ProcessRawDebugInstructionDelegate {
        public void ProcessEndSequence(int n) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_END_SEQUENCE, n, 1);
        }

        public void ProcessAdvancePC(int n, int n2, int n3) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_ADVANCE_PC, n, n2);
        }

        public void ProcessAdvanceLine(int n, int n2, int n3) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_ADVANCE_LINE, n, n2);
        }

        public void ProcessStartLocal(int n, int n2, int n3, int n4, int n5, boolean bl) {
        }

        public void ProcessStartLocalExtended(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        }

        public void ProcessEndLocal(int n, int n2, int n3, boolean bl) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_END_LOCAL, n, n2);
        }

        public void ProcessRestartLocal(int n, int n2, int n3, boolean bl) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_RESTART_LOCAL, n, n2);
        }

        public void ProcessSetPrologueEnd(int n) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SET_PROLOGUE_END, n, 1);
        }

        public void ProcessSetEpilogueBegin(int n) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SET_EPILOGUE_BEGIN, n, 1);
        }

        public void ProcessSetFile(int n, int n2, int n3) {
        }

        public void ProcessSpecialOpcode(int n, int n2, int n3, int n4) {
            this.ProcessStaticOpcode(DebugOpcode.DBG_SPECIAL_OPCODE, n, 1);
        }

        public void ProcessStaticOpcode(DebugOpcode debugOpcode, int n, int n2) {
        }
    }
}

