/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jf.dexlib.AnnotationDirectoryItem;
import org.jf.dexlib.AnnotationItem;
import org.jf.dexlib.AnnotationSetItem;
import org.jf.dexlib.AnnotationSetRefList;
import org.jf.dexlib.ClassDataItem;
import org.jf.dexlib.ClassDefItem;
import org.jf.dexlib.CodeItem;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.EncodedArrayItem;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.HeaderItem;
import org.jf.dexlib.IndexedSection;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.MapItem;
import org.jf.dexlib.MethodIdItem;
import org.jf.dexlib.OdexDependencies;
import org.jf.dexlib.OdexHeader;
import org.jf.dexlib.OffsettedSection;
import org.jf.dexlib.ProtoIdItem;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.Section;
import org.jf.dexlib.StringDataItem;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.TypeListItem;
import org.jf.dexlib.Util.AlignmentUtils;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.ByteArrayInput;
import org.jf.dexlib.Util.ExceptionWithContext;
import org.jf.dexlib.Util.FileUtils;
import org.jf.dexlib.Util.Hex;

public class DexFile {
    private final Section[] sectionsByType;
    private final IndexedSection[] indexedSections;
    private final OffsettedSection[] offsettedSections;
    private final boolean preserveSignedRegisters;
    private final boolean skipInstructions;
    private boolean inplace;
    private boolean sortAllItems;
    private final DexFile dexFile;
    private boolean isOdex;
    private OdexHeader odexHeader;
    private OdexDependencies odexDependencies;
    private int dataOffset;
    private int dataSize;
    private int fileSize;
    public final HeaderItem HeaderItem;
    public final MapItem MapItem;
    public final IndexedSection<StringIdItem> StringIdsSection;
    public final IndexedSection<TypeIdItem> TypeIdsSection;
    public final IndexedSection<ProtoIdItem> ProtoIdsSection;
    public final IndexedSection<FieldIdItem> FieldIdsSection;
    public final IndexedSection<MethodIdItem> MethodIdsSection;
    public final IndexedSection<ClassDefItem> ClassDefsSection;
    public final OffsettedSection<TypeListItem> TypeListsSection;
    public final OffsettedSection<AnnotationSetRefList> AnnotationSetRefListsSection;
    public final OffsettedSection<AnnotationSetItem> AnnotationSetsSection;
    public final OffsettedSection<ClassDataItem> ClassDataSection;
    public final OffsettedSection<CodeItem> CodeItemsSection;
    public final OffsettedSection<StringDataItem> StringDataSection;
    public final OffsettedSection<DebugInfoItem> DebugInfoItemsSection;
    public final OffsettedSection<AnnotationItem> AnnotationsSection;
    public final OffsettedSection<EncodedArrayItem> EncodedArraysSection;
    public final OffsettedSection<AnnotationDirectoryItem> AnnotationDirectoriesSection;

    private DexFile(boolean bl, boolean bl2) {
        this.inplace = false;
        this.sortAllItems = false;
        this.dexFile = this;
        this.isOdex = false;
        this.HeaderItem = new HeaderItem(this);
        this.MapItem = new MapItem(this);
        this.StringIdsSection = new IndexedSection(this, ItemType.TYPE_STRING_ID_ITEM);
        this.TypeIdsSection = new IndexedSection(this, ItemType.TYPE_TYPE_ID_ITEM);
        this.ProtoIdsSection = new IndexedSection(this, ItemType.TYPE_PROTO_ID_ITEM);
        this.FieldIdsSection = new IndexedSection(this, ItemType.TYPE_FIELD_ID_ITEM);
        this.MethodIdsSection = new IndexedSection(this, ItemType.TYPE_METHOD_ID_ITEM);
        this.ClassDefsSection = new IndexedSection<ClassDefItem>(this, ItemType.TYPE_CLASS_DEF_ITEM){

            @Override
            public int placeAt(int n) {
                if (DexFile.this.dexFile.getInplace()) {
                    return super.placeAt(n);
                }
                int n2 = ClassDefItem.placeClassDefItems(this, n);
                Collections.sort(this.items, new Comparator<ClassDefItem>(){

                    @Override
                    public int compare(ClassDefItem classDefItem, ClassDefItem classDefItem2) {
                        return classDefItem.getOffset() - classDefItem2.getOffset();
                    }
                });
                this.offset = ((ClassDefItem)this.items.get(0)).getOffset();
                return n2;
            }
        };
        this.TypeListsSection = new OffsettedSection(this, ItemType.TYPE_TYPE_LIST);
        this.AnnotationSetRefListsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_SET_REF_LIST);
        this.AnnotationSetsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_SET_ITEM);
        this.ClassDataSection = new OffsettedSection(this, ItemType.TYPE_CLASS_DATA_ITEM);
        this.CodeItemsSection = new OffsettedSection(this, ItemType.TYPE_CODE_ITEM);
        this.StringDataSection = new OffsettedSection(this, ItemType.TYPE_STRING_DATA_ITEM);
        this.DebugInfoItemsSection = new OffsettedSection(this, ItemType.TYPE_DEBUG_INFO_ITEM);
        this.AnnotationsSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATION_ITEM);
        this.EncodedArraysSection = new OffsettedSection(this, ItemType.TYPE_ENCODED_ARRAY_ITEM);
        this.AnnotationDirectoriesSection = new OffsettedSection(this, ItemType.TYPE_ANNOTATIONS_DIRECTORY_ITEM);
        this.preserveSignedRegisters = bl;
        this.skipInstructions = bl2;
        this.sectionsByType = new Section[]{this.StringIdsSection, this.TypeIdsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.ClassDefsSection, this.TypeListsSection, this.AnnotationSetRefListsSection, this.AnnotationSetsSection, this.ClassDataSection, this.CodeItemsSection, this.AnnotationDirectoriesSection, this.StringDataSection, this.DebugInfoItemsSection, this.AnnotationsSection, this.EncodedArraysSection, null, null};
        this.indexedSections = new IndexedSection[]{this.StringIdsSection, this.TypeIdsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.ClassDefsSection};
        this.offsettedSections = new OffsettedSection[]{this.AnnotationSetRefListsSection, this.AnnotationSetsSection, this.CodeItemsSection, this.AnnotationDirectoriesSection, this.TypeListsSection, this.StringDataSection, this.AnnotationsSection, this.EncodedArraysSection, this.ClassDataSection, this.DebugInfoItemsSection};
    }

    public DexFile(String string) throws IOException {
        this(new File(string), true, false);
    }

    public DexFile(String string, boolean bl, boolean bl2) throws IOException {
        this(new File(string), bl, bl2);
    }

    public DexFile(File file) throws IOException {
        this(file, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DexFile(File file, boolean bl, boolean bl2) throws IOException {
        Section[] sectionArray;
        int n;
        Object object;
        ByteArrayInput byteArrayInput;
        block26: {
            this(bl, bl2);
            byte[] byArray = FileUtils.readFile(file, 0, 8);
            InputStream inputStream = null;
            byteArrayInput = null;
            ZipFile zipFile = null;
            try {
                long l;
                if (byArray[0] == 80 && byArray[1] == 75) {
                    zipFile = new ZipFile(file);
                    object = zipFile.getEntry("classes.dex");
                    if (object == null) {
                        throw new NoClassesDexException("zip file " + file.getName() + " does not contain a classes.dex " + "file");
                    }
                    l = ((ZipEntry)object).getSize();
                    if (l < 40L) {
                        throw new RuntimeException("The classes.dex file in " + file.getName() + " is too small to be a" + " valid dex file");
                    }
                    if (l > Integer.MAX_VALUE) {
                        throw new RuntimeException("The classes.dex file in " + file.getName() + " is too large to read in");
                    }
                    inputStream = new BufferedInputStream(zipFile.getInputStream((ZipEntry)object));
                    inputStream.mark(8);
                    for (n = 0; n < 8; ++n) {
                        byArray[n] = (byte)inputStream.read();
                    }
                    inputStream.reset();
                } else {
                    l = file.length();
                    if (l < 40L) {
                        throw new RuntimeException(file.getName() + " is too small to be a valid dex file");
                    }
                    if (l < 40L) {
                        throw new RuntimeException(file.getName() + " is too small to be a valid dex file");
                    }
                    if (l > Integer.MAX_VALUE) {
                        throw new RuntimeException(file.getName() + " is too large to read in");
                    }
                    inputStream = new FileInputStream(file);
                }
                boolean bl3 = false;
                this.isOdex = false;
                if (Arrays.equals(byArray, org.jf.dexlib.HeaderItem.MAGIC)) {
                    bl3 = true;
                } else if (Arrays.equals(byArray, OdexHeader.MAGIC_35)) {
                    this.isOdex = true;
                } else if (Arrays.equals(byArray, OdexHeader.MAGIC_36)) {
                    this.isOdex = true;
                }
                if (this.isOdex) {
                    byte[] objectArray = FileUtils.readStream(inputStream, 40);
                    ByteArrayInput i = new ByteArrayInput(objectArray);
                    this.odexHeader = new OdexHeader(i);
                    int n2 = this.odexHeader.depsOffset - this.odexHeader.dexOffset - this.odexHeader.dexLength;
                    if (n2 < 0) {
                        throw new ExceptionWithContext("Unexpected placement of the odex dependency data");
                    }
                    if (this.odexHeader.dexOffset > 40) {
                        FileUtils.readStream(inputStream, this.odexHeader.dexOffset - 40);
                    }
                    byteArrayInput = new ByteArrayInput(FileUtils.readStream(inputStream, this.odexHeader.dexLength));
                    if (n2 > 0) {
                        FileUtils.readStream(inputStream, n2);
                    }
                    this.odexDependencies = new OdexDependencies(new ByteArrayInput(FileUtils.readStream(inputStream, this.odexHeader.depsLength)));
                    break block26;
                }
                if (bl3) {
                    byteArrayInput = new ByteArrayInput(FileUtils.readStream(inputStream, (int)l));
                    break block26;
                }
                StringBuffer stringBuffer = new StringBuffer("bad magic value:");
                for (int i = 0; i < 8; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(Hex.u1(byArray[i]));
                }
                throw new RuntimeException(stringBuffer.toString());
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (zipFile != null) {
                    zipFile.close();
                }
            }
        }
        object = new ReadContext();
        this.HeaderItem.readFrom(byteArrayInput, 0, (ReadContext)object);
        n = ((ReadContext)object).getSectionOffset(ItemType.TYPE_MAP_LIST);
        byteArrayInput.setCursor(n);
        this.MapItem.readFrom(byteArrayInput, 0, (ReadContext)object);
        for (Section section : sectionArray = new Section[]{this.StringDataSection, this.StringIdsSection, this.TypeIdsSection, this.TypeListsSection, this.ProtoIdsSection, this.FieldIdsSection, this.MethodIdsSection, this.AnnotationsSection, this.AnnotationSetsSection, this.AnnotationSetRefListsSection, this.AnnotationDirectoriesSection, this.DebugInfoItemsSection, this.CodeItemsSection, this.ClassDataSection, this.EncodedArraysSection, this.ClassDefsSection}) {
            int n3;
            if (section == null || bl2 && (section == this.CodeItemsSection || section == this.DebugInfoItemsSection) || (n3 = ((ReadContext)object).getSectionOffset(section.ItemType)) <= 0) continue;
            int n4 = ((ReadContext)object).getSectionSize(section.ItemType);
            byteArrayInput.setCursor(n3);
            section.readFrom(n4, byteArrayInput, (ReadContext)object);
        }
    }

    public DexFile() {
        this(true, false);
    }

    public <T extends Item> Section<T> getSectionForItem(T t) {
        return this.sectionsByType[t.getItemType().SectionIndex];
    }

    public Section getSectionForType(ItemType itemType) {
        return this.sectionsByType[itemType.SectionIndex];
    }

    public boolean getPreserveSignedRegisters() {
        return this.preserveSignedRegisters;
    }

    public boolean skipInstructions() {
        return this.skipInstructions;
    }

    public boolean getSortAllItems() {
        return this.sortAllItems;
    }

    public void setSortAllItems(boolean bl) {
        this.sortAllItems = bl;
    }

    public boolean isOdex() {
        return this.isOdex;
    }

    public OdexDependencies getOdexDependencies() {
        return this.odexDependencies;
    }

    public OdexHeader getOdexHeader() {
        return this.odexHeader;
    }

    public boolean getInplace() {
        return this.inplace;
    }

    public int getFileSize() {
        return this.fileSize;
    }

    public int getDataSize() {
        return this.dataSize;
    }

    public int getDataOffset() {
        return this.dataOffset;
    }

    public void setInplace(boolean bl) {
        this.inplace = bl;
    }

    protected Section[] getOrderedSections() {
        int n = 0;
        for (Section section : this.sectionsByType) {
            if (section == null || section.getItems().size() <= 0) continue;
            ++n;
        }
        Section[] sectionArray = new Section[n];
        n = 0;
        for (Section section : this.sectionsByType) {
            if (section == null || section.getItems().size() <= 0) continue;
            sectionArray[n++] = section;
        }
        Arrays.sort(sectionArray, new Comparator<Section>(){

            @Override
            public int compare(Section section, Section section2) {
                return section.getOffset() - section2.getOffset();
            }
        });
        return sectionArray;
    }

    public void place() {
        Section section;
        Section[] sectionArray;
        int n = this.HeaderItem.placeAt(0, 0);
        int n2 = 0;
        if (this.inplace) {
            sectionArray = this.getOrderedSections();
        } else {
            sectionArray = new Section[this.indexedSections.length + this.offsettedSections.length];
            System.arraycopy(this.indexedSections, 0, sectionArray, 0, this.indexedSections.length);
            System.arraycopy(this.offsettedSections, 0, sectionArray, this.indexedSections.length, this.offsettedSections.length);
        }
        while (n2 < sectionArray.length && sectionArray[n2].ItemType.isIndexedItem()) {
            section = sectionArray[n2];
            if (!this.inplace) {
                section.sortSection();
            }
            n = section.placeAt(n);
            ++n2;
        }
        this.dataOffset = n;
        while (n2 < sectionArray.length) {
            section = sectionArray[n2];
            if (this.sortAllItems && !this.inplace) {
                section.sortSection();
            }
            n = section.placeAt(n);
            ++n2;
        }
        n = AlignmentUtils.alignOffset(n, ItemType.TYPE_MAP_LIST.ItemAlignment);
        this.fileSize = n = this.MapItem.placeAt(n, 0);
        this.dataSize = n - this.dataOffset;
    }

    public void writeTo(AnnotatedOutput annotatedOutput) {
        Section[] sectionArray;
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, "header item");
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, " ");
        this.HeaderItem.writeTo(annotatedOutput);
        annotatedOutput.annotate(0, " ");
        int n = 0;
        if (this.inplace) {
            sectionArray = this.getOrderedSections();
        } else {
            sectionArray = new Section[this.indexedSections.length + this.offsettedSections.length];
            System.arraycopy(this.indexedSections, 0, sectionArray, 0, this.indexedSections.length);
            System.arraycopy(this.offsettedSections, 0, sectionArray, this.indexedSections.length, this.offsettedSections.length);
        }
        while (n < sectionArray.length) {
            sectionArray[n].writeTo(annotatedOutput);
            ++n;
        }
        annotatedOutput.alignTo(this.MapItem.getItemType().ItemAlignment);
        annotatedOutput.annotate(0, " ");
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, "map item");
        annotatedOutput.annotate(0, "-----------------------------");
        annotatedOutput.annotate(0, " ");
        this.MapItem.writeTo(annotatedOutput);
    }

    public static void calcSignature(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException);
        }
        messageDigest.update(byArray, 32, byArray.length - 32);
        try {
            int n = messageDigest.digest(byArray, 12, 20);
            if (n != 20) {
                throw new RuntimeException("unexpected digest write: " + n + " bytes");
            }
        }
        catch (DigestException digestException) {
            throw new RuntimeException(digestException);
        }
    }

    public static void calcChecksum(byte[] byArray) {
        Adler32 adler32 = new Adler32();
        adler32.update(byArray, 12, byArray.length - 12);
        int n = (int)adler32.getValue();
        byArray[8] = (byte)n;
        byArray[9] = (byte)(n >> 8);
        byArray[10] = (byte)(n >> 16);
        byArray[11] = (byte)(n >> 24);
    }

    public static class NoClassesDexException
    extends ExceptionWithContext {
        public NoClassesDexException(String string) {
            super(string);
        }
    }
}

