/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.FieldIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class EnumEncodedValue
extends EncodedValue {
    public final FieldIdItem value;

    protected EnumEncodedValue(DexFile dexFile, Input input, byte by) {
        int n = (int)EncodedValueUtils.decodeUnsignedIntegralValue(input.readBytes(by + 1));
        this.value = dexFile.FieldIdsSection.getItemByIndex(n);
    }

    public EnumEncodedValue(FieldIdItem fieldIdItem) {
        this.value = fieldIdItem;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeUnsignedIntegralValue(this.value.getIndex());
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_ENUM.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: " + this.value.getFieldString());
        }
        annotatedOutput.writeByte(ValueType.VALUE_ENUM.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + EncodedValueUtils.getRequiredBytesForUnsignedIntegralValue(this.value.getIndex()) + 1;
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        EnumEncodedValue enumEncodedValue = (EnumEncodedValue)encodedValue;
        return this.value.getIndex() - enumEncodedValue.value.getIndex();
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_ENUM;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

