/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.EncodedValue;

import org.jf.dexlib.EncodedValue.EncodedValue;
import org.jf.dexlib.EncodedValue.ValueType;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.EncodedValueUtils;
import org.jf.dexlib.Util.Input;

public class FloatEncodedValue
extends EncodedValue {
    public final float value;

    protected FloatEncodedValue(Input input, byte by) {
        long l = EncodedValueUtils.decodeRightZeroExtendedValue(input.readBytes(by + 1));
        this.value = Float.intBitsToFloat((int)(l >> 32 & 0xFFFFFFFFL));
    }

    public FloatEncodedValue(float f) {
        this.value = f;
    }

    @Override
    public void writeValue(AnnotatedOutput annotatedOutput) {
        byte[] byArray = EncodedValueUtils.encodeRightZeroExtendedValue((long)Float.floatToRawIntBits(this.value) << 32);
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(1, "value_type=" + ValueType.VALUE_FLOAT.name() + ",value_arg=" + (byArray.length - 1));
            annotatedOutput.annotate(byArray.length, "value: " + this.value);
        }
        annotatedOutput.writeByte(ValueType.VALUE_FLOAT.value | byArray.length - 1 << 5);
        annotatedOutput.write(byArray);
    }

    @Override
    public int placeValue(int n) {
        return n + 1 + EncodedValueUtils.getRequiredBytesForRightZeroExtendedValue((long)Float.floatToRawIntBits(this.value) << 32);
    }

    @Override
    protected int compareValue(EncodedValue encodedValue) {
        FloatEncodedValue floatEncodedValue = (FloatEncodedValue)encodedValue;
        return Float.compare(this.value, floatEncodedValue.value);
    }

    @Override
    public ValueType getValueType() {
        return ValueType.VALUE_FLOAT;
    }

    public int hashCode() {
        return Float.floatToRawIntBits(this.value);
    }
}

