/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib;

import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.ItemType;
import org.jf.dexlib.ReadContext;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.Util.AnnotatedOutput;
import org.jf.dexlib.Util.Input;

public class TypeIdItem
extends Item<TypeIdItem> {
    private StringIdItem typeDescriptor;

    protected TypeIdItem(DexFile dexFile) {
        super(dexFile);
    }

    private TypeIdItem(DexFile dexFile, StringIdItem stringIdItem) {
        super(dexFile);
        this.typeDescriptor = stringIdItem;
    }

    public static TypeIdItem internTypeIdItem(DexFile dexFile, StringIdItem stringIdItem) {
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, stringIdItem);
        return dexFile.TypeIdsSection.intern(typeIdItem);
    }

    public static TypeIdItem internTypeIdItem(DexFile dexFile, String string) {
        StringIdItem stringIdItem = StringIdItem.internStringIdItem(dexFile, string);
        if (stringIdItem == null) {
            return null;
        }
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, stringIdItem);
        return dexFile.TypeIdsSection.intern(typeIdItem);
    }

    public static TypeIdItem lookupTypeIdItem(DexFile dexFile, String string) {
        StringIdItem stringIdItem = StringIdItem.lookupStringIdItem(dexFile, string);
        if (stringIdItem == null) {
            return null;
        }
        TypeIdItem typeIdItem = new TypeIdItem(dexFile, stringIdItem);
        return dexFile.TypeIdsSection.getInternedItem(typeIdItem);
    }

    @Override
    protected void readItem(Input input, ReadContext readContext) {
        int n = input.readInt();
        this.typeDescriptor = this.dexFile.StringIdsSection.getItemByIndex(n);
    }

    @Override
    protected int placeItem(int n) {
        return n + 4;
    }

    @Override
    protected void writeItem(AnnotatedOutput annotatedOutput) {
        if (annotatedOutput.annotates()) {
            annotatedOutput.annotate(4, this.typeDescriptor.getConciseIdentity());
        }
        annotatedOutput.writeInt(this.typeDescriptor.getIndex());
    }

    @Override
    public ItemType getItemType() {
        return ItemType.TYPE_TYPE_ID_ITEM;
    }

    @Override
    public String getConciseIdentity() {
        return "type_id_item: " + this.getTypeDescriptor();
    }

    @Override
    public int compareTo(TypeIdItem typeIdItem) {
        return this.typeDescriptor.compareTo(typeIdItem.typeDescriptor);
    }

    public String getTypeDescriptor() {
        return this.typeDescriptor.getStringValue();
    }

    public String toShorty() {
        String string = this.getTypeDescriptor();
        if (string.length() > 1) {
            return "L";
        }
        return string;
    }

    public int getRegisterCount() {
        String string = this.getTypeDescriptor();
        if (string.charAt(0) == 'J' || string.charAt(0) == 'D') {
            return 2;
        }
        return 1;
    }

    public int hashCode() {
        return this.typeDescriptor.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TypeIdItem typeIdItem = (TypeIdItem)object;
        return this.typeDescriptor == typeIdItem.typeDescriptor;
    }
}

