/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.HashMap;

public enum AccessFlags {
    PUBLIC(1, "public", true, true, true),
    PRIVATE(2, "private", true, true, true),
    PROTECTED(4, "protected", true, true, true),
    STATIC(8, "static", true, true, true),
    FINAL(16, "final", true, true, true),
    SYNCHRONIZED(32, "synchronized", false, true, false),
    VOLATILE(64, "volatile", false, false, true),
    BRIDGE(64, "bridge", false, true, false),
    TRANSIENT(128, "transient", false, false, true),
    VARARGS(128, "varargs", false, true, false),
    NATIVE(256, "native", false, true, false),
    INTERFACE(512, "interface", true, false, false),
    ABSTRACT(1024, "abstract", true, true, false),
    STRICTFP(2048, "strictfp", false, true, false),
    SYNTHETIC(4096, "synthetic", true, true, true),
    ANNOTATION(8192, "annotation", true, false, false),
    ENUM(16384, "enum", true, false, true),
    CONSTRUCTOR(65536, "constructor", false, true, false),
    DECLARED_SYNCHRONIZED(131072, "declared-synchronized", false, true, false);

    private int value;
    private String accessFlagName;
    private boolean validForClass;
    private boolean validForMethod;
    private boolean validForField;
    private static final AccessFlags[] allFlags;
    private static HashMap<String, AccessFlags> accessFlagsByName;

    private AccessFlags(int n2, String string2, boolean bl, boolean bl2, boolean bl3) {
        this.value = n2;
        this.accessFlagName = string2;
        this.validForClass = bl;
        this.validForMethod = bl2;
        this.validForField = bl3;
    }

    public static AccessFlags[] getAccessFlagsForClass(int n) {
        int n2 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForClass || (n & accessFlags.value) == 0) continue;
            ++n2;
        }
        AccessFlags[] accessFlagsArray = new AccessFlags[n2];
        int n3 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForClass || (n & accessFlags.value) == 0) continue;
            accessFlagsArray[n3++] = accessFlags;
        }
        return accessFlagsArray;
    }

    private static String formatAccessFlags(AccessFlags[] accessFlagsArray) {
        int n = 0;
        for (AccessFlags accessFlags : accessFlagsArray) {
            n += accessFlags.toString().length() + 1;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        for (AccessFlags accessFlags : accessFlagsArray) {
            stringBuilder.append(accessFlags.toString());
            stringBuilder.append(" ");
        }
        if (accessFlagsArray.length > 0) {
            stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
        }
        return stringBuilder.toString();
    }

    public static String formatAccessFlagsForClass(int n) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForClass(n));
    }

    public static AccessFlags[] getAccessFlagsForMethod(int n) {
        int n2 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForMethod || (n & accessFlags.value) == 0) continue;
            ++n2;
        }
        AccessFlags[] accessFlagsArray = new AccessFlags[n2];
        int n3 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForMethod || (n & accessFlags.value) == 0) continue;
            accessFlagsArray[n3++] = accessFlags;
        }
        return accessFlagsArray;
    }

    public static String formatAccessFlagsForMethod(int n) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForMethod(n));
    }

    public static AccessFlags[] getAccessFlagsForField(int n) {
        int n2 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForField || (n & accessFlags.value) == 0) continue;
            ++n2;
        }
        AccessFlags[] accessFlagsArray = new AccessFlags[n2];
        int n3 = 0;
        for (AccessFlags accessFlags : allFlags) {
            if (!accessFlags.validForField || (n & accessFlags.value) == 0) continue;
            accessFlagsArray[n3++] = accessFlags;
        }
        return accessFlagsArray;
    }

    public static String formatAccessFlagsForField(int n) {
        return AccessFlags.formatAccessFlags(AccessFlags.getAccessFlagsForField(n));
    }

    public static AccessFlags getAccessFlag(String string) {
        return accessFlagsByName.get(string);
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return this.accessFlagName;
    }

    static {
        allFlags = AccessFlags.values();
        accessFlagsByName = new HashMap();
        for (AccessFlags accessFlags : allFlags) {
            accessFlagsByName.put(accessFlags.accessFlagName, accessFlags);
        }
    }
}

