/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

public final class Leb128Utils {
    private Leb128Utils() {
    }

    public static int unsignedLeb128Size(int n) {
        int n2 = n >>> 7;
        int n3 = 0;
        while (n2 != 0) {
            n = n2;
            n2 >>>= 7;
            ++n3;
        }
        return n3 + 1;
    }

    public static int signedLeb128Size(int n) {
        int n2;
        int n3 = n >> 7;
        int n4 = 0;
        boolean bl = true;
        int n5 = n2 = (n & Integer.MIN_VALUE) == 0 ? 0 : -1;
        while (bl) {
            bl = n3 != n2 || (n3 & 1) != (n >> 6 & 1);
            n = n3;
            n3 >>= 7;
            ++n4;
        }
        return n4;
    }

    public static void writeUnsignedLeb128(int n, byte[] byArray, int n2) {
        int n3 = n >>> 7;
        int n4 = 0;
        while (n3 != 0) {
            byArray[n2] = (byte)(n & 0x7F | 0x80);
            ++n2;
            n = n3;
            n3 >>>= 7;
            ++n4;
        }
        byArray[n2] = (byte)(n & 0x7F);
    }
}

