/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Dumper;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Loader;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.resolver.Resolver;

public class Yaml {
    private final Dumper dumper;
    private final Loader loader;
    private final Resolver resolver;
    private String name;

    public Yaml(DumperOptions dumperOptions) {
        this(new Loader(), new Dumper(dumperOptions));
    }

    public Yaml(Dumper dumper) {
        this(new Loader(), dumper);
    }

    public Yaml(Loader loader) {
        this(loader, new Dumper(new DumperOptions()));
    }

    public Yaml(Loader loader, Dumper dumper) {
        this(loader, dumper, new Resolver());
    }

    public Yaml(Loader loader, Dumper dumper, Resolver resolver) {
        this.loader = loader;
        loader.setAttached();
        this.dumper = dumper;
        dumper.setAttached();
        this.resolver = resolver;
        this.loader.setResolver(resolver);
        this.name = "Yaml:" + System.identityHashCode(this);
    }

    public Yaml() {
        this(new Loader(), new Dumper(new DumperOptions()));
    }

    public String dump(Object object) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        return this.dumpAll(arrayList.iterator());
    }

    public String dumpAll(Iterator<? extends Object> iterator) {
        StringWriter stringWriter = new StringWriter();
        this.dumpAll(iterator, stringWriter);
        return stringWriter.toString();
    }

    public void dump(Object object, Writer writer) {
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        arrayList.add(object);
        this.dumpAll(arrayList.iterator(), writer);
    }

    public void dumpAll(Iterator<? extends Object> iterator, Writer writer) {
        this.dumper.dump(iterator, writer, this.resolver);
    }

    public Object load(String string) {
        return this.loader.load(new StringReader(string));
    }

    public Object load(InputStream inputStream) {
        return this.loader.load(new UnicodeReader(inputStream));
    }

    public Object load(Reader reader) {
        return this.loader.load(reader);
    }

    public Iterable<Object> loadAll(Reader reader) {
        return this.loader.loadAll(reader);
    }

    public Iterable<Object> loadAll(String string) {
        return this.loadAll(new StringReader(string));
    }

    public Iterable<Object> loadAll(InputStream inputStream) {
        return this.loadAll(new UnicodeReader(inputStream));
    }

    public Node compose(Reader reader) {
        return this.loader.compose(reader);
    }

    public Iterable<Node> composeAll(Reader reader) {
        return this.loader.composeAll(reader);
    }

    public void addImplicitResolver(String string, Pattern pattern, String string2) {
        this.resolver.addImplicitResolver(string, pattern, string2);
    }

    public String toString() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Iterable<Event> parse(Reader reader) {
        return this.loader.parse(reader);
    }
}

