/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tags;

public class Constructor
extends SafeConstructor {
    private final Map<String, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    public Constructor(Class<? extends Object> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject());
        if (!Object.class.equals(clazz)) {
            this.rootTag = Tags.getGlobalTagForClass(clazz);
        }
        this.typeTags = new HashMap<String, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructScalar());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping());
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequence());
    }

    public Constructor(String string) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(string)));
    }

    private static final String check(String string) {
        if (string == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (string.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return string;
    }

    public TypeDescription addTypeDescription(TypeDescription typeDescription) {
        if (typeDescription == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        if (this.rootTag == null && typeDescription.isRoot()) {
            this.rootTag = Tags.getGlobalTagForClass(typeDescription.getType());
        }
        String string = typeDescription.getTag();
        this.typeTags.put(string, typeDescription.getType());
        return this.typeDefinitions.put(typeDescription.getType(), typeDescription);
    }

    protected Class<?> getClassForNode(Node node) {
        Class<? extends Object> clazz = this.typeTags.get(node.getTag());
        if (clazz == null) {
            Class<?> clazz2;
            if (node.getTag().length() < "tag:yaml.org,2002:".length()) {
                throw new YAMLException("Unknown tag: " + node.getTag());
            }
            String string = node.getTag().substring("tag:yaml.org,2002:".length());
            try {
                clazz2 = this.getClassForName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new YAMLException("Class not found: " + string);
            }
            this.typeTags.put(node.getTag(), clazz2);
            return clazz2;
        }
        return clazz;
    }

    protected Class<?> getClassForName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    private class ConstructSequence
    implements Construct {
        private ConstructSequence() {
        }

        @Override
        public Object construct(Node node) {
            Object[] objectArray;
            int n;
            Object object2;
            SequenceNode sequenceNode = (SequenceNode)node;
            if (List.class.isAssignableFrom(node.getType()) || node.getType().isArray()) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultList(sequenceNode.getValue().size());
                }
                return Constructor.this.constructSequence(sequenceNode);
            }
            ArrayList arrayList = new ArrayList(sequenceNode.getValue().size());
            for (java.lang.reflect.Constructor<?> object32 : node.getType().getConstructors()) {
                if (sequenceNode.getValue().size() != object32.getParameterTypes().length) continue;
                arrayList.add(object32);
            }
            if (arrayList.isEmpty()) {
                throw new YAMLException("No constructors with " + String.valueOf(sequenceNode.getValue().size()) + " arguments found for " + node.getType());
            }
            if (arrayList.size() == 1) {
                object2 = new ArrayList(sequenceNode.getValue().size());
                java.lang.reflect.Constructor constructor = (java.lang.reflect.Constructor)arrayList.get(0);
                n = 0;
                for (Node node2 : sequenceNode.getValue()) {
                    objectArray = constructor.getParameterTypes()[n];
                    node2.setType((Class<? extends Object>)objectArray);
                    Object object = Constructor.this.constructObject(node2);
                    object2.add(object);
                    ++n;
                }
            } else {
                object2 = Constructor.this.constructSequence(sequenceNode);
            }
            Class[] classArray = new Class[object2.size()];
            n = 0;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                classArray[n] = e.getClass();
                ++n;
            }
            try {
                Class<? extends Object> clazz = node.getType();
                java.lang.reflect.Constructor<? extends Object> constructor = clazz.getConstructor(classArray);
                objectArray = object2.toArray();
                return constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new YAMLException(exception);
            }
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            SequenceNode sequenceNode = (SequenceNode)node;
            List list = (List)object;
            if (!List.class.isAssignableFrom(node.getType())) {
                throw new YAMLException("Immutable objects cannot be recursive.");
            }
            Constructor.this.constructSequenceStep2(sequenceNode, list);
        }
    }

    protected class ConstructScalar
    extends AbstractConstruct {
        protected ConstructScalar() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object construct(Node node) {
            Object object;
            ScalarNode scalarNode = (ScalarNode)node;
            Class<? extends Object> clazz = scalarNode.getType();
            if (clazz.isPrimitive() || clazz == String.class || Number.class.isAssignableFrom(clazz) || clazz == Boolean.class || Date.class.isAssignableFrom(clazz) || clazz == Character.class || clazz == BigInteger.class || Enum.class.isAssignableFrom(clazz) || "tag:yaml.org,2002:binary".equals(scalarNode.getTag())) {
                object = this.constructStandardJavaInstance(clazz, scalarNode);
            } else {
                java.lang.reflect.Constructor<?>[] constructorArray = clazz.getConstructors();
                int n = 0;
                java.lang.reflect.Constructor<Object> constructor = null;
                for (java.lang.reflect.Constructor<?> constructor2 : constructorArray) {
                    if (constructor2.getParameterTypes().length != 1) continue;
                    ++n;
                    constructor = constructor2;
                }
                if (constructor == null) {
                    throw new YAMLException("No single argument constructor found for " + clazz);
                }
                if (n == 1) {
                    Object object2 = this.constructStandardJavaInstance(constructor.getParameterTypes()[0], scalarNode);
                } else {
                    Object object3 = Constructor.this.constructScalar(scalarNode);
                    try {
                        constructor = clazz.getConstructor(String.class);
                    }
                    catch (Exception exception) {
                        throw new ConstructorException(null, null, "Can't construct a java object for scalar " + scalarNode.getTag() + "; No String constructor found. Exception=" + exception.getMessage(), scalarNode.getStartMark(), exception);
                    }
                }
                try {
                    void var8_11;
                    object = constructor.newInstance(var8_11);
                }
                catch (Exception exception) {
                    throw new ConstructorException(null, null, "Can't construct a java object for scalar " + scalarNode.getTag() + "; exception=" + exception.getMessage(), scalarNode.getStartMark(), exception);
                }
            }
            return object;
        }

        private Object constructStandardJavaInstance(Class clazz, ScalarNode scalarNode) {
            Object object;
            if (clazz == String.class) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:str");
                object = construct.construct(scalarNode);
            } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:bool");
                object = construct.construct(scalarNode);
            } else if (clazz == Character.class || clazz == Character.TYPE) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:str");
                String string = (String)construct.construct(scalarNode);
                if (string.length() == 0) {
                    object = null;
                } else {
                    if (string.length() != 1) {
                        throw new YAMLException("Invalid node Character: '" + string + "'; length: " + string.length());
                    }
                    object = new Character(string.charAt(0));
                }
            } else if (Date.class.isAssignableFrom(clazz)) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:timestamp");
                Date date = (Date)construct.construct(scalarNode);
                if (clazz == Date.class) {
                    object = date;
                } else {
                    try {
                        java.lang.reflect.Constructor constructor = clazz.getConstructor(Long.TYPE);
                        object = constructor.newInstance(date.getTime());
                    }
                    catch (Exception exception) {
                        throw new YAMLException("Cannot construct: '" + clazz + "'");
                    }
                }
            } else if (clazz == Float.class || clazz == Double.class || clazz == Float.TYPE || clazz == Double.TYPE || clazz == BigDecimal.class) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:float");
                object = construct.construct(scalarNode);
                if (clazz == Float.class || clazz == Float.TYPE) {
                    object = new Float((Double)object);
                } else if (clazz == BigDecimal.class) {
                    object = new BigDecimal((Double)object);
                }
            } else if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == BigInteger.class || clazz == Byte.TYPE || clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE) {
                Construct construct = (Construct)Constructor.this.yamlConstructors.get("tag:yaml.org,2002:int");
                object = construct.construct(scalarNode);
                object = clazz == Byte.class || clazz == Byte.TYPE ? (Number)new Byte(object.toString()) : (Number)(clazz == Short.class || clazz == Short.TYPE ? (Number)new Short(object.toString()) : (Number)(clazz == Integer.class || clazz == Integer.TYPE ? (Number)new Integer(object.toString()) : (Number)(clazz == Long.class || clazz == Long.TYPE ? new Long(object.toString()) : new BigInteger(object.toString()))));
            } else if (Enum.class.isAssignableFrom(clazz)) {
                String string = scalarNode.getValue();
                try {
                    object = Enum.valueOf(clazz, string);
                }
                catch (Exception exception) {
                    throw new YAMLException("Unable to find enum value '" + string + "' for enum class: " + clazz.getName());
                }
            } else {
                throw new YAMLException("Unsupported class: " + clazz);
            }
            return object;
        }
    }

    private class ConstructYamlObject
    implements Construct {
        private ConstructYamlObject() {
        }

        private Construct getConstructor(Node node) {
            Class<?> clazz = Constructor.this.getClassForNode(node);
            node.setType(clazz);
            Construct construct = (Construct)Constructor.this.yamlClassConstructors.get((Object)node.getNodeId());
            return construct;
        }

        @Override
        public Object construct(Node node) {
            Object object = null;
            try {
                object = this.getConstructor(node).construct(node);
            }
            catch (Exception exception) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + exception.getMessage(), node.getStartMark(), exception);
            }
            return object;
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            try {
                this.getConstructor(node).construct2ndStep(node, object);
            }
            catch (Exception exception) {
                throw new ConstructorException(null, null, "Can't construct a second step for a java object for " + node.getTag() + "; exception=" + exception.getMessage(), node.getStartMark(), exception);
            }
        }
    }

    private class ConstructMapping
    implements Construct {
        private final Map<Class<? extends Object>, Map<String, Property>> propertiesCache = new HashMap<Class<? extends Object>, Map<String, Property>>();

        private ConstructMapping() {
        }

        @Override
        public Object construct(Node node) {
            MappingNode mappingNode = (MappingNode)node;
            if (Properties.class.isAssignableFrom(node.getType())) {
                Properties properties = new Properties();
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Properties must not be recursive.");
                }
                Constructor.this.constructMapping2ndStep(mappingNode, properties);
                return properties;
            }
            if (SortedMap.class.isAssignableFrom(node.getType())) {
                TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
                if (!node.isTwoStepsConstruction()) {
                    Constructor.this.constructMapping2ndStep(mappingNode, treeMap);
                }
                return treeMap;
            }
            if (Map.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultMap();
                }
                return Constructor.this.constructMapping(mappingNode);
            }
            if (SortedSet.class.isAssignableFrom(node.getType())) {
                TreeSet<Object> treeSet = new TreeSet<Object>();
                if (!node.isTwoStepsConstruction()) {
                    Constructor.this.constructSet2ndStep(mappingNode, treeSet);
                }
                return treeSet;
            }
            if (Set.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultSet();
                }
                return Constructor.this.constructSet(mappingNode);
            }
            if (node.isTwoStepsConstruction()) {
                return this.createEmptyJavaBean(mappingNode);
            }
            return this.constructJavaBean2ndStep(mappingNode, this.createEmptyJavaBean(mappingNode));
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (Map.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
            } else if (Set.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
            } else {
                this.constructJavaBean2ndStep((MappingNode)node, object);
            }
        }

        private Object createEmptyJavaBean(MappingNode mappingNode) {
            try {
                Class<? extends Object> clazz = mappingNode.getType();
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    mappingNode.setType(Constructor.this.getClassForNode(mappingNode));
                }
                return mappingNode.getType().newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new YAMLException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new YAMLException(illegalAccessException);
            }
        }

        private Object constructJavaBean2ndStep(MappingNode mappingNode, Object object) {
            Class<? extends Object> clazz = mappingNode.getType();
            List<NodeTuple> list = mappingNode.getValue();
            for (NodeTuple nodeTuple : list) {
                if (!(nodeTuple.getKeyNode() instanceof ScalarNode)) {
                    throw new YAMLException("Keys must be scalars but found: " + nodeTuple.getKeyNode());
                }
                ScalarNode scalarNode = (ScalarNode)nodeTuple.getKeyNode();
                Node node = nodeTuple.getValueNode();
                scalarNode.setType(String.class);
                String string = (String)Constructor.this.constructObject(scalarNode);
                boolean bl = false;
                try {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object[] objectArray;
                    Property property = this.getProperty(clazz, string);
                    node.setType(property.getType());
                    if (property.getType().isArray()) {
                        bl = true;
                    }
                    TypeDescription typeDescription = (TypeDescription)Constructor.this.typeDefinitions.get(clazz);
                    boolean bl2 = false;
                    if (typeDescription != null) {
                        switch (node.getNodeId()) {
                            case sequence: {
                                objectArray = (SequenceNode)node;
                                object4 = typeDescription.getListPropertyType(string);
                                if (object4 != null) {
                                    objectArray.setListType((Class<? extends Object>)object4);
                                    bl2 = true;
                                    break;
                                }
                                if (!property.getType().isArray()) break;
                                bl = true;
                                objectArray.setListType(property.getType().getComponentType());
                                bl2 = true;
                                break;
                            }
                            case mapping: {
                                object3 = (MappingNode)node;
                                object2 = typeDescription.getMapKeyType(string);
                                if (object2 == null) break;
                                ((MappingNode)object3).setKeyType((Class<? extends Object>)object2);
                                ((MappingNode)object3).setValueType(typeDescription.getMapValueType(string));
                                bl2 = true;
                            }
                        }
                    }
                    if (!bl2 && node.getNodeId() != NodeId.scalar && (objectArray = property.getActualTypeArguments()) != null) {
                        if (node.getNodeId() == NodeId.sequence) {
                            object4 = (Class)objectArray[0];
                            object3 = (SequenceNode)node;
                            ((SequenceNode)object3).setListType((Class<? extends Object>)object4);
                        } else if ("tag:yaml.org,2002:set".equals(node.getTag())) {
                            object4 = (Class)objectArray[0];
                            object3 = (MappingNode)node;
                            ((MappingNode)object3).setKeyType((Class<? extends Object>)object4);
                            ((Node)object3).setUseClassConstructor(true);
                        } else if (node.getNodeId() == NodeId.mapping) {
                            object4 = (Class)objectArray[0];
                            object3 = (Class)objectArray[1];
                            object2 = (MappingNode)node;
                            ((MappingNode)object2).setKeyType((Class<? extends Object>)object4);
                            ((MappingNode)object2).setValueType((Class<? extends Object>)object3);
                            ((Node)object2).setUseClassConstructor(true);
                        }
                    }
                    objectArray = Constructor.this.constructObject(node);
                    if (bl && objectArray instanceof List) {
                        object4 = (List)objectArray;
                        objectArray = object4.toArray(this.createArray(property.getType()));
                    }
                    property.set(object, objectArray);
                }
                catch (Exception exception) {
                    throw new YAMLException("Cannot create property=" + string + " for JavaBean=" + object + "; " + exception.getMessage(), exception);
                }
            }
            return object;
        }

        private <T> T[] createArray(Class<T> clazz) {
            return (Object[])Array.newInstance(clazz.getComponentType(), 0);
        }

        private Property getProperty(Class<? extends Object> clazz, String string) throws IntrospectionException {
            Object[] objectArray;
            Map<String, Property> map = this.propertiesCache.get(clazz);
            if (map == null) {
                map = new HashMap<String, Property>();
                this.propertiesCache.put(clazz, map);
                for (PropertyDescriptor object : Introspector.getBeanInfo(clazz).getPropertyDescriptors()) {
                    String string2 = object.getName();
                    if (object.getWriteMethod() == null) continue;
                    map.put(string2, new MethodProperty(object));
                }
                objectArray = clazz.getFields();
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object object = objectArray[i];
                    int n2 = ((Field)object).getModifiers();
                    if (Modifier.isStatic(n2) || Modifier.isTransient(n2)) continue;
                    map.put(((Field)object).getName(), new FieldProperty((Field)object));
                }
            }
            if ((objectArray = map.get(string)) == null) {
                throw new YAMLException("Unable to find property '" + string + "' on class: " + clazz.getName());
            }
            return objectArray;
        }
    }
}

