<?php
require_once('OAuth.php');
require_once('kxoauth.php');

/**
* Kaixin Client
*/
class KXClient
{
    /**
     * Construct method
     */
    function __construct( $apikey , $consumer_key , $accecss_token = NULL, $accecss_token_secret = NULL ) 
    { 
        $this->oauth = new KXOAuth( $apikey , $consumer_key , $accecss_token , $accecss_token_secret ); 
    }
    
    /**
     * ûIDضû
     */
    function users_show( $uids, $fields = null, $start = 0, $num = 20 )
    {
        $url = 'users/show';
        $param = array(
            'uids' => $uids,
            'fields' => $fileds,
            'start' => $start,
            'num' => $num,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        );
    }
    
    /**
     * ȡǰ¼û
     */
    function users_me( $fields = null )
    {
        $url = 'users/me';
        $param = array(
            'fields' => $fileds,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        );
    }
    
    /**
     * ȡǰ¼ûĺ
     */
    function friends_me( $fields = null, $start = 0, $num = 20 )
    {
        $url = 'friends/me';
        $param = array(
            'fields' => $fileds,
            'start' => $start,
            'num' => $num,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        );
    }
    
    /**
     * û֮ѹϵ
     */
    function friends_relationship( $uid1, $uid2 )
    {
        $url = 'friends/relationship';
        $param = array(
            'uid1' => $uid1,
            'uid2' => $uid2,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        );
    }
    
    /**
     * ȡ˰װĺѵuidб
     */
    function app_friends( $start = 0, $num = 20 )
    {
        $url = 'app/friends';
        $param = array(
            'start' => $start,
            'num' => $num,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        );
    }
    
    /**
     * ȡûװ״̬
     */
    function app_status( $uids, $start = 0, $num = 20 )
    {
        $url = 'app/status';
        $param = array(
            'uids' => $uids,
            'start' => $start,
            'num' => $num,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        ); 
    }
    
    /**
     * ȡĳɹĺuidб
     */
    function app_invited( $uid, $start = 0, $num = 20 )
    {
       $url = 'app/invited';
        $param = array(
            'uid' => $uid,
            'start' => $start,
            'num' => $num,
        );
        $response = $this->oauth->get($url, $param);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        ); 
    }
    
    /**
     * ȡrequestToken
     */
    function getRequestToken( $callback = NULL)
    {
        $response = $this->oauth->getRequestToken( $callback );
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        ); 
    }
    
    /**
     * ȡAuthorizeUrl
     */
    function getAuthorizeURL( $token, $sign_in_with_kaixin = TRUE )
    {
        $response = $this->oauth->getAuthorizeURL($token, $sign_in_with_kaixin);
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        ); 
    }
    
    /**
     * ȡAccessToken
     */
    function getAccessToken( $verifier = false )
    {
        $response = $this->oauth->getAccessToken( $verifier );
        return array(
            'httpcode' => $this->oauth->http_code,
            'response' => $response,
        ); 
    }
}
?>