<?php

/* Start session and load library. */
session_start();
require_once('kxoauth/kxclient.php');
require_once('config.php');

/* Build KXOAuth object with client credentials. */
$connection = new KXClient(CONSUMER_KEY, CONSUMER_SECRET);
 
/* Get temporary credentials. */
$request_token_ret = $connection->getRequestToken(OAUTH_CALLBACK);

$request_token = $request_token_ret['response'];
$http_code = $request_token_ret['httpcode'];

/* Save temporary credentials to session. */
$_SESSION['oauth_token'] = $token = $request_token['oauth_token'];
$_SESSION['oauth_token_secret'] = $request_token['oauth_token_secret'];
 
/* If last connection failed don't display authorization link. */
switch ($http_code) {
  case 200:
    /* Build authorize URL and redirect user to Twitter. */
    $url = $connection->getAuthorizeURL($request_token);
    if($url['httpcode'] == 200){
        header('Location: ' . $url['response']); 
    }
    break;
  default:
    /* Show notification if something went wrong. */
    echo 'Could not connect to Kaixin API. Refresh the page or try again later.';
}
