﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Web;

namespace Oauth4Desktop
{
    public partial class Sample : Form
    {
        public Sample()
        {
            InitializeComponent();
            string[] strArr = new string[7] { "users/me", "users/show", "friends/me", "friends/relationship", "app/friends", "app/status", "app/invited" };
            this.methodsComboBox.DataSource = strArr;
        }

        oAuthKaixin oauth = new oAuthKaixin();

        private void GetRequestToken_Click(object sender, EventArgs e)
        {
            oauth.RequestTokenGet();
            this.rTokenBox.Text = oauth.token;
            this.rTokenSecretBox.Text = oauth.tokenSecret;
        }

        private void GetAuthlink_Click(object sender, EventArgs e)
        {
            this.KaixinAuthLink.Text = oauth.AuthorizationGet();
        }

        private void GetAccessToken_Click(object sender, EventArgs e)
        {
            oauth.Verifier = this.pinBox.Text;
            oauth.AccessTokenGet();
            this.aTokenBox.Text = oauth.token;
            this.aTokenSecretBox.Text = oauth.tokenSecret;
        }

        private void invoke_Click(object sender, EventArgs e)
        {
            string basic = "http://api.kaixin001.com/";
            string url = "";
            string param = this.urlparams.Text;
            if (param != "")
            {
                param = "?" + param;
            }
            switch (this.methodsComboBox.SelectedIndex)
            {
                case 0:
                    url = basic + "users/me.xml";
                    break;
                case 1:
                    url = basic + "users/show.xml";
                    break;
                case 2:
                    url = basic + "friends/me.xml";
                    break;
                case 3:
                    url = basic + "friends/relationship.xml";
                    break;
                case 4:
                    url = basic + "app/friends.xml";
                    break;
                case 5:
                    url = basic + "app/status.xml";
                    break;
                case 6:
                    url = basic + "app/invited.xml";
                    break;
                default:
                    break;
            }
            url = url + param;
            this.resultBox.Text = oauth.oAuthWebRequest(oAuthKaixin.Method.GET, url, String.Empty);
        }

    }
}
