
from .kx_auth import KxAuth
from .kx_config import HOST, RESPONSE_FORMAT

########################################################################
class KxClient(object):
    """
    notice :    
    1: authorization has two mode
    mode 1: set access_token and access_token_secret in init functions
    mode 2: first get authorization url and then set verifier, then call 
        get_access_token by verfier
    2: calling function like users_show when not authorized will raise 
        error
    """

    #----------------------------------------------------------------------
    def __init__(self, apiKey, apiSecret, callback = None, access_token = None,  access_token_secret = None):
        """Constructor"""
        self.kx_auth = KxAuth(apiKey, apiSecret, callback, access_token, access_token_secret)      
        
    #----------------------------------------------------------------------
    def users_show(self, uids, fields = None, start = 0, num = 20 ):
        """"""
        url = self._get_url("users/show")        
        params = {"uids":self._to_str(uids), "fields":self._to_str(fields), "start":start, "num":num}
        return self.kx_auth.get(url, params)
        
    #----------------------------------------------------------------------
    def users_me(self, fields = None):
        """"""
        url = self._get_url("users/me")
        params = {"fields": self._to_str(fields)}
        return self.kx_auth.get(url, params)       
    
    #----------------------------------------------------------------------
    def friends_me(self, fields = None, start = 0, num = 20):
        """"""
        url = self._get_url("friends/me")
        params = {"fields":self._to_str(fields), "start":start, "num":num}
        return self.kx_auth.get(url, params) 
        
    #----------------------------------------------------------------------
    def friends_relationship(self, uid1, uid2):
        """"""
        url = self._get_url("friends/relationship")
        params = {"uid1":uid1, "uid2":uid2}
        return self.kx_auth.get(url, params)
        
    #----------------------------------------------------------------------
    def app_friends(self, start = 0, num = 20):
        """"""
        url = self._get_url("app/friends")
        params = {"start":start, "num":num}
        return self.kx_auth.get(url, params) 
        
    #----------------------------------------------------------------------
    def app_status(self, uids, start = 0, num = 20):
        """"""
        url = self._get_url("app/status")
        params = {"uids":self._to_str(uids), "start":start, "num":num}
        return self.kx_auth.get(url, params) 
           
    #----------------------------------------------------------------------
    def app_invited(self, uid, start = 0, num = 20):
        """"""
        url = self._get_url("app/invited")
        params = {"uid":uid, "start":start, "num":num}
        return self.kx_auth.get(url, params)   
    
    #----------------------------------------------------------------------
    def get_authorization_url(self):
        """"""
        return self.kx_auth.get_authorization_url()
    
    #----------------------------------------------------------------------
    def get_access_token(self, verifier=None):
        """"""
        return self.kx_auth.get_access_token(verifier)    
    
    #----------------------------------------------------------------------
    def set_access_token(self, key, secret):
        """"""
        self.kx_auth.set_access_token(key, secret)
        
    #----------------------------------------------------------------------
    def _get_url(self, innerPath):
        """"""
        return HOST + innerPath + "." + RESPONSE_FORMAT       
    
    #----------------------------------------------------------------------
    def _to_str(self, listData):
        """"""
        if listData is None :
            return ""
        else :
            return "".join([ "%s," %t for t in listData])       
        
