
from urllib2 import Request, urlopen
from kx_config import *
from kx_error import KxError
import oauth

class KxAuth(object):
    """"""
    
    #----------------------------------------------------------------------        
    def __init__(self, consumer_key, consumer_secret, callback = None, access_token = None,  access_token_secret = None):
        """Constructor"""
        self._consumer = oauth.OAuthConsumer(consumer_key, consumer_secret)
        self._sigmethod = oauth.OAuthSignatureMethod_HMAC_SHA1()
        self.request_token = None        
        if access_token != None and access_token_secret != None :
            self.access_token = oauth.OAuthToken(access_token, access_token_secret)
        else :        
            self.access_token = None
        self.callback = callback
        
    #----------------------------------------------------------------------
    def to_url(self, url, parameters):
        """"""
        if self.access_token is None:
            raise KxError("access token is null, please set access tocken")
            
        request = oauth.OAuthRequest.from_consumer_and_token(
            self._consumer, http_url=url, http_method="GET",
            token=self.access_token, parameters=parameters
        )
        request.sign_request(self._sigmethod, self._consumer, self.access_token)
        return request.to_url()
    
    #----------------------------------------------------------------------
    def to_header(self, method, url, parameters):
        """"""        
        if self.access_token is None:
            raise KxError("access token is null, please set access tocken")
        
        request = oauth.OAuthRequest.from_consumer_and_token(
            self._consumer, http_url=url, http_method=method,
            token=self.access_token, parameters=parameters
        )
        request.sign_request(self._sigmethod, self._consumer, self.access_token)
        return request.to_header()
    
    #----------------------------------------------------------------------
    def to_postdata(self, url, parameters):
        """"""        
        if self.access_token is None:
            raise KxError("access token is null, please set access tocken")
        
        request = oauth.OAuthRequest.from_consumer_and_token(
            self._consumer, http_url=url, http_method="POST",
            token=self.access_token, parameters=parameters
        )
        request.sign_request(self._sigmethod, self._consumer, self.access_token)
        return request.to_postdata()        
        
    #----------------------------------------------------------------------
    def _get_request_token(self):
        """"""        
        try:
            request = oauth.OAuthRequest.from_consumer_and_token(
                self._consumer, http_url=REQUEST_TOKEN_URL, callback=self.callback
            )
            request.sign_request(self._sigmethod, self._consumer, None)
            resp = self._request_http(request.to_url())
            return oauth.OAuthToken.from_string(resp.read())
        except Exception, e:
            raise KxError(str(e))
    
    #---------------------------------------------------------------------- 
    def get_authorization_url(self):
        """"""
        try:
            self.request_token = self._get_request_token()
            
            request = oauth.OAuthRequest.from_token_and_callback(
                token=self.request_token, http_url=AUTHORIZE_URL, callback=self.callback
            )
            return request.to_url()
        except Exception, e:
            raise KxError(str(e))
    
    #----------------------------------------------------------------------   
    def get_access_token(self, verifier=None):
        """"""
        try:
            # build request
            request = oauth.OAuthRequest.from_consumer_and_token(
                self._consumer,
                token=self.request_token, http_url=ACCESS_TOKEN_URL,
                verifier=str(verifier)
            )
            request.sign_request(self._sigmethod, self._consumer, self.request_token)
            
            resp = self._request_http(request.to_url())
            self.access_token = oauth.OAuthToken.from_string(resp.read())
            
            return self.access_token
        except Exception, e:
            raise KxError(str(e))        
        
    #----------------------------------------------------------------------
    def get(self, url, params):
        """"""
        try:
            newUrl = self.to_url(url, params)
            resp = self._request_http(newUrl)
            return resp.read()      
        except Exception, e:
            raise KxError(str(e))
        
    #----------------------------------------------------------------------
    def post(self, url, params):
        """"""
        #not used, wait for realize
        
    #----------------------------------------------------------------------
    def delete(self, url, params):
        """"""
        #not used, wait for realize

    #----------------------------------------------------------------------
    def set_access_token(self, key, secret):
        """"""
        self.access_token = oauth.OAuthToken(key, secret)        
        
    #----------------------------------------------------------------------
    def _request_http(self, url):
        """"""
        request = Request(url)
        request.add_header('User-Agent', "KX PYTHON2.xSDK API v2.0.1")
        return urlopen(request)        
