%define brcmname tg3
%define brcmvers 3.85l
%define brcmfmly NetXtreme
%define brcmwork %{brcmname}-%{brcmvers}

%define debug_package %{nil}

Summary   : Broadcom %{brcmfmly} Gigabit ethernet driver
Name      : %{brcmname}
Version   : %{brcmvers}
Release   : 1
Vendor    : Broadcom Corporation
License   : GPL
Group     : System/Kernel
Source    : %{brcmwork}.tar.bz2
BuildRoot : /var/tmp/%{name}-%{version}-%{release}-buildroot

%define brcmfilelist file.list.%{name}

%description
This package contains the Broadcom %{brcmfmly} Gigabit ethernet driver.

%prep
%setup -T -b 0 -n %{brcmwork}

%build
value=%{?KVER}
if [ -z "$value" ];then
	KVER=$(uname -r)
else
	KVER=$value
fi
make KVER=$KVER

%install
value=%{?KVER}
if [ -z "$value" ];then
	KVER=$(uname -r)
else
	KVER=$value
fi

BCM_KVER=`echo $KVER | cut -c1-3 | sed 's/2\.[56]/2\.6/'`
if [ "$BCM_KVER" = "2.6" ];then
	BCM_DRV=%{brcmname}.ko
else
	BCM_DRV=%{brcmname}.o
fi

echo "%defattr(-,root,root)"                           > %{brcmfilelist}

echo "/lib/modules/$KVER/kernel/drivers/net/$BCM_DRV" >> %{brcmfilelist}
mkdir -p $RPM_BUILD_ROOT/lib/modules/$KVER/kernel/drivers/net

echo "/usr/share/man/man4/%{brcmname}.4.*"            >> %{brcmfilelist}
mkdir -p $RPM_BUILD_ROOT/usr/share/man/man4

make install PREFIX=$RPM_BUILD_ROOT KVER=$KVER

%post
depmod -a > /dev/null 2> /dev/null
exit 0

%postun
depmod -a > /dev/null 2> /dev/null
exit 0

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{brcmfilelist}
%doc LICENSE README.TXT ChangeLog

%changelog
