/****************************************************************************
 * Copyright(c) 2000-2006 Broadcom Corporation, all rights reserved
 * Proprietary and Confidential Information.
 *
 * This source file is the property of Broadcom Corporation, and
 * may not be copied or distributed in any isomorphic form without 
 * the prior written consent of Broadcom Corporation. 
 *
 * Name: BMAPI.h
 *
 * Description: Broadcom Management API.
 *
 * Author: hyfeng
 *
 ****************************************************************************/
#ifndef __BMAPI_h__
#define __BMAPI_h__

#ifdef __cplusplus
extern "C" 
{
#endif





/****************************************************************************
 *  Function Return Code
 ****************************************************************************/
#define BMAPI_OK                        0
#define BMAPI_MEMALLOC                  1       // memory allocation failed
#define BMAPI_READCONFIG                2       // read configuration failed
#define BMAPI_BUFSHORT                  3       // memory buffer too short
#define BMAPI_INVALID_HANDLE            4       // invalid handle
#define BMAPI_INVALID_PARAMETER         5       // one or more of parameters
                                                // are invalid
#define BMAPI_UNSUPPORT_PLATFORM        6       // platform not supported
#define BMAPI_INVALID_DATA_FROM_DRIVER  7       // driver returned data is not
                                                // correct
#define BMAPI_INTERNAL_DATA_ERROR       8       // internal data error
#define BMAPI_INIT_COM_FAILED           9       // initialize COM failed
#define BMAPI_TEAM_NOT_ENOUGH_NIC       10      // Each team must have at least
                                                // on team member and an
                                                // standby adapter or two team
                                                // members
#define BMAPI_INVALID_PHY_NIC_HANDLE    11      // an invalid physical NIC
                                                // handle is used
#define BMAPI_INVALID_TEAM_NAME         12      // the team name is empty or
                                                // has leading space
#define BMAPI_INVALID_TEAM_MEMBER       13      // all adapters of the same
                                                // driver class must be either
                                                // all assigned to teams or all
                                                // unassigned
#define BMAPI_INVALID_VLAN_MEMBER       14      // all physical adapters in the
                                                // team MUST be able to do VLAN
                                                // tag. Currently, only
                                                // BMAPI_ALTEON and
                                                // BMAPI_BRCM5700 can suppoort
                                                // VLAN
#define BMAPI_DRIVER_NOT_INSTALLED      15      // intermediate or miniport
                                                // driver not installed
#define BMAPI_CONFIGURE_REG_FAILED      16      // write registry failed
#define BMAPI_REBOOT_BEFORE_ADD         17      // reboot machine before add
                                                // adapter
#define BMAPI_LOAD_LIBRARY_FAILED       18      // load external help library
                                                // failed
#define BMAPI_CONFIGURE_SYS_FAILED      19      // configure system error
#define BMAPI_DRIVER_NOT_LOADED         20      // driver is not loaded
#define BMAPI_DEVIO_CALL_FAILED         21      // DeviceIoControl() failed
#define BMAPI_BINDING_FAILED            22      // binding is not completed
#define BMAPI_SERVICE_EXIST             23      // service is installed, users
                                                // may need to reboot machine
#define BMAPI_SERVICE_MARK_DELETE       24      // service is marked to delete,
                                                // users may need to reboot
                                                // machine
#define BMAPI_CREATE_SERVICE_FAILED     25      // unable to create service
#define BMAPI_DELETE_SERVICE_FAILED     26      // unable to delete service
#define BMAPI_REMOVE_ROUTE_FAILED       27      // RemoveRouteFromNETBIOS()
                                                // failed
#define BMAPI_DRIVER_COMMUNICATE_ERROR  28      // failed to communicate with
                                                // driver
#define BMAPI_DEV_IN_DIAG               29      // the device is in diag mode
#define BMAPI_FUNCTION_NOT_ALLOWED      BMAPI_DEV_IN_DIAG   // obsolete
                                                // can be called
#define BMAPI_INVALID_TEAM_ID           30      // invalid team ID
#define BMAPI_UPDATE_CONFIG_FAILED      31      // update configuration failed
#define BMAPI_WRONG_DRIVER_VERSION      32      // the version of driver is not
                                                // supported by BMAPI
#define BMAPI_NO_MAC_ADDR               33      // no MAC address configured
#define BMAPI_NO_VIRTUAL_ADAPTER        34      // no virtual adapter
                                                // configured for the team
#define BMAPI_NO_WRITE_ACCESS_RIGHT     35      // no write access right
#define BMAPI_NOT_SUPPORTED_NIC         36      // the NIC is not supported
#define BMAPI_STANDBY_NOT_SUPPORTED     37      // stand by adapter is not
                                                // supported for the team type
#define BMAPI_CAN_NOT_LOCK_NETCFG       38      // failed to lock network
                                                // configuration in Win2000
#define BMAPI_BMAPI_NOT_INITIALIZED     39      // applications did not call
                                                // BmapiInitialize()
#define BMAPI_EVENT_FEATURE_INI_FAILED  40      // initializeation for event
                                                // feature failed
#define BMAPI_DUPLICATE_TEAM_NAME       41      // applications submit
                                                // duplicate team name when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_PHY_NIC         42      // applications submit
                                                // duplicate physical NIC in
                                                // team configuration when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_NO_VLAN_NAME              43      // applications submit more
                                                // than one virtual adapter
                                                // for a team and one or more
                                                // virtual adapter doesn't have
                                                // a VLAN name when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_VLAN_NAME       44      // applications submit
                                                // duplicate VLAN name in a
                                                // team when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_DUPLICATE_VLAN_ID         45      // applications submit
                                                // duplicate VLAN ID in a
                                                // team when calling
                                                // BmapiApplyLBFOCfg
#define BMAPI_INVALID_VLAN_ID           46      // application submit invalid
                                                // VLAN ID when calling
                                                // BmapiApplyLBFOCfg. Valid
                                                // VLAN ID could be from 0 to
                                                // 4094.
#define BMAPI_TOO_MANY_TAGGED_VLANS     47      // we only support up to
                                                // BMAPI_MAXIMUM_MEMBERS_VIR_TEAM - 1
                                                // tagged VLANs plus one
                                                // optional untagged VLAN
#define BMAPI_TOO_MANY_PHY_NICS         48      // too many physical NICs in
                                                // a team
#define BMAPI_TOO_MANY_VIR_NICS         49      // too many virtual NICs in
                                                // a team
#define BMAPI_DUPLICATE_TEAM_ID         50      // applications submit
                                                // duplicate team ID when
                                                // calling BmapiApplyLBFOCfg
#define BMAPI_NIC_NOT_FOUND             51      // NIC not found
#define BMAPI_NIC_NOT_IN_TEAM           52      // NIC is not in the team
#define BMAPI_SCM_LOCKED                53      // service control manager is
                                                // locked
#define BMAPI_UNSUPPORTED_VERSION       54      // unsupported version for
                                                // the data structure
#define BMAPI_UNSUPPORTED_IOCTL         55      // unsupported IOCTL
#define BMAPI_ASF_NOT_CAPABLE           56      // the NIC is not capable of
                                                // ASF feature
#define BMAPI_ASF_NOT_CONFIGURED        57      // the NIC is not configured
                                                // for ASF
#define BMAPI_EEPROM_CORRUPTED          58      // EEPROM of the NIC is
                                                // corrupted
#define BMAPI_READ_EEPROM_FAILED        59      // read EEPROM failed
#define BMAPI_ASF_TABLE_CORRUPTED       60      // ASF table in NIC is
                                                // corrupted
#define BMAPI_SUSPEND_DRIVER_FAILED     61      // failed to suspend driver
                                                // or NIC
#define BMAPI_WRITE_ASF_TABLE_FAILED    62      // obsolete
#define BMAPI_LOCK_NIC_FAILED           63      // failed to gain exclusive
                                                // access to a NIC. Try later.
#define BMAPI_DRIVER_NOT_SUSPENDED      64
#define BMAPI_REGISTER_TEST_FAILED      65
#define BMAPI_MII_REGISTER_TEST_FAILED  66
#define BMAPI_MEMORY_TEST_FAILED        67
#define BMAPI_TEST_INTERRUPT_FAILED     68
#define BMAPI_CPU_TEST_FAILED           69
#define BMAPI_UNABLE_TO_RESET_RX_CPU    70
#define BMAPI_UNABLE_TO_RESET_TX_CPU    71
#define BMAPI_RX_CPU_TEST_FAILED        72
#define BMAPI_TX_CPU_TEST_FAILED        73
#define BMAPI_RESUME_DRIVER_FAILED      74
#define BMAPI_UNABLE_TO_GET_SERVICE_NAME    75
#define BMAPI_UNABLE_TO_LOAD_INTERMEDIATE_DRIVER    76
#define BMAPI_UNABLE_TO_SET_PACKET_FILTER   77
#define BMAPI_LOOPBACK_TEST_FAILED      78
#define BMAPI_NO_DIAG_ACCESS_RIGHT      79      // application did not call
                                                // BmapiInitDiag() with
                                                // successful return
#define BMAPI_WRITE_EEPROM_FAILED       80      // write EEPROM failed
#define BMAPI_ASF_TEST_RESET_FAILED     81      // ASF reset failed
#define BMAPI_ASF_TEST_RX_EVENT_FAILED  82      // ASF RXCPU event failed
#define BMAPI_ASF_TEST_TX_EVENT_FAILED  83      // ASF TXCPU event failed
#define BMAPI_ASF_TEST_POLL_TIMER_FAILED    84  // ASF poll timer failed
#define BMAPI_ASF_TEST_ATTN_LOC_FAILED  85      // ASF ATTN loc failed
#define BMAPI_ASF_TEST_HB_TIMER_FAILED  86      // ASF heartbeat timer failed
#define BMAPI_ASF_TEST_PL_TIMER_FAILED  87      // ASF poll legacy timer failed
#define BMAPI_ASF_TEST_RT_TIMER_FAILED  88      // ASF retransmit timer failed
#define BMAPI_ASF_TEST_WD_TIMER_FAILED  89      // ASF watchdog timer failed
#define BMAPI_ASF_TEST_NO_STAMP         90      // ASF timestamp counter is not
                                                // counting
#define BMAPI_NO_WRITE_EEPROM_PRIV      91      // No priviledge to write
                                                // EEPROM
#define BMAPI_FW_NOT_LOADED             92      // Firmware is not loaded
#define BMAPI_NO_READ_EEPROM_PRIV       93      // No priviledge to read
                                                // EEPROM
#define BMAPI_NO_SYSTEM_UUID            94      // no system UUID found
#define BMAPI_NO_ASF_TABLES             95      // no ASF tables found
#define BMAPI_UNSUPPORTED_FW_VERSION    96      // unsupported firmware version
#define BMAPI_INVALID_OFFSET_OR_LEN     97      // offset or length must be at
                                                // 32-bit alignment
#define BMAPI_READ_REGISTER_FAILED      98      // read register failed
#define BMAPI_WRITE_REGISTER_FAILED     99      // write register failed
#define BMAPI_NO_READ_NIC_MEM_PRIV      100     // no priviledge to read NIC
                                                // memory
#define BMAPI_READ_NIC_MEM_FAILED       101     // read NIC memory failed
#define BMAPI_NO_WRITE_NIC_MEM_PRIV     102     // no priviledge to write NIC
                                                // memory
#define BMAPI_WRITE_NIC_MEM_FAILED      103     // write NIC memory failed
#define BMAPI_CREATELOCK_FAILED         104     // create lock fialed
#define BMAPI_READ_PCI_CONFIG_FAILED    105     // read PCI configuration
#define BMAPI_FILE_OPEN_FAILED          106     // file open failed
#define BMAPI_MEM_MAP_FAILED            107     // map mempry failed
#define BMAPI_NO_IP_INFO                108     // can not find IP information
                                                // for an adapter, could be
                                                // driver is not loaded or
                                                // no IP bind to the adapter
#define BMAPI_NETTEST_INI_FAILED        109     // NetworkTest init failed
                                                // no IP protocol???
#define BMAPI_NETTEST_CFG_FAILED        110     // NetworkTest configure test
                                                // failed
#define BMAPI_NETTEST_ADAPT_NOIP        111     // adapter has no valid IP
#define BMAPI_NETTEST_ADAPT_BIND        112     // bind to adapter failed
#define BMAPI_NETTEST_INVALID_DEST      113     // invalid destination address
#define BMAPI_NETTEST_SEND_FAILED       114     // send packet failed
#define BMAPI_NETTEST_RECV_FAILED       115     // receive packet failed
#define BMAPI_NETTEST_TEST_FAILED       116     // no response received
#define BMAPI_INVALID_TEAMTYPE_CHANGE   117     // unsupported team type
                                                // changed
#define BMAPI_INVALID_TTCFG_PHY         118     // obsolete
#define BMAPI_UNSUPPORTED_TT_OS         119     // obsolete
#define BMAPI_NO_TT_IN_BASP             120     // obsolete
#define BMAPI_NOT_TT_NIC                121     // obsolete
#define BMAPI_CONFIG_TT_FAILED          122     // obsolete
#define BMAPI_INVALID_TEAMTYPE          123     // unsupported team type
#define BMAPI_NON_TT_DRIVER             124     // obsolete
#define BMAPI_PHY_OFF                   125     // PHY is off
#define BMAPI_LOOPBACK_TEST_NOLINK      126     // no link for loopback test
#define BMAPI_OBSOLETE_API              127     // the API is now obsolete
#define BMAPI_FILE_NOT_FOUND            128     // dependent file is not found
#define BMAPI_OS_ACCESS_DENIED          129     // user does not have access
                                                // right
#define BMAPI_CONNECT_SCM_FAILED        130     // failed to connect to service
                                                // control manager
#define BMAPI_NOT_SUPPORTED_DRV         131     // the driver is not supported

// The following are defined during 5706 development and subject to change in
// the future.
#define BMAPI_FEATURE_NOT_AVAILABLE     200     // the request feature is not
                                                // available for the device
#define BMAPI_REBOOT_REQUIRED           201     // reboot machine is required
                                                // to recover from the failure
#define BMAPI_RESTART_DEVICE_FAILED     202     // failed to restart a device
#define BMAPI_CREATE_DEVICE_FAILED      203     // failed to create a device
#define BMAPI_FIND_DEVICE_FAILED        204     // failed to find an installed
                                                // device. Could be driver is
                                                // not installed yet.
#define BMAPI_LED_TEST_FAILED           205     // LED test failed
#define BMAPI_LICENSE_INFO_TIMEOUT      206     // read or write license key
                                                // timeout
#define BMAPI_LICENSE_INFO_BUSY         207     // another license information
                                                // request pending, try again
                                                // later
#define BMAPI_LICENSE_KEY_NOTEXIST      208     // the license key does not
                                                // exist
#define BMAPI_LICENSE_KEY_INVALID       209     // the license key is invalid
#define BMAPI_NO_VALID_LICENSE_KEY      210     // no valice key cen be found
                                                // in the NIC
#define BMAPI_CON_EXCEED_HW_MAX         211     // number of reserved
                                                // connections exceeds
                                                // hardware limitation
#define BMAPI_CON_EXCEED_LIC_MAX        212     // number of reserved
                                                // connections exceeds
                                                // licensed connections
#define BMAPI_RES_EXCEED_HW_MAX         213     // total reserved resources
                                                // exceeds hardware limitation
#define BMAPI_RES_NOT_LICENSED          214     // reserved connections are
                                                // not licensed
#define BMAPI_UNSUPPORTED_ADDR_TYPE     215     // unsupported address type
#define BMAPI_DUPLICATE_ADDR            216     // duplicate address
#define BMAPI_PROBE_UNSUPPORTED         217     // probe packe is not supported
#define BMAPI_NO_TARGET_IP              218     // no target IP configured for
                                                // Probe Packet feature
#define BMAPI_NO_PHY_PROBE_IP           219     // no IP configured for
                                                // physical NIC for Probe
                                                // Packet feature
#define BMAPI_CABDIAG_FAIL              220     // cable diag failed
#define BMAPI_CREATE_THREAD_FAILED      221     // failed to create thread
#define BMAPI_DOING_DIAGNOSTICS         222     // a diagnostics is running
                                                // already
#define BMAPI_NO_DIAGNOSTICS            223     // no pending diagnostics
#define BMAPI_CAN_NOT_STOP_DIAG         224     // failed to stop diagnostics
#define BMAPI_MANUF_KEY_CRC_ERR         225     // manufacturing key CRC error
#define BMAPI_UPG_KEY_CRC_ERR           226     // upgrade key CRC error



/****************************************************************************
 *  Other definitions
 ****************************************************************************/

#define BMAPI_MAJOR_VERSION             6
#define BMAPI_MINOR_VERSION             3
#define BMAPI_BUILD_VERSION             47

#define BMAPI_MAXIMUM_MEMBERS_PHY_TEAM  8
#define BMAPI_MAXIMUM_MEMBERS_VIR_TEAM  64

#define BMAPI_MEMBER_STATE_UP           0
#define BMAPI_MEMBER_STATE_DOWN         1
#define BMAPI_MEMBER_STATE_DISABLED     2

#define BMAPI_MEMBER_ROLE_LOAD_BALANCE  0
#define BMAPI_MEMBER_ROLE_STAND_BY      1

// These are for 'nic_type' phisical devices.

#define BMAPI_NON_BROADCOM_NIC          0
#define BMAPI_ALTEON                    1
#define BMAPI_BRCM5700                  2
#define BMAPI_UNKNOWN_NIC               3       // driver is not running
#define BMAPI_BRCM5706                  4
#define BMAPI_BRCM57710                 5
// These are for 'nic_type' virtual devices.
#define BMAPI_BASP_VIR                  100
#define BMAPI_5706_NDIS                 101
#define BMAPI_5706_WSD                  102
#define BMAPI_5706_ISCSI                103
#define BMAPI_5706_DIAG                 104


#define BMAPI_MAX_PRODUCT_LEN           80
#define BMAPI_MAX_DESC_LEN              80
#define BMAPI_MAX_VLAN_NAME_LEN         40
#define BMAPI_MAX_TEAM_NAME_LEN         40
#define BMAPI_MAX_IP_ADDR_LEN           20
#define BMAPI_MAX_MEMORY_ADDR_LEN       80
#define BMAPI_MAX_MAC_ADDR_LEN          20
#define BMAPI_MAX_TITLE_LEN             80
#define BMAPI_MAX_MFG_LEN               80
#define BMAPI_MAX_DRV_NAME              32
#define BMAPI_MAX_DRV_INT_TYPE          16
#define BMAPI_MAX_DRVVER_LEN            40

#define BMAPI_INVALID_NIC_HANDLE        0
#define BMAPI_INVALID_TEAM_HANDLE       0

#define BMAPI_MAX_VLAN_ID               4094

// 'uType' definition for BmapiReadNicMem() and BmapiWriteNicMem().
#define BMAPI_INDIRECT_REG_READ         0
#define BMAPI_INDIRECT_MEM_READ         1
#define BMAPI_PHY_REG_READ              2
#define BMAPI_REG_READ                  3
#define BMAPI_MEM_READ                  4

#define BMAPI_INDIRECT_REG_WRITE        0
#define BMAPI_INDIRECT_MEM_WRITE        1
#define BMAPI_PHY_REG_WRITE             2
#define BMAPI_REG_WRITE                 3
#define BMAPI_MEM_WRITE                 4
/****************************************************************************
 *  OBSOLETE starts here
 ****************************************************************************/

// Used by BmapiGetMultiBRCMNicParams()
#define BMAPI_BRCMNIC_PARAM_TYPE_UNKNOWN    0
#define BMAPI_BRCMNIC_PARAM_TYPE_DWORD      1
#define BMAPI_BRCMNIC_PARAM_TYPE_BINARY     2   // binary data

#define BMAPI_BRCMNIC_PARAM_RESULT_OK           0
#define BMAPI_BRCMNIC_PARAM_RESULT_NOTEXIST     1   // not exist
#define BMAPI_BRCMNIC_PARAM_RESULT_NOTSUPPORTED 2   // not supported
#define BMAPI_BRCMNIC_PARAM_RESULT_ERROR        3   // registry reading error
#define BMAPI_BRCMNIC_PARAM_RESULT_BUFTOOSHORT  4   // buffer too short
#define BMAPI_BRCMNIC_PARAM_RESULT_WRONGDATALEN 5   // incorrect parameter data length
#define BMAPI_BRCMNIC_PARAM_RESULT_DATAINVALID  6   // invalid data value for the parameter

// Configurable Broadcom NIC parameters.
#define BMAPI_BRCMNIC_RXJUMBODESCCNT    0   // type: DWORD, range: 0-255, default: 0
#define BMAPI_BRCMNIC_TASKOFFLOADCAP    1   // type: DWORD
                                            // value: 0 - None (default)
                                            // value: 21 - Tx TCP/IP Checksum
                                            // value: 42 - Rx TCP/IP Checksum
                                            // value: 63 - Tx/Rx TCP/IP Checksum
#define BMAPI_BRCMNIC_WAKEUPMODECAP     2   // type: DWORD
                                            // value: 0 - None
                                            // value: 1 - Magic Packet
                                            // value: 2 - Wake Up Frame
                                            // value: 3 - Both (default)
#define BMAPI_BRCMNIC_FLOWCONTROLCAP    3   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Rx PAUSE
                                            // value: 2 - Tx PAUSE
                                            // value: 3 - Rx/Tx PAUSE
                                            // value: 2147483648 - Auto
#define BMAPI_BRCMNIC_ENABLE8021P       4   // type: DWORD
                                            // value: 0 - Disable (default)
                                            // value: 1 - Enable
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE    5   // type: DWORD
                                            // value: 1500 (bytes) (default)
                                            // value: 2000 (bytes)
                                            // value: 2500 (bytes)
                                            // value: 3000 (bytes)
                                            // value: 3500 (bytes)
                                            // value: 4000 (bytes)
                                            // value: 4500 (bytes)
                                            // value: 5000 (bytes)
                                            // value: 5500 (bytes)
                                            // value: 6000 (bytes)
                                            // value: 6500 (bytes)
                                            // value: 7000 (bytes)
                                            // value: 7500 (bytes)
                                            // value: 8000 (bytes)
#define BMAPI_BRCMNIC_NETWORKADDRESS    6   // type: binary (6 bytes)
#define BMAPI_BRCMNIC_WOL_SPEED         7   // type: DWORD
                                            // value: 0 - Auto (default)
                                            // value: 1 - 10 Mb
                                            // value: 2 - 100 Mb

// Parameter values for Broadcom NIC.
#define BMAPI_BRCMNIC_RXJUMBODESCCNT_MIN                0   // default
#define BMAPI_BRCMNIC_RXJUMBODESCCNT_MAX                255

#define BMAPI_BRCMNIC_TASKOFFLOADCAP_NONE               0   // default
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_TXTCPIPCHKSUM      21
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_RXTCPIPCHKSUM      42
#define BMAPI_BRCMNIC_TASKOFFLOADCAP_TXRXTCPIPCHKSUM    63

#define BMAPI_BRCMNIC_WAKEUPMODECAP_NONE                0
#define BMAPI_BRCMNIC_WAKEUPMODECAP_MAGICPACKET         1
#define BMAPI_BRCMNIC_WAKEUPMODECAP_WAKEUPFRAME         2
#define BMAPI_BRCMNIC_WAKEUPMODECAP_BOTH                3   // default

#define BMAPI_BRCMNIC_FLOWCONTROLCAP_DISABLE            0   // default
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_RXPAUSE            1
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_TXPAUSE            2
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_RXTXPAUSE          3
#define BMAPI_BRCMNIC_FLOWCONTROLCAP_AUTO               2147483648

#define BMAPI_BRCMNIC_ENABLE8021P_DISABLE               0   // default
#define BMAPI_BRCMNIC_ENABLE8021P_ENABLE                1

#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_1500               1500    // default
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_2000               2000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_2500               2500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_3000               3000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_3500               3500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_4000               4000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_4500               4500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_5000               5000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_5500               5500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_6000               6000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_6500               6500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_7000               7000
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_7500               7500
#define BMAPI_BRCMNIC_JUMBOFRAMESIZE_8000               8000

#define BMAPI_BRCMNIC_WOL_SPEED_AUTO                    0   // default
#define BMAPI_BRCMNIC_WOL_SPEED_10MB                    1
#define BMAPI_BRCMNIC_WOL_SPEED_100MB                   2
/****************************************************************************
 *  OBSOLETE ends here
 ****************************************************************************/


// ASF definition
#define BMAPI_MAX_ALERTDATA                             8
#define BMAPI_ASF_SPEC_1_0_ALERTDATA_ELEMENT_LENGTH     12
#define BMAPI_MAX_CONTROLDATA                           8
#define BMAPI_MAX_SPEC_1_0_CONTROLDATA_ELEMENT_LENGTH   4

// since structure ASF_ADDR has extra 2 bytes other than FixedSMBusAddresses,
// to align the structure to LONG, BMAPI_MAX_FIXEDSMBUSADDR should use
// (multiple of 4) - 2. In this case, we are using 14.
#define BMAPI_MAX_FIXEDSMBUSADDR                        14

// speed defines for BM_ASF_MISC
#define BMAPI_ASF_SPEED_10_100          0
#define BMAPI_ASF_SPEED_10              1
#define BMAPI_ASF_SPEED_100             2
#define BMAPI_ASF_SPEED_1000            3
#define BMAPI_ASF_SPEED_ALL             4
#define BMAPI_ASF_SPEED_MASK            0x7

#define BMAPI_ASF_HALF_DUPLEX           0x20
#define BMAPI_ASF_PAUSE_NOT_CAPABLE     0x40
#define BMAPI_ASF_AUTO_DISABLE          0x80

// Definition for BmapiEnableDevice()
#define BMAPI_NIC_DISABLE               0
#define BMAPI_NIC_ENABLE                1
#define BMAPI_NIC_PROPCHANGE            2

#define BMAPI_FW_MAX_DESCRIPTION_LEN    16

// 'uType' definition for BmapiReadNicMem() and BmapiWriteNicMem().
#define BMAPI_INDIRECT_REG_READ         0
#define BMAPI_INDIRECT_MEM_READ         1
#define BMAPI_PHY_REG_READ              2
#define BMAPI_INDIRECT_REG_WRITE        0
#define BMAPI_INDIRECT_MEM_WRITE        1
#define BMAPI_PHY_REG_WRITE             2

// 'uType' definition for BmapiGetIpAddrInfo().
#define BMAPI_IPINFO_IP_LIST            0
#define BMAPI_IPINFO_SUBNETMASK_LIST    1
#define BMAPI_IPINFO_GATEWAY_LIST       2

#if 0
// 'uWhere' definition for BmapiGetPowerMode().
#define BMAPI_GET_POWER_MODE_DRIVER     0
#define BMAPI_GET_POWER_MODE_EEPROM     1

// 'uWhere' definition for BmapiSetPowerMode().
#define BMAPI_SET_POWER_MODE_DRIVER     0
#define BMAPI_SET_POWER_MODE_EEPROM     1
#define BMAPI_SET_POWER_MODE_BOTH       2       /* EEPROM and driver        */

// Mode definition for BmapiGetPowerMode and BmapiSetPowerMode().
#define BMAPI_POWER_MODE_FULL           0
#define BMAPI_POWER_MODE_LOW            1
#endif

// 'SupportedFlags' definition for BM_BRCM_ADAPTER_INFO_EX.

// 'uOption' definition for BmapiWriteFirmwareInfo().
#define BMAPI_WR_FW_MANUFAC             0x00000001

#define BMAPI_MAX_COMMUNITY_NAME_LEN    20

// 'uPhyStatus' definition for BmapiSetPHYStatus() and BmapiGetPHYStatus().
#define BMAPI_PHY_STATUS_ON             0
#define BMAPI_PHY_STATUS_OFF            1



/****************************************************************************/
/* Loopback type.                                                           */
/****************************************************************************/
#define BMAPI_LOOPBACK_TYPE_MAC         0
#define BMAPI_LOOPBACK_TYPE_PHY         1
#define BMAPI_LOOPBACK_TYPE_TWO_NODE    2
#define BMAPI_LOOPBACK_TYPE_EXTERNAL    3
/****************************************************************************
 *  OBSOLETE loopback definition
 ****************************************************************************/
#define LOOPBACK_TYPE_MAC               BMAPI_LOOPBACK_TYPE_MAC
#define LOOPBACK_TYPE_PHY               BMAPI_LOOPBACK_TYPE_PHY
#define LOOPBACK_TYPE_TWO_NODE          BMAPI_LOOPBACK_TYPE_TWO_NODE



#ifdef _WIN32

//
// extra_info for EVT_ACTIVE and EVT_INACTIVE
//
#define BMAPI_EVINFO_ACTIVITY_LINK      0   // active/inactive due to link status
#define BMAPI_EVINFO_ACTIVITY_MANUAL    1   // active/inactive due to enable/disable
#define BMAPI_EVINFO_ACTIVITY_ADDREMOVE 2   // active/inactive due to add/remove
#define BMAPI_EVINFO_ACTIVITY_STANDBY   3   // active/inactive due to standby
#define BMAPI_EVINFO_ACTIVITY_NONE      0xFFFFFFFF

typedef enum
{
    BMAPI_EVT_ACTIVE = 0,       // adapter is active
    BMAPI_EVT_INACTIVE = 1,     // adapter is inactive
    BMAPI_EVT_LINKUP = 2,       // adapter's link status goes up
    BMAPI_EVT_LINKDOWN = 3,     // adapter's link status goes down
    BMAPI_EVT_ENABLE = 4,       // adapter is enabled via management interface
    BMAPI_EVT_DISABLE = 5,      // adapter is disabled via management interface
    BMAPI_EVT_ADD = 6,          // adapter is added to a team
    BMAPI_EVT_REMOVE = 7,       // adapter is removed from a team
    BMAPI_EVT_ASFCFG_CHG = 100, // adapter's ASF configuration is modified
    BMAPI_EVT_DEV_ARRIVED = 101,    // a device is arrived or enabled
    BMAPI_EVT_DEV_REMOVED = 102,    // a device is to be removed

#if defined(__NETWARE__)
    BMAPI_EVT_DUMMY = 0xFFFFFFF    // make it a 32-bit variable
#else    
    BMAPI_EVT_DUMMY = 0xFFFFFFFF    // make it a 32-bit variable
#endif    
} BMAPI_EV_TYPE;


typedef void (*BMAPIEVENTCALLBACK)( U32 event, const S8 *team_name, U32 team_id, const S8 *adapter_service_name, U32 adapter_handle, U32 lb_number, U32 sb_number, U32 extra_info, void *cookie );

#ifndef BOOL
typedef int                 BOOL;
#endif

#else /* Unix */

typedef int   BOOL;
#define TRUE  1
#define FALSE 0

#if defined(__linux__) || defined(LINUX)

#include <endian.h>

#if __BYTE_ORDER == __BIG_ENDIAN
#define BCM_BIG_ENDIAN_HOST 1
#define BIG_ENDIAN_HOST 1
 #ifndef BIG_ENDIAN
  #define BIG_ENDIAN 1
 #endif
#else
 #define BCM_LITTLE_ENDIAN_HOST	1
 #define LITTLE_ENDIAN_HOST 1
 #ifndef LITTLE_ENDIAN
  #define LITTLE_ENDIAN 1
 #endif
#endif

#define ABS_SWAP(w) ((((w) & 0xff000000) >> 24) | (((w) & 0x00ff0000) >> 8) | (((w) & 0x0000ff00) << 8) | (((w) & 0x000000ff) << 24))

#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
 #define BMAPI_LENDIAN_SWAP_S(w) (w)
 #define BMAPI_LENDIAN_SWAP(w) (w)
 #define BMAPI_BENDIAN_SWAP_S(w)   ((((w) & 0xff00) >> 8) | (((w) & 0x00ff) << 8))
 #define BMAPI_BENDIAN_SWAP(w) ABS_SWAP(w)
#else

 #define BMAPI_LENDIAN_SWAP_S(w)   ((((w) & 0xff00) >> 8) | (((w) & 0x00ff) << 8))
 #define BMAPI_LENDIAN_SWAP(w) ABS_SWAP(w)
 #define BMAPI_BENDIAN_SWAP_S(w) (w)
 #define BMAPI_BENDIAN_SWAP(w) (w)
#endif

#endif /* LINUX */

#endif /* Unix */




/****************************************************************************
 *  Data Structures
 ****************************************************************************/
typedef struct _BM_ADAPTER_INFO
{
    // NIC card type. Valid only for physical adapters.
    // BMAPI_NON_BROADCOM_NIC == non Broadcom NIC,
    // BMAPI_ALTEON == T2, BMAPI_BRCM5700 == T3, ...
    U32 nic_type;

    // Application use this handle number to indicate which adapter
    // it is referring to. If handle == BMAPI_INVALID_NIC_HANDLE,
    // The adapter is not found in current configuration.
    U32 handle;

    // pTitle will be the unique "friendly name" displayed to users.
    S8  title[BMAPI_MAX_TITLE_LEN];

    // Product name of the adapter. It Is used to IdentIfy whether two
    // adapters belong the same class of driver.
    S8  product_name[BMAPI_MAX_PRODUCT_LEN];

    // Physical adapter type in a team whether is part of a load
    // balancing team or a fail over adapter.
    // BMAPI_MEMBER_ROLE_LOAD_BALANCE == use for load balancing or unassigned.
    // BMAPI_MEMBER_ROLE_STAND_BY == fail over adapter (standby).
    U32 member_type;

    // Description of the adapter. May not be available for all adapters.
    S8  description[BMAPI_MAX_DESC_LEN];

    // Boolean flag to denote if DHCP is enabled.
    // Not available in non Windows platforms.
    U32 dhcp_enabled;

    // IP address is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  ip_addr[BMAPI_MAX_IP_ADDR_LEN];

    // subnet mask is "255.255.0.0" format. (REG_MULTI_SZ or REG_SZ)
    S8  subnet_mask[BMAPI_MAX_IP_ADDR_LEN];

    // defaule gateway is "192.168.0.1" format. (REG_MULTI_SZ or REG_SZ)
    S8  default_gateway[BMAPI_MAX_IP_ADDR_LEN];

    // Boolean flag to indicate whether driver is running.
    U32 driver_loaded;

    // These information is valid only driver is running.
    S8  current_mac_addr[BMAPI_MAX_MAC_ADDR_LEN];

    // On Linux, perm mac address can be retrieved by 
    // BmapiGetBRCMNicInfoEx()or by bBmapiGetPhyNic().
    S8  permanent_mac_addr[BMAPI_MAX_MAC_ADDR_LEN];

#ifdef _WIN32
    U32 major_version_number;
    U32 minor_version_number;
#else /* unix */
    U8  driver_version[BMAPI_MAX_DRVVER_LEN];
#endif /* unix */

    // VLAN ID should be filled here. VLAN ID should greater or equal
    // to 1. Exist only for virtual adapters.
    U32 vlan_id;
    S8  vlan_name[BMAPI_MAX_VLAN_NAME_LEN];

    // State of this adapter, can be either up, down or disabled. This
    // is valid only when data is retrieved from BmapiGetTeamSnapShot().
    // Possible value:
    // BMAPI_MEMBER_STATE_UP, BMAPI_MEMBER_STATE_DOWN,
    // BMAPI_MEMBER_STATE_DISABLED
    U32 state;

    // Link speed of the physical NIC in Mbps, i.e. 10 = 10Mbps. This
    // is valid only when physical NIC card data is retrieved from
    // BmapiGetTeamSnapShot()
    U32 link_speed;

} BM_ADAPTER_INFO;



// 'flags' in BM_ADAPTER_INFO_EX
#define BMAPI_NIC_NO_MINOPORT_DRV       0x00000001
#define BMAPI_NIC_ASF_POSSIBLE          0x00000002

// 'link_status' in BM_ADAPTER_INFO_EX, BM_VIR_NIC_INFO_EX
// and BM_BRCM_ADAPTER_INFO
#define BMAPI_LM_STATUS_LINK_ACTIVE     4
#define BMAPI_LM_STATUS_LINK_DOWN       5

// 'media_type' in BM_ADAPTER_INFO_EX and BM_BRCM_ADAPTER_INFO
#define BMAPI_LM_MEDIA_TYPE_UNKNOWN     ( U32 )-1
#define BMAPI_LM_MEDIA_TYPE_AUTO        0
#define BMAPI_LM_MEDIA_TYPE_UTP         1
#define BMAPI_LM_MEDIA_TYPE_BNC         2
#define BMAPI_LM_MEDIA_TYPE_AUI         3
#define BMAPI_LM_MEDIA_TYPE_FIBER       4
#define BMAPI_LM_MEDIA_TYPE_SERDES      5
#define BMAPI_LM_MEDIA_TYPE_SERDES_SGMII    6
#define BMAPI_LM_MEDIA_TYPE_XGXS        7
#define BMAPI_LM_MEDIA_TYPE_XGXS_SGMII  8

// 'line_speed' in BM_ADAPTER_INFO_EX and BM_BRCM_ADAPTER_INFO
// 'link_speed' in BM_LINK_STATUS
#define BMAPI_LM_LINE_SPEED_UNKNOWN     0
#define BMAPI_LM_LINE_SPEED_10MBPS      1
#define BMAPI_LM_LINE_SPEED_100MBPS     2
#define BMAPI_LM_LINE_SPEED_1000MBPS    3
#define BMAPI_LM_LINE_SPEED_2500MBPS    4
#define BMAPI_LM_LINE_SPEED_10GBPS      5

// 'bus_type' in BM_ADAPTER_INFO_EX
#define BMAPI_BUS_TYPE_UNKNOWN          0
#define BMAPI_BUS_TYPE_UNSUPPORTED      1
#define BMAPI_BUS_TYPE_PCI              2
#define BMAPI_BUS_TYPE_PCMCIA           3
#define BMAPI_BUS_TYPE_1394             4
#define BMAPI_BUS_TYPE_USB              5

// 'arch_type' in BM_ADAPTER_INFO_EX
#define BMAPI_ARCH_5706_VBD             1
#define BMAPI_ARCH_5706_L2_ONLY         2       // For linux
#define BMAPI_ADAPTER_INFO_EX_VER       7

typedef struct _BM_ADAPTER_INFO_EX
{
    //  Version is defined as BMAPI_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    U32                 flags;
    BM_ADAPTER_INFO     adap_info;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U32                 vendor_id;
    U32                 device_id;
    U32                 subsystem_vendor_id;
    U32                 subsystem_id;
    U8                  manufacturer[BMAPI_MAX_MFG_LEN];

    // revision from PCI bus registers 0x08
    U32                 revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32                 bus_no;
    U32                 device_no;
    U32                 function_no;

    // PCI slot number labeled next to motherboard. This is an optional
    // field (at least, LOM will not have it). If it is not available,
    // this field will be set to -1.
    U32                 ui_number;

    // PCI information
    // Valid only when vendor_id equal to 0x14E4 and
    // nic_type is BMAPI_BRCM5700.
    U32                 mem_base_low;
    U32                 mem_base_high;

    // PCI information
    U32                 irq;

    // NIC information
    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is BMAPI_BRCM5700.
    U32                 phy_id;
    U32                 phy_addr;

    // For nic_type is BMAPI_BRCM5700.
    //  ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    // For nic_type is BMAPI_BRCM5706.
    //  ChipId:16, ChipRev:4, MetalRev:8
    U32                 chip_rev_id;

    U32                 media_type;

    // Possible value:
    // BMAPI_LM_LINE_SPEED_UNKNOWN, BMAPI_LM_LINE_SPEED_10MBPS,
    // BMAPI_LM_LINE_SPEED_100MBPS, BMAPI_LM_LINE_SPEED_1000MBPS
    U32                 line_speed;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN
    U32                 link_status;

#ifndef _WIN32
    // Possible value:
    // BMAPI_LM_DUPLEX_MODE_UNKNOWN, BMAPI_LM_DUPLEX_MODE_HALF
    // BMAPI_LM_DUPLEX_MODE_FULL
    U32                 duplex_mode;
#endif /* _WIN32 */

    // NIC information
    // Available only when vendor_id equal to 0x14E4.
    U32                 upper_misc_host_ctrl_reg;

    // Driver information
    U8                  driver_name[BMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[BMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

    // NIC information
    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is BMAPI_BRCM5700.
    U32                 internal_ram_size;

    // Could be BMAPI_BUS_TYPE_UNKNOWN, BMAPI_BUS_TYPE_UNSUPPORTED,
    // BMAPI_BUS_TYPE_PCI or BMAPI_BUS_TYPE_PCMCIA
    U32                 bus_type;

    // Available only when vendor_id equal to 0x14E4 and
    // nic_type is BMAPI_BRCM5706.
    // For L2 open source 5706 driver, the only valid value is 
    // BMAPI_ARCH_5706_L2_ONLY.
    U32                 arch_type;

#ifndef _WIN32
    // bits per second
    U64                 max_speed;

    // MTU: The maximum size of the INFO (non-MAC) field that will be "
    // received or transmitted. (MIB.IETF|BRIDGE-MIB.dot1dTpPortMaxInfo)
    U32                 mtu;

    // in_diag:
    // non-zero if the device is under diagnose
    // zero if the device is NOT under diagnose
    // Available only for Broadcom network controllers.
    U32                 in_diag;

#endif /* _WIN32 */

    U32                 bar_size;

    // For nic_type BMAPI_BRCM57710, there are two BAR addresses per port
    U32                 mem_base_low2;
    U32                 mem_base_high2;
    U32                 bar_size2;

} BM_ADAPTER_INFO_EX;



// This structure is for Broadcom BASP virtual adapter only.
#define BMAPI_VIR_NIC_INFO_EX_VER       1

typedef struct _BM_VIR_NIC_INFO_EX
{
    //  Version is defined as BMAPI_VIR_NIC_INFO_EX_VER.
    //  'version' is required upon input
    U32                 version;

    BM_ADAPTER_INFO     adap_info;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN

    U32                 link_status;

    // Driver information
    U8                  driver_name[BMAPI_MAX_DRV_NAME];
    U32                 driver_size;
    U8                  driver_interface_type[BMAPI_MAX_DRV_INT_TYPE];
    U32                 driver_interface_version_major;
    U32                 driver_interface_version_minor;

} BM_VIR_NIC_INFO_EX;


// 'mode' in BM_BRCM_ADAPTER_INFO
#define BMAPI_LM_BUS_MODE_UNKNOWN           0
#define BMAPI_LM_BUS_MODE_PCI               1
#define BMAPI_LM_BUS_MODE_PCI_X             2
#define BMAPI_LM_BUS_MODE_PCI_E             3
// 'clock' in BM_BRCM_ADAPTER_INFO
#define BMAPI_LM_BUS_CLOCK_UNKNOWN          0
#define BMAPI_LM_BUS_CLOCK_33MHZ            1
#define BMAPI_LM_BUS_CLOCK_66MHZ            2
#define BMAPI_LM_BUS_CLOCK_133MHZ           3
#define BMAPI_LM_BUS_CLOCK_100MHZ           4
#define BMAPI_LM_BUS_CLOCK_50MHZ            5

// 'bus_size' in BM_BRCM_ADAPTER_INFO
#define BMAPI_LM_BUS_SIZE_UNKNOWN           0
#define BMAPI_LM_BUS_SIZE_32BIT             1
#define BMAPI_LM_BUS_SIZE_64BIT             2
#define BMAPI_LM_BUS_SIZE_PCI_E_1X          3
#define BMAPI_LM_BUS_SIZE_PCI_E_2X          4
#define BMAPI_LM_BUS_SIZE_PCI_E_4X          5
#define BMAPI_LM_BUS_SIZE_PCI_E_8X          6
#define BMAPI_LM_BUS_SIZE_PCI_E_12X         7
#define BMAPI_LM_BUS_SIZE_PCI_E_16X         8
#define BMAPI_LM_BUS_SIZE_PCI_E_32X         9

// 'duplex_mode' in BM_BRCM_ADAPTER_INFO and BM_LINK_STATUS
#define BMAPI_LM_DUPLEX_MODE_UNKNOWN        0
#define BMAPI_LM_DUPLEX_MODE_HALF           1
#define BMAPI_LM_DUPLEX_MODE_FULL           2

// 'drv_state' in BM_BRCM_ADAPTER_INFO
#define BMAPI_DRV_STATE_NORMAL_MODE         0
#define BMAPI_DRV_STATE_MEDIA_FAIL          1   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_ADAPTER_CHECK       2   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_DIAG_MODE           5
#define BMAPI_DRV_STATE_NIC_REMOVED         6   // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_LOW_POWER_MODE      7
#define BMAPI_DRV_STATE_USER_SIMULATE_FAIL  16  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF_PENDING   32  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF           48  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_OFF_FAULT     64  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON_PENDING    80  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON            96  // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_POWER_ON_FAULT      112 // NT 4, HotPlug PCI
#define BMAPI_DRV_STATE_RESETTING           0xFFFFFFFF

typedef struct _BM_BRCM_ADAPTER_INFO
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    // PCI information.
    U32 bus_no;
    U32 device_no;
    U32 function_no;
    U32 vendor_id;
    U32 device_id;
    U32 subsystem_vendor_id;
    U32 subsystem_id;
    U32 mem_base_low;
    U32 mem_base_high;

    // Possible value:
    // BMAPI_LM_BUS_MODE_UNKNOWN, BMAPI_LM_BUS_MODE_PCI,
    // BMAPI_LM_BUS_MODE_PCI_X, BMAPI_LM_BUS_MODE_PCI_E
    U32 mode;

    // Possible value:
    // BMAPI_LM_BUS_CLOCK_UNKNOWN, BMAPI_LM_BUS_CLOCK_33MHZ,
    // BMAPI_LM_BUS_CLOCK_66MHZ, BMAPI_LM_BUS_CLOCK_133MHZ,
    // BMAPI_LM_BUS_CLOCK_100MHZ, BMAPI_LM_BUS_CLOCK_50MHZ
    U32 clock;

    // Possible value:
    // BMAPI_LM_BUS_SIZE_UNKNOWN, BMAPI_LM_BUS_SIZE_32BIT,
    // BMAPI_LM_BUS_SIZE_64BIT, BMAPI_LM_BUS_SIZE_PCI_E_1X
    // BMAPI_LM_BUS_SIZE_PCI_E_2X, BMAPI_LM_BUS_SIZE_PCI_E_4X
    // BMAPI_LM_BUS_SIZE_PCI_E_8X, BMAPI_LM_BUS_SIZE_PCI_E_12X
    // BMAPI_LM_BUS_SIZE_PCI_E_16X, BMAPI_LM_BUS_SIZE_PCI_E_32X
    U32 bus_size;

    // Chip information.

    // phy_id and phy_addr are not available for 5706 devices.
    /* OUI: bit 31-10;   Model#: bit 9-4;   Rev# bit 3-0. */
    U32 phy_id;

    U32 phy_addr;
    U32 irq;

    // For 570x devices: ChipId:4, ChipRev:4, MetalRev:8
    // For example :
    // 5700 A1 : 0x7000 : chip ID 0x7, chip rev 0x0, metal rev 0x01
    // 5700 B2 : 0x7000 : chip ID 0x7, chip rev 0x1, metal rev 0x02
    // 5701 A3 : 0x0003 : chip ID 0x0, chip rev 0x0, metal rev 0x03
    // 5703 A0 : 0x1000 : chip ID 0x1, chip rev 0x0, metal rev 0x00
    // 5704 A0 : 0x2003 : chip ID 0x2, chip rev 0x0, metal rev 0x00
    // For 5706 devices: ChipId:16, ChipRev:4, MetalRev:8
    // For example :
    // 5706 : 0x57060010 : chip ID 0x5706, chip rev 0x0, metal rev 0x01
    U32 chip_rev;

    U8  mac_address[8];         // Adapter's MAC address.

    // Driver information.
    // not available for 5706 devices.
    U32 mapped_mem_base;

    // Possible value:
    // BMAPI_LM_MEDIA_TYPE_UNKNOWN, BMAPI_LM_MEDIA_TYPE_AUTO,
    // BMAPI_LM_MEDIA_TYPE_UTP, BMAPI_LM_MEDIA_TYPE_BNC,
    // BMAPI_LM_MEDIA_TYPE_AUI, BMAPI_LM_MEDIA_TYPE_FIBER
    U32 media_type;

    // Possible value:
    // BMAPI_LM_LINE_SPEED_UNKNOWN, BMAPI_LM_LINE_SPEED_10MBPS,
    // BMAPI_LM_LINE_SPEED_100MBPS, BMAPI_LM_LINE_SPEED_1000MBPS
    U32 line_speed;

    // Possible value:
    // BMAPI_LM_DUPLEX_MODE_UNKNOWN, BMAPI_LM_DUPLEX_MODE_HALF
    // BMAPI_LM_DUPLEX_MODE_FULL
    U32 duplex_mode;

    // Possible value:
    // BMAPI_LM_STATUS_LINK_ACTIVE, BMAPI_LM_STATUS_LINK_DOWN
    U32 link_status;

    U8  node_address[8];        // Current network address.
    U32 drv_major_ver;
    U32 drv_minor_ver;

    // Possible value:
    // BMAPI_DRV_STATE_NORMAL_MODE, BMAPI_DRV_STATE_DIAG_MODE,
    // BMAPI_DRV_STATE_NIC_REMOVED, BMAPI_DRV_STATE_LOW_POWER_MODE
    U32 drv_state;

} BM_BRCM_ADAPTER_INFO;


// 'RequestedMediaType' in BM_BRCM_ADAPTER_INFO_EX
// 'requested_media_type' in BM_LINK_STATUS
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO                      0
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS                3
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX    4
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS               5
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX   6

// Do NOT force speed on 1000Mbps for copper.
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS              7
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX  8

#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_1000MBPS                11
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_1000MBPS_FULL_DUPLEX    12
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_2500MBPS                13
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_2500MBPS_FULL_DUPLEX    14
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_1G_FALLBACK     15
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_1G_FALLBACK_FULL_DUPLEX     16
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_2_5G_FALLBACK               17
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_AUTONEG_2_5G_FALLBACK_FULL_DUPLEX   18
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_HARDWARE_DEFAULT                    19
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_10GBPS                  20
#define BMAPI_LM_REQUESTED_MEDIA_TYPE_FIBER_10GBPS_FULL_DUPLEX      21

// 'flow_ctrl' in BM_BRCM_ADAPTER_INFO_EX
// For both NetXtreme and NetXtreme II products,
// following definitions are valid.
#define BMAPI_FLOW_CONTROL_NONE             0x00
#define BMAPI_FLOW_CONTROL_RX_PAUSE         0x01
#define BMAPI_FLOW_CONTROL_TX_PAUSE         0x02

// For NetXtreme II products ***ONLY***
/*
 * This value can be or-ed with RECEIVE_PAUSE and TRANSMIT_PAUSE.  If the 
 * auto-negotiation is disabled and the RECEIVE_PAUSE and TRANSMIT_PAUSE 
 * bits are set, then flow control is enabled regardless of link partner's 
 * flow control capability.  Otherwise, if this bit is set, then flow 
 * is negotiated with the link partner.  Values 0x80000000 and 0x80000003 are
 * equivalent.
 */
#define BMAPI_FLOW_CONTROL_AUTO_PAUSE       0x80000000

#define BMAPI_BRCM_ADAPTER_INFO_EX_VER      6   

typedef struct _BM_BRCM_ADAPTER_INFO_EX
{
    // This structure will host all Broadcom proprietary static data.
    // Ststistic data will be host in separate data structure.

    //  Latest version is defined as BMAPI_BRCM_ADAPTER_INFO_EX_VER.
    //  'version' is required upon input
    U32                     version;

    BM_BRCM_ADAPTER_INFO    brcm_info;

    // Defined flags:
    U32                     SupportedFlags;

    U32                     RequestedMediaType;
    U32                     DisableAutoNeg;

    // This data apply to 5704 NIC only.
    U32                     DualMACCtrlReg;

    // Max. speed for the NIC.
    // Value is the same as 'line_speed'.
    U32                     MaxSpeed;

    // The unit value is Kbps. The actual speed value will be truncated
    // to the lower bound of Kbps. For example, if the speed is 14.4 Kbps,
    // the value will be 14. If the speed is less than 1 Kbps, the value
    // will be 0.
    U32                     line_speed_Kbps;

#ifndef _WIN32
    // Linux driver use 3 digits version format.
    // Major version and minor version are defined in BM_BRCM_ADAPTER_INFO.
    U32                     drv_build_ver;

    // VLAN config
    // 0: VLAN is off
    // 1: VLAN is on
    U32                     vlan_cfg;

    // Wake On Lan config
    // 0: WOL is off
    // 1: WOL is on
    U32                     wol_cfg;

#endif
    U32                     bond_id;

    // For Linux:
    // The field is valid only for drivers capable of ethtool interface.
    // For Window:
    // The field is valid only when 'nic_type' is BMAPI_BRCM5706 and
    // windows vbd driver is v2.8.2 or later.
    U32                     nvram_size;

} BM_BRCM_ADAPTER_INFO_EX;



#define BMAPI_AF_INET       2
#define BMAPI_AF_INET6      23

typedef struct _BM_IPADDR
{
    // Currently only BMAPI_AF_INET is supported.
    U16     sin_family;

    union
    {
        // Unused bytes MUST be set to zero.
        U32     addr_ipv4;      // can be cast to in_addr

        U8      addr_ipv6[16];

        // Application can use this field as protocal independent
        // variable to achieve better compatibility between IPv4 and
        // IPv6.
        U8      addr[16];
    };

} BM_IPADDR;




typedef struct _BM_PHY_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request completed by miniport
    U32 send_packet;

    // number of send request discarded
    U32 send_discarded;

    // number of send request dispatched to miniport
    U32 send_dispatched;

    // number of receive packets that are indicated to upper layer
    U32 recv_packet;

    // number of receive packets discarded
    U32 recv_discarded;

    // number of receive discarded because it's too big
    U32 recv_oversize;

} BM_PHY_NIC_STATISTICS;



typedef struct _BM_VIR_NIC_STATISTICS
{
    // Application use this handle number to know which adapter
    // this statistic structure is referring to.
    U32 handle;

    // number of send request discarded for various reasons
    U32 send_all_down;

    // number of send request being queued because out of NDIS_PACKET
    U32 send_queued;

    // number of send request completed
    U32 send_completed;

    // number of receive indicated to upper layer successfully 
    U32 recv_indicated;

} BM_VIR_NIC_STATISTICS;



typedef struct _BM_TEAM_STATISTICS
{
    // Team name.
    S8                      team_name[BMAPI_MAX_TEAM_NAME_LEN];

    // number of send packets that are forwarded to the team members,
    // derived from physical adapter statistics
    U32                     send_packet;

    // number of send packets that are discarded,
    // derived from physical adapter statistics
    U32                     send_discarded;

    // number of send packets that are discarded because all the team 
    // members are malfunctioned, derived from virtual adapter statistics.
    U32                     send_all_down;

    // number of send packets queued by BLF driver waiting for resource
    // derived from virtual adapter statistics.
    U32                     send_queued;

    // number of send packets originated from BLF driver
    U32                     send_adjusted;

    // number of receive packets that are indicated to upper layer,
    // derived from physical adapter statistics
    U32                     recv_packet;

    // number of receive packets discarded, 
    // derived from physical adapter statistics
    U32                     recv_discarded;

    // number of receive discarded because it's too big,
    // derived from physical adapter statistics
    U32                     recv_oversize;

    // number of receive indicated to upper layer successfully 
    // derived from virtual adapter statistics
    U32                     recv_indicated;

    // physical adapter statistics
    // number of valid physical adapters
    U32                     phy_count;

    // statistics of each team member
    BM_PHY_NIC_STATISTICS   phy_member[BMAPI_MAXIMUM_MEMBERS_PHY_TEAM];

    // virtual adapter statistics
    // number of valid virtual adapters
    U32                     vir_count;

    // statistics of each virtual adapter
    BM_VIR_NIC_STATISTICS   vir_member[BMAPI_MAXIMUM_MEMBERS_VIR_TEAM];
} BM_TEAM_STATISTICS;




typedef struct _BM_GENERAL_STATISTICS
{
    U32 xmit_ok;                // OID_GEN_XMIT_OK
    U32 rcv_ok;                 // OID_GEN_RCV_OK
    U32 xmit_error;             // OID_GEN_XMIT_ERROR
    U32 rcv_error;              // OID_GEN_RCV_ERROR
    U32 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U32 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U32 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U32 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U32 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U32 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U32 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U32 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U32 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} BM_GENERAL_STATISTICS;



typedef struct _BM_GENERAL_STATISTICS64
{
    U64 xmit_ok;                // OID_GEN_XMIT_OK
    U64 rcv_ok;                 // OID_GEN_RCV_OK
    U64 xmit_error;             // OID_GEN_XMIT_ERROR
    U64 rcv_error;              // OID_GEN_RCV_ERROR
    U64 rcv_no_buffer;          // OID_GEN_RCV_NO_BUFFER
    U64 directed_bytes_xmit;    // OID_GEN_DIRECTED_BYTES_XMIT
    U64 directed_frames_xmit;   // OID_GEN_DIRECTED_FRAMES_XMIT
    U64 multicast_bytes_xmit;   // OID_GEN_MULTICAST_BYTES_XMIT
    U64 multicast_frames_xmit;  // OID_GEN_MULTICAST_FRAMES_XMIT
    U64 broadcast_bytes_xmit;   // OID_GEN_BROADCAST_BYTES_XMIT
    U64 broadcast_frames_xmit;  // OID_GEN_BROADCAST_FRAMES_XMIT
    U64 directed_bytes_rcv;     // OID_GEN_DIRECTED_BYTES_RCV
    U64 directed_frames_rcv;    // OID_GEN_DIRECTED_FRAMES_RCV
    U64 multicast_bytes_rcv;    // OID_GEN_MULTICAST_BYTES_RCV
    U64 multicast_frames_rcv;   // OID_GEN_MULTICAST_FRAMES_RCV
    U64 broadcast_bytes_rcv;    // OID_GEN_BROADCAST_BYTES_RCV
    U64 broadcast_frames_rcv;   // OID_GEN_BROADCAST_FRAMES_RCV
    U64 rcv_crc_error;          // OID_GEN_RCV_CRC_ERROR
    U64 transimit_queue_length; // OID_GEN_TRANSMIT_QUEUE_LENGTH
} BM_GENERAL_STATISTICS64;



typedef struct _BM_ETHERNET_STATISTICS
{
    U32 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U32 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U32 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U32 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U32 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U32 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U32 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U32 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U32 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U32 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} BM_ETHERNET_STATISTICS;



typedef struct _BM_ETHERNET_STATISTICS64
{
    U64 rcv_error_alignment;    //OID_802_3_RCV_ERROR_ALIGNMENT
    U64 xmit_one_collision;     //OID_802_3_XMIT_ONE_COLLISION
    U64 xmit_more_collisions;   //OID_802_3_XMIT_MORE_COLLISIONS
    U64 xmit_deferred;          //OID_802_3_XMIT_DEFERRED
    U64 xmit_max_collisions;    //OID_802_3_XMIT_MAX_COLLISIONS
    U64 rcv_overrun;            //OID_802_3_RCV_OVERRUN
    U64 xmit_underrun;          //OID_802_3_XMIT_UNDERRUN
    U64 xmit_heartbeat_failure; //OID_802_3_XMIT_HEARTBEAT_FAILURE
    U64 xmit_times_crs_lost;    //OID_802_3_XMIT_TIMES_CRS_LOST
    U64 xmit_late_collisions;   //OID_802_3_XMIT_LATE_COLLISIONS
} BM_ETHERNET_STATISTICS64;



#ifdef _WIN32

typedef struct _BM_BRCM_STATISTICS
{
    // Statistics maintained by Receive MAC.
    U64 ifHCInOctets;
    U64 etherStatsFragments;
    U64 ifHCInUcastPkts;
    U64 ifHCInMulticastPkts;
    U64 ifHCInBroadcastPkts;
    U64 dot3StatsFCSErrors;
    U64 dot3StatsAlignmentErrors;
    U64 xonPauseFramesReceived;
    U64 xoffPauseFramesReceived;
    U64 macControlFramesReceived;
    U64 xoffStateEntered;
    U64 dot3StatsFramesTooLong;
    U64 etherStatsJabbers;
    U64 etherStatsUndersizePkts;
    /////////////////////////
    // Not available for 5706
    U64 inRangeLengthError;
    U64 outRangeLengthError;
    /////////////////////////
    U64 etherStatsPkts64Octets;
    U64 etherStatsPkts65Octetsto127Octets;
    U64 etherStatsPkts128Octetsto255Octets;
    U64 etherStatsPkts256Octetsto511Octets;
    U64 etherStatsPkts512Octetsto1023Octets;
    U64 etherStatsPkts1024Octetsto1522Octets;
    /////////////////////////
    // Not available for 5706
    U64 etherStatsPkts1523Octetsto2047Octets;
    U64 etherStatsPkts2048Octetsto4095Octets;
    U64 etherStatsPkts4096Octetsto8191Octets;
    U64 etherStatsPkts8192Octetsto9022Octets;
    /////////////////////////

    // Statistics maintained by Transmit MAC.
    U64 ifHCOutOctets;
    U64 etherStatsCollisions;
    U64 outXonSent;
    U64 outXoffSent;
    U64 flowControlDone;
    U64 dot3StatsInternalMacTransmitErrors;
    U64 dot3StatsSingleCollisionFrames;
    U64 dot3StatsMultipleCollisionFrames;
    U64 dot3StatsDeferredTransmissions;
    U64 dot3StatsExcessiveCollisions;
    U64 dot3StatsLateCollisions;
    /////////////////////////
    // Not available for 5706
    U64 dot3Collided2Times;
    U64 dot3Collided3Times;
    U64 dot3Collided4Times;
    U64 dot3Collided5Times;
    U64 dot3Collided6Times;
    U64 dot3Collided7Times;
    U64 dot3Collided8Times;
    U64 dot3Collided9Times;
    U64 dot3Collided10Times;
    U64 dot3Collided11Times;
    U64 dot3Collided12Times;
    U64 dot3Collided13Times;
    U64 dot3Collided14Times;
    U64 dot3Collided15Times;
    /////////////////////////
    U64 ifHCOutUcastPkts;
    U64 ifHCOutMulticastPkts;
    U64 ifHCOutBroadcastPkts;
    U64 dot3StatsCarrierSenseErrors;

    /////////////////////////
    // Not available for 5706
    U64 ifOutDiscards;
    /////////////////////////

    U64 ifOutErrors;

    // Statistics maintained by Receive List Placement.
    /////////////////////////
    // Not available for 5706
    U64 COSIfHCInPkts[16];
    U64 COSFramesDroppedDueToFilters;
    U64 nicDmaWriteQueueFull;
    U64 nicDmaWriteHighPriQueueFull;
    /////////////////////////
    U64 nicNoMoreRxBDs;

    /////////////////////////
    // Not available for 5706
    U64 ifInDiscards;
    /////////////////////////

    U64 ifInErrors;
    /////////////////////////
    // Not available for 5706
    U64 nicRecvThresholdHit;
    /////////////////////////

    // Statistics maintained by Send Data Initiator.
    /////////////////////////
    // Not available for 5706
    U64 COSIfHCOutPkts[16];
    U64 nicDmaReadQueueFull;
    U64 nicDmaReadHighPriQueueFull;
    U64 nicSendDataCompQueueFull;
    /////////////////////////

    // Statistics maintained by Host Coalescing.
    /////////////////////////
    // Not available for 5706
    U64 nicRingSetSendProdIndex;
    U64 nicRingStatusUpdate;
    U64 nicInterrupts;
    U64 nicAvoidedInterrupts;
    U64 nicSendThresholdHit;
    /////////////////////////

} BM_BRCM_STATISTICS;

#else /* Unix */

#define BM_BRCM_STATISTICS_VER    1

typedef struct _BM_BRCM_STATISTICS
{
    //  Version is defined as BM_BRCM_STATISTICS_VER.
    //  'version' is required on input
    U64 version;

    U64 ifOutOctets;                            // MIB.IETF|RFC1213-MIB.ifOutOctets
    U64 ifInOctets;                             // MIB.IETF|RFC1213-MIB.ifInOctets
    U64 TotalPacketsTransmitted;                // MIF.DMTF|Network Adapter 802 Port|001.6
    U64 TotalPacketsReceived;                   // MIF.DMTF|Network Adapter 802 Port|001.8
    U64 dot3StatsAlignmentErrors;               // MIB.IETF|EtherLike-MIB.dot3StatsAlignmentErrors
    U64 dot3StatsFCSErrors;                     // MIB.IETF|EtherLike-MIB.dot3StatsFCSErrors
    U64 dot3StatsSingleCollisionFrames;         // MIB.IETF|EtherLike-MIB.dot3StatsSingleCollisionFrames
    U64 dot3StatsMultipleCollisionFrames;       // MIB.IETF|EtherLike-MIB.dot3StatsMultipleCollisionFrames
    U64 dot3StatsDeferredTransmissions;         // MIB.IETF|EtherLike-MIB.dot3StatsDeferredTransmissions
    U64 dot3StatsLateCollisions;                // MIB.IETF|EtherLike-MIB.dot3StatsLateCollisions
    U64 dot3StatsExcessiveCollisions;           // MIB.IETF|EtherLike-MIB.dot3StatsExcessiveCollisions
    U64 dot3StatsInternalMacTransmitErrors;     // MIB.IETF|EtherLike-MIB.dot3StatsInternalMacTransmitErrors
    U64 dot3StatsInternalMacReceiveErrors;      // MIB.IETF|EtherLike-MIB.dot3StatsInternalMacReceiveErrors
    U64 dot3StatsCarrierSenseErrors;            // MIB.IETF|EtherLike-MIB.dot3StatsCarrierSenseErrors
    U64 dot3StatsFrameTooLongs;                 // MIB.IETF|EtherLike-MIB.dot3StatsFrameTooLongs

} BM_BRCM_STATISTICS;

#endif /* Unix */


typedef struct _BM_LINK_STATUS
{
    U32 link_status;            // 1 = Link Pass, 0 = Link Fail
    U32 local_Rx_status;        // 1 = Local Receive OK
                                // 0 = Local Receive Error
    U32 remote_Rx_status;       // 1 = Remote Receive OK
                                // 0 = Remote Receive Error
    U32 auto_negotiation_mode;  // 1 = AutoNegotiation is enabled
                                // 0 = Forced speed
    U32 requested_media_type;   // BMAPI_LM_REQUESTED_MEDIA_TYPE_AUTO
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_10MBPS_FULL_DUPLEX
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_100MBPS_FULL_DUPLEX
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS
                                // BMAPI_LM_REQUESTED_MEDIA_TYPE_UTP_1000MBPS_FULL_DUPLEX
    U32 duplex_mode;            // 0 = half duplex
                                // 1 = full duplex
    U32 link_speed;             // BMAPI_LM_LINE_SPEED_UNKNOWN
                                // BMAPI_LM_LINE_SPEED_10MBPS
                                // BMAPI_LM_LINE_SPEED_100MBPS
                                // BMAPI_LM_LINE_SPEED_1000MBPS

} BM_LINK_STATUS;



/****************************************************************************
 *  OBSOLETE starts here
 ****************************************************************************/
typedef struct _BM_BRCM_NIC_PARAM_REQ
{
    U32     num_of_params;
    U8      param_id_List[1];
} BM_BRCM_NIC_PARAM_REQ;



typedef struct _BM_BRCM_NIC_PARAM_DATA
{
    U32     param_id;
    U32     param_type;
    U32     param_data_len;
    U32     result;
    U32     offset_next_param;
    U8      param_data[1];
} BM_BRCM_NIC_PARAM_DATA;
/****************************************************************************
 *  OBSOLETE ends here
 ****************************************************************************/



#define BMAPI_NIC_PCI_INFO_VER          2

typedef struct _BM_NIC_PCI_INFO
{
    //  Version is defined as BMAPI_NIC_PCI_INFO_VER.
    //  'version' is required upon input
    U16     version;

    // If PCI IDs information is not available, the value will be -1 and
    // 'manufacturer' will be "".
    U16     vendor_id;
    U16     device_id;
    U16     subsystem_vendor_id;
    U16     subsystem_id;
    U8      manufacturer[BMAPI_MAX_MFG_LEN];

    // hardware revision
    U32     revision;

    // PCI bus information. If these information are not available,
    // data will be set to -1.
    U32     bus_no;
    U32     device_no;
    U32     function_no;

    // PCI slot number labeled next to motherboard (W2k only).
    // This is an optional field (at least, LOM will not have it).
    // If it is not available, this field will be set to -1.
    U32     ui_number;

    // PCI information
    // Valid for Broadcom NIC only.
    U32     mem_base_low;
    U32     mem_base_high;

    // PCI information
    U32     irq;

} BM_NIC_PCI_INFO;


//  ASF tables (base on ASF 1.0)
// ASF definition
#define BMAPI_MAX_ALERTDATA                             8
#define BMAPI_ASF_SPEC_1_0_ALERTDATA_ELEMENT_LENGTH     12
#define BMAPI_MAX_CONTROLDATA                           8
#define BMAPI_MAX_SPEC_1_0_CONTROLDATA_ELEMENT_LENGTH   4

// since structure ASF_ADDR has extra 2 bytes other than FixedSMBusAddresses,
// to align the structure to LONG, BMAPI_MAX_FIXEDSMBUSADDR should use
// (multiple of 4) - 2. In this case, we are using 14.
#define BMAPI_MAX_FIXEDSMBUSADDR                        14

// speed defines for BM_ASF_MISC
#define BMAPI_ASF_SPEED_10_100                          0
#define BMAPI_ASF_SPEED_10                              1
#define BMAPI_ASF_SPEED_100                             2
#define BMAPI_ASF_SPEED_1000                            3
#define BMAPI_ASF_SPEED_ALL                             4
#define BMAPI_ASF_SPEED_MASK                            0x7

#define BMAPI_ASF_HALF_DUPLEX                           0x20
#define BMAPI_ASF_PAUSE_NOT_CAPABLE                     0x40
#define BMAPI_ASF_AUTO_DISABLE                          0x80


typedef struct _BM_ASF_INFO
{
    U8      MinWatchdogResetValue;
    U8      MinPollingInterval;
    U16     SystemID;

    U8      IANAManufacturerID[4];

    U8      FeatureFlags;       /* added in ASF 2.0 */
    U8      Reserved[3];
} BM_ASF_INFO;

typedef struct _BM_ASF_ALERTDATA
{
    U8      DeviceAddress;
    U8      Command;
    U8      DataMask;
    U8      CompareValue;

    U8      EventSensorType;
    U8      EventType;
    U8      EventOffset;
    U8      EventSourceType;

    U8      EventSeverity;
    U8      SensorNumber;
    U8      Entity;
    U8      EntityInstance;
} BM_ASF_ALERTDATA;

typedef struct _BM_ASF_ALRT
{
    U8                      AssertionEventMask;     /* added in ASF 2.0 */
    U8                      DeassertionEventMask;   /* added in ASF 2.0 */
    U8                      NumberOfAlerts;
    U8                      ArrayElementLength;

    BM_ASF_ALERTDATA        AsfAlertData[BMAPI_MAX_ALERTDATA];
} BM_ASF_ALRT;

typedef struct _BM_ASF_CONTROLDATA
{
    U8      Function;
    U8      DeviceAddress;
    U8      Command;
    U8      DataValue;
} BM_ASF_CONTROLDATA;

typedef struct _BM_ASF_RCTL
{
    U8                      NumberOfControl;
    U8                      ArrayElementLength;
    /* to align to dword */
    U8                      Reserved[2];
    BM_ASF_CONTROLDATA      AsfControlData[BMAPI_MAX_CONTROLDATA];
} BM_ASF_RCTL;

typedef struct _BM_ASF_RMCP
{
    U8      RemoteControlCapabilities[7];
    U8      RMCPCompletionCode;

    U8      RMCPIANA[4];

    U8      RMCPSpecialCommand;
    U8      RMCPSpecialCommandParameter[2];
    U8      RMCPBootOptions[2];
    U8      RMCPOEMParameters[2];

    /* to align to dword */
    U8      filler;
} BM_ASF_RMCP;

typedef struct _BM_ASF_ADDR
{
    U8      SEEPROMAddress;
    U8      NumberOfDevices;
    U8      FixedSMBusAddresses[BMAPI_MAX_FIXEDSMBUSADDR];
} BM_ASF_ADDR;

struct BM_ASF_CFG
{
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)

    // Bit 31-0

    U32     EnableSecureOnly    : 1;
    U32     EnableSecureRMCP    : 1; /* ASF 2.0 - Secure RMCP */
    U32     EnableSMBusScan     : 1; /* Enable/Disable our NIC as a passive Slave Mode.  No ARP or Scan on the SMBus */
    U32     EnableASFWoL        : 1; /* Enable/Disable WoL on ARP or RMCP packet, while in OS absent */
    U32     EnablePET           : 1;
    U32     EnableRMCP          : 1;
    U32     EnableHeartBeat     : 1;
    U32     EnableASF           : 1;

    // Send OEM specific "ASD Ready" message after initialization
    U32     EnableSendAsdReady  : 1;
    U32     reserved            : 23;

#else
    U32     EnableASF           : 1;    // mirror of BM_FW_FEATURE_CONFIG.asf_enable
    U32     EnableHeartBeat     : 1;
    U32     EnableRMCP          : 1;
    U32     EnablePET           : 1;
    // Enable/Disable WoL on ARP or RMCP packet, while in OS absent
    U32     EnableASFWoL        : 1;
    // Enable/Disable our NIC as a passive Slave Mode.
    // No ARP or Scan on the SMBus.
    U32     EnableSMBusScan     : 1;
    U32     EnableSecureRMCP    : 1; /* ASF 2.0 - Secure RMCP */
    U32     EnableSecureOnly    : 1; /* No ASF 1.0 Compatibility */
    U32     reserved2           : 7;

    // Send OEM specific "ASD Ready" message after initialization
    U32     EnableSendAsdReady  : 1;

    U32     reserved            : 16;
#endif
};

typedef struct _BM_ASF_MISC
{
    union {
        struct BM_ASF_CFG   Config;
        U32                 ConfigData;
    } cfg;

    U8      UuidGuid[16];

    U16     HeartBeatTimeValue;     /* in second */
    U8      reserved1[2];

    U8      DelayedPollTimeValue;   /* in second */
    U8      Speed;                  /* see speed defines above */
    U8      ReTransmitTimeValue;    /* in second */
    U8      LegacyPollTimeValue;    /* in second */

    U8      SysIP[4];
    U8      ManagementConsolIP[4];
    U8      GateWayIP[4];
    U8      subnetMask[4];
    U8      communityName[BMAPI_MAX_COMMUNITY_NAME_LEN];
    U8      reserved2[12];
} BM_ASF_MISC;

#define BMAPI_MAX_INIT_DATA 50

typedef struct _BM_SMB_INIT_DATA
{
    U8      addr;
    U8      index;
    U8      andMask;
    U8      orMask;
} BM_SMB_INIT_DATA;

#define BMAPI_MAX_KEY_SIZE    20        /* 160 bits */

typedef struct
{
    U32     kgsize;
    U8      kg[BMAPI_MAX_KEY_SIZE];
    U32     kosize;
    U8      ko[BMAPI_MAX_KEY_SIZE];
    U32     kasize;
    U8      ka[BMAPI_MAX_KEY_SIZE];

    /* Security Policy */
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)

#define BMAPI_ASF_CAN_POWER_UP          (1<<0)
#define BMAPI_ASF_CAN_RESET             (1<<1)
#define BMAPI_ASF_CAN_RESET_POWER       (1<<2)
#define BMAPI_ASF_CAN_POWER_DOWN        (1<<3)
#define BMAPI_ASF_RIGHTS_MASK           0x0000000f

#else

#define BMAPI_ASF_CAN_POWER_UP          (1<<24)
#define BMAPI_ASF_CAN_RESET             (1<<25)
#define BMAPI_ASF_CAN_RESET_POWER       (1<<26)
#define BMAPI_ASF_CAN_POWER_DOWN        (1<<27)
#define BMAPI_ASF_RIGHTS_MASK           0x0f000000

#endif

    U32     op_rights;      /* operator rights bitfield */
    U32     admin_rights;   /* administrator rights bitfield */
    U32     session_timeout;    /* in seconds */
} BM_ASF20_T;

//  We will use BMAPI_ASF_T_VERSION to identify the current version of
//  BM_ASF_TABLE.
//  Whenever the table is changed for release, BMAPI_ASF_T_VERSION should
//  increase.
#define BMAPI_ASF_T_VERSION         8

typedef struct _BM_ASF_TABLE
{
    U8                  version;    /* version of the table */
/****************************************************************************
 *  Following fields valid only for ASF and IMPI
 *  For IPMI, only 'EnableASF' in BM_ASF_CFG can be set/clear.
 ****************************************************************************/
    U8                  smbusAddr;  /* forced NIC smbus address, 0 means */
                                    /* use ARP, other value to force */
                                    /* smbus address */
    U16                 size;
    BM_ASF_INFO         AsfInfo;
    BM_ASF_ALRT         AsfAlert;
    BM_ASF_RCTL         AsfRCtl;
    BM_ASF_RMCP         AsfRmcp;
    BM_ASF_ADDR         AsfAddr;
    BM_ASF_MISC         AsfGui;
    BM_SMB_INIT_DATA    smbInitData[BMAPI_MAX_INIT_DATA];
    BM_ASF20_T          Asf20;      /* Added in version 6 for ASF 2.0, */
                                    /* ASF 1.0 firware will ignore this field. */

    U8                  reserve[1024];

    U32                 chksum;
/****************************************************************************
 *  ASF and IMPI only fields end here.
 ****************************************************************************/

    // Management firmware version description string.
    // ASF firmware version description string.
    U8                  firmware_ver_desc[BMAPI_FW_MAX_DESCRIPTION_LEN];

    U32                 fw_asfcfg_ver;    /* firmware asfcfg version */
    U32                 fw_asfcfg_size;   /* firmware asfcfg size */

#define BM_ASF_2_0_SUPPORT      0x00000001  // ASF Management Firmware with ASF 2.0 support
#define BM_IPMI_SUPPORT         0x00000002  // IPMI Management Firmware
#define BM_UMP_SUPPORT          0x00000004  // UMP Management Firmware
    U32                 flags;

} BM_ASF_TABLE;



/****************************************************************************/
/* Firmware information and definition                                      */
/*                                                                          */
/* ATTENTION:  Firmware is using Big-ENDIAN and Intel PC is using           */
/*             Little-ENDIAN.                                               */
/****************************************************************************/
#define BMAPI_FW_MAGIC_VALUE            0x669955aa
#define BMAPI_FW_MEDIA_MAX_LOAD_STAGES  8

typedef struct _BM_FW_MEDIA_BOOTSTRAP_REGION
{
    // a pattern not likely to occur randomly
    U32     magic_value;

    // where to locate boot code (byte addr)
    U32     sram_start_addr;

    // boot code length (in words)
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

    // 32-bit CRC
    U32     cksum;

} BM_FW_MEDIA_BOOTSTRAP_REGION;


typedef enum {
    BMAPI_FW_CODE_IMAGE_TYPE_PXE,           /* 0 */
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_INIT,      /* 1 */
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUA,      /* 2 */
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CPUB,      /* 3 */
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_CFG,       /* 4 */
    BMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG,     /* 5 */
    BMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG_PRG, /* 6 */
    BMAPI_FW_CODE_IMAGE_TYPE_USER_BLOCK,    /* 7 */
    BMAPI_FW_CODE_IMAGE_TYPE_BRSF_BLOCK,    /* 8 */
    BMAPI_FW_CODE_IMAGE_TYPE_ISCSI_BOOT,    /* 9 */
    BMAPI_FW_CODE_IMAGE_TYPE_ASF_MBOX,      /* 10 */
    BMAPI_FW_CODE_IMAGE_TYPE_ISCSI_CFG_1,   /* 11 */
    BMAPI_FW_MAX_CODE_IMAGE_TYPE,
} BM_FW_CODE_IMAGE;


typedef struct _BM_FW_MEDIA_CODE_OFFSET_REGION
{
    // where to locate code region (byte addr)
    U32     sram_start_addr;

/* 3 bits reserved for future use */
#define BMAPI_FW_CODE_LEN_RESERVED          0xe0000000

/* Use 5 bits -- supports up to 32 types */
#define BMAPI_FW_CODE_IMAGE_TYPE(x)         ((x >> 24) & 0x1f)
#define BMAPI_FW_CODE_IMAGE_EXECUTE_A       0x00800000
#define BMAPI_FW_CODE_IMAGE_EXECUTE_B       0x00400000
#define BMAPI_FW_CODE_IMAGE_EXECUTABLE_A(x) (x & BMAPI_FW_CODE_IMAGE_EXECUTE_A)
#define BMAPI_FW_CODE_IMAGE_EXECUTABLE_B(x) (x & BMAPI_FW_CODE_IMAGE_EXECUTE_B)
#define BMAPI_FW_CODE_IMAGE_LENGTH(x)       (x & 0x3fffff)

    // code region length (in words)
    // The top 8 bits are used for TYPE field.
    // We use 22 bit for length so that we accumulate up to 16 Mbyte.
    U32     code_len;

    // location of code on media (media byte addr)
    U32     code_start_addr;

} BM_FW_MEDIA_CODE_OFFSET_REGION;


#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_AUTO      0   // Auto
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_H      1   // 10Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_10_F      2   // 10Mbps Full Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_H     3   // 100Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_100_F     4   // 100Mbps Full Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_H    5   // 1000Mbps Half Duplex
#define BMAPI_FW_FEATURE_CONFIG_PXE_SPEED_1000_F    6   // 1000Mbps Full Duplex

#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE       0
#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL       1
#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP     2
#define BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_ISCSI     3

#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_AUTO     0
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_BBS      1
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT18    2
#define BMAPI_FW_FEATURE_CONFIG_BOOT_STRAP_INT19    3

#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_64K    0
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_128K   1
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_256K   2
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_512K   3
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_1M     4
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_2M     5
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_4M     6
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_8M     7
#define BMAPI_FW_FEATURE_CONFIG_PXE_BAR_SIZE_16M    8

#define BMAPI_FW_WOL_MASK                   0x00000001
#define BMAPI_FW_PXE_MASK                   0x00000002
#define BMAPI_FW_MBA_MASK                   0x00000002
#define BMAPI_FW_PXE_SPEED_MASK             0x0000003c
#define BMAPI_FW_MBA_SPEED_MASK             0x0000003c
#define BMAPI_FW_MBA_TYPE_MASK              0x00300000
#define BMAPI_FW_MBA_PROT_PXE               0x00000000
#define BMAPI_FW_MBA_PROT_RPL               0x00100000
#define BMAPI_FW_MBA_PROT_BOOTP             0x00200000
#define BMAPI_FW_MBA_PROT_ISCSI             0x00300000
#define BMAPI_FW_MBA_TYPE_SHIFT_POS         20
#define BMAPI_FW_FORCE_PCI_MODE_MASK        0x00000040
#define BMAPI_FW_ASF_MASK                   0x00000080
#define BMAPI_FW_PXE_BAR_SIZE               0x00000f00
#define BMAPI_FW_EEPROM_WP_MASK             BIT_22
#define BMAPI_FW_EEPROM_WP_SHIFT_POS        22
#define BMAPI_FW_WOL_SPEED_LOMIT10          BIT_25
#define BMAPI_FW_CABLE_SENSE_ENABLE         BIT_28

#define BMAPI_FW_PXE_BOOT_TYPE_MASK         0x00300000
#define BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS    20
#define BMAPI_FW_PXE_BOOT_TYPE_PXE          (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_PXE << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define BMAPI_FW_PXE_BOOT_TYPE_RPL          (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_RPL << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)
#define BMAPI_FW_PXE_BOOT_TYPE_BOOTP        (BMAPI_FW_FEATURE_CONFIG_BOOT_TYPE_BOOTP << BMAPI_FW_BOOT_TYPE_PXE_SHIFT_POS)

#define BMAPI_FW_PXE_BAR_SIZE_SHIFT_POS     8

#define BMAPI_VAUX_CUTOFF_DELAY_CHOICE(x)   (((x)>>23) & 0x3)

#define BMAPI_DRIVER_WOL_DISABLE            0
#define BMAPI_DRIVER_WOL_MAGIC_ENABLE       1
#define BMAPI_DRIVER_WOL_INT_PKT_ENABLE     2
#define BMAPI_DRIVER_WOL_BOTH_ENABLE        3



typedef union _BM_FW_FEATURE_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 fc_bit_31           :1;     /* reserved */
        U32 fc_bit_30           :1;     /* reserved */
        U32 mba_vlan_enable     :1;     /* bit 29 - Enable VLAN in Multiple Boot Agent */
        U32 cable_sense         :1;
        U32 driver_wol_enable   :2;     
        U32 Wol_Limit_10        :1;
        U32 vaux_cutoff_delay   :2;
        U32 lom_design          :1;
        U32 pxe_boot_protocol   :2;
        U32 pxe_timeout_msg     :4;
        U32 pxe_bootstrap_type  :2;     /* This field should be used by */
                                        /* boot code. This is only */
                                        /* referenced by MBA. */
        U32 hot_key_option      :1;     /* bit 13 - configure hot-key option: Ctrl-S or Ctrl-B  */
        U32 disable_setup_msg   :1;     /* bit 12 - Disable setup prompt for MBA configuration */
        U32 pxe_bar_size        :4;
        U32 asf_enable          :1;
        U32 force_pci           :1;
        U32 pxe_speed           :4;
        U32 pxe_enable          :1;
        U32 wol_enable          :1;
#else
        U32 wol_enable          :1;     /* bit 0      */
        U32 pxe_enable          :1;     /* bit 1      */
        U32 pxe_speed           :4;     /* bit 2:5    */
        U32 force_pci           :1;     /* bit 6      */
        U32 asf_enable          :1;     /* bit 7      */
        U32 pxe_bar_size        :4;     /* bit 8:11   */
        U32 disable_setup_msg   :1;     /* bit 12 - Disable setup prompt for MBA configuration */
        U32 hot_key_option      :1;     /* bit 13 - configure hot-key option: Ctrl-S or Ctrl-B  */
        U32 pxe_bootstrap_type  :2;     /* bit 14:15  */
        U32 pxe_timeout_msg     :4;     /* bit 16:19  */
        U32 pxe_boot_protocol   :2;     /* bit 20:21  */ /* This field */
                                        /* should be used by boot code. */
                                        /* This is only referenced by MBA. */
        U32 lom_design          :1;     /* bit 22     */
        U32 vaux_cutoff_delay   :2;     /* bit 23:24  */
        U32 Wol_Limit_10        :1;     /* bit 25     */
        U32 driver_wol_enable   :2;     /* bit 26:27  */
        U32 cable_sense         :1;     /* bit 28     */
        U32 mba_vlan_enable     :1;     /* bit 29 - Enable VLAN in Multiple Boot Agent */
        U32 fc_bit_30           :1;     /* bit 30, reserved */
        U32 fc_bit_31           :1;     /* bit 31, reserved */
#endif
    } bit;

    U32 word;
} BM_FW_FEATURE_CONFIG;



#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_UNKNOWN             0
#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_COPPER              1
#define BMAPI_FW_NIC_HW_CONFIG_PHY_TYPE_FIBER               2

/* the defines for mode setting in menu */
#define BMAPI_FW_NIC_HW_CONFIG_LED_MAC_MODE                 0
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_PHY_MODE_1          1
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_PHY_MODE_2          2
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_SHARED_TRAFFIC      3
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_SHASTA_MAC_MODE     4

#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_WIRELESS_COMBO_MODE 5  

#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_UNKNOWN             0
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_TRIPLE_LINK         1
#define BMAPI_FW_NIC_HW_CONFIG_LED_MODE_LINK_SPEED          2

#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_3_V        0x0
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_1_8_V        0x1
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_MASK         0x3
#define BMAPI_FW_NIC_HW_CONFIG_VOLTAGE_PARM(x)      (x & NIC_HW_CONFIG_VOLTAGE_MASK)

/* Both channel A and B are used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_NORMAL      0x0
/* Only Channel B is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_B      0x1
/* Only Channel A is used */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_CHAN_A      0x2
/* Use XBAR. single config. space for both channels. */
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_XBAR        0x3

#define BMAPI_FW_NIC_HW_CONFIG_DAUL_MAC_MASK        0xc00
#define BMAPI_FW_NIC_DUAL_MAC_SHIFT_POS             10
#define BMAPI_FW_NIC_HW_CONFIG_DUAL_MAC_PARM(x)     ((x & NIC_HW_CONFIG_DAUL_MAC_MASK) >> NIC_DUAL_MAC_SHIFT_POS)

#define BMAPI_FW_SHASTA_EXT_LED_LEGACY_MODE                     0
#define BMAPI_FW_SHASTA_EXT_LED_SHARED_TRAFFIC_LINK_LED_MODE    1
#define BMAPI_FW_SHASTA_EXT_LED_SHASTA_MAC_MODE                 2
#define BMAPI_FW_SHASTA_EXT_LED_WIRELESS_COMBO_MODE             3

#define BMAPI_FW_HW_CFG_VOLTAGE_SOURCE_MASK         (BIT_0 | BIT_1)
#define BMAPI_FW_HW_CFG_PHY_LED_MODE_MASK           (BIT_2 | BIT_3)
#define BMAPI_FW_HW_CFG_PHY_TYPE_MASK               (BIT_4 | BIT_5)
#define BMAPI_FW_HW_CFG_FORCE_MAX_PCI_RETRY         BIT_6
#define BMAPI_FW_HW_CFG_MAX_PCI_RETRY_MASK          (BIT_7 | BIT_8 | BIT_9)
#define BMAPI_FW_HW_CFG_DUAL_MAC_MODE_MASK          (BIT_10 | BIT_11)
#define BMAPI_FW_HW_CFG_REVERSE_WAY                 BIT_12
#define BMAPI_FW_HW_CFG_MINI_PCI                    BIT_13
#define BMAPI_FW_HW_CFG_AUTO_POWERDOWN              BIT_14
#define BMAPI_FW_HW_CFG_EXT_LED_MODE_MASK           (BIT_15 | BIT_16)
#define BMAPI_FW_HW_CFG_CAPACITIVE_COUPLING         BIT_17
#define BMAPI_FW_HW_CFG_TXSERDES_OVERRIDE           BIT_18
#define BMAPI_FW_HW_CFG_L0s_PERFORMANCE_FIX_EN      BIT_19

#define BMAPI_FW_CAPACITIVE_COUPLING                BMAPI_FW_HW_CFG_CAPACITIVE_COUPLING


typedef union _BM_FW_NIC_HW_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved                :12;
        U32 L0sPerformaceFix_enable :1;     /* bit 19      */
        U32 txSerdesOverride        :1;     /* bit 18      */
        U32 capacitive_coupling     :1;     /* bit 17      */
        U32 shasta_ext_led_mode     :2;     /* bit 15,16   */
        U32 enable_auto_powerdown   :1;     /* bit 14      */
        U32 mini_pci                :1;     /* bit 13      */
        U32 reverse_nway            :1;     /* bit 12      */
        U32 dual_mac_mode           :2;     /* bit 10:11   */
        U32 max_pci_retry           :3;     /* bit 7:9     */
        U32 forced_max_pci_retry    :1;     /* bit 6       */
        U32 phy_type                :2;     /* bit 4:5     */
        U32 phy_led_mode            :2;     /* bit 2:3     */
        U32 voltage_source          :2;     /* bit 0:1     */
#else
        U32 voltage_source          :2;     /* bit 0:1     */
        U32 phy_led_mode            :2;     /* bit 2:3     */
        U32 phy_type                :2;     /* bit 4:5     */
        U32 forced_max_pci_retry    :1;     /* bit 6       */
        U32 max_pci_retry           :3;     /* bit 7:9     */
        U32 dual_mac_mode           :2;     /* bit 10:11   */
        U32 reverse_nway            :1;     /* bit 12      */
        U32 mini_pci                :1;     /* bit 13      */
        U32 enable_auto_powerdown   :1;     /* bit 14      */
        U32 shasta_ext_led_mode     :2;     /* bit 15,16   */
        U32 capacitive_coupling     :1;     /* bit 17      */
        U32 txSerdesOverride        :1;     /* bit 18      */
        U32 L0sPerformaceFix_enable :1;     /* bit 19      */
        U32 reserved                :12;
#endif
    } bit;

    U32     word;
} BM_FW_NIC_HW_CONFIG;



typedef union _BM_NIC_SHARED_CONFIG
{
    struct
    {
#if defined(BIG_ENDIAN) && !defined(BCM_LITTLE_ENDIAN_HOST)
        U32 reserved: 15;           /* bit 17:31 */
        U32 gpio2_output_value:1;   /* bit 16 */
        U32 reserved_15:1;          /* bit 15 -- reserved */
        U32 gpio0_output_value:1;   /* bit 14 */
        U32 gpio2_output_enable:1;  /* bit 13 */
        U32 reserved_12:1;          /* bit 12 -- reserved */
        U32 gpio0_output_enable:1;  /* bit 11 */
        U32 reserved_7_10:4;        /* bit 7:10 -- reserved */
        U32 HotPlugPwrBdgtCnt:3;    /* bit 4:6 */
        U32 DisablePowerSaving:1;   /* bit 3 */
        U32 FiberWoLCapable:1;      /* bit 2 */
        U32 L1ASPM_Debounce_En:1;   /* bit 1 it was BothPort100MbpsCapable, now become L1ASPM_Debounce_En*/
        U32 portSwap:1;             /* bit 0 */
#else
        U32 portSwap:1;             /* bit 0 */
        U32 L1ASPM_Debounce_En:1;   /* bit 1 it was BothPort100MbpsCapable, now become L1ASPM_Debounce_En*/
        U32 FiberWoLCapable:1;      /* bit 2 */
        U32 DisablePowerSaving:1;   /* bit 3 */
        U32 HotPlugPwrBdgtCnt:3;    /* bit 4:6 */
        U32 reserved_7_10:4;        /* bit 7:10 -- reserved */
        U32 gpio0_output_enable:1;  /* bit 11 */
        U32 reserved_12:1;          /* bit 12 -- reserved */
        U32 gpio2_output_enable:1;  /* bit 13 */
        U32 gpio0_output_value:1;   /* bit 14 */
        U32 reserved_15:1;          /* bit 15 -- reserved */
        U32 gpio2_output_value:1;   /* bit 16 */
        U32 reserved: 15;           /* bit 17:31 */
#endif
    } bit;

    U32 word;
} BM_NIC_SHARED_CONFIG;

#define BMAPI_FW_SH_CFG_HOTPLUG_PWRBDGT_CNT_MASK    0x00000070
#define BMAPI_FW_SH_CFG_DIS_PW_SAVING               BIT_3
#define BMAPI_FW_SH_CFG_GPIO_MASK                   0x16800



typedef struct _BM_FW_MEDIA_MANUFACT_REGION
{
    // Version format of this data structure
    U8                      manuf_format_rev;

    // 2's Complement Checksum of Code Directory 0x14-0x73
    U8                      dir_cksum;

    // length of this structure in bytes
    U16                     length;

    // PHY ID of physical device
    U32                     phy_id;

    // MAC address
    U8                      mac_address[8];

    // part number. Printable string ending in '\0'.
    U8                      part_number[16];

    // part revision. Two printable ascii char.
    U8                      part_revision[2];

    // single byte acending rev number
    // Lower byte is major version number. (Little-Endian)
    // Higher byte is minor version number. (Little-Endian)
    U16                     bootcode_fw_revision;

    // ascii manufact date, wwyy, \0 by next field
    U8                      manuf_data[4];

    // VLAN ID used in Multiple Boot Agent - Port 1
    U16                     mba_vlan_id;

    // VLAN ID used in Multiple Boot Agent - Port 2
    U16                     mba_vlan_id_b;

    // pci device id
    U16                     pci_dev_id;

    // pci vendor id
    U16                     pci_vend_id;

    // alternate pci subsystem id
    U16                     pci_sub_id;

    // alternate pci subsystem vendor id
    U16                     pci_sub_vend_id;

    // cpu clock speed in Mhz rounded
    U16                     cpu_clk;
    // Port 1 smbus address
    U8                      smbus_addr1;
    // Port 0 smbus address
    U8                      smbus_addr0;

    // Backup permanent MAC address of port 1
    U8                      backup_mac_address[8];

    // Backup permanent MAC address of port 2
    U8                      backup_mac_addressb[8];

    U8                      power_dissipated[4];
    U8                      power_consumed[4];  

    BM_FW_FEATURE_CONFIG    feature_config;

    BM_FW_NIC_HW_CONFIG     hw_config;

    // Second MAC address for second channel in BCM5704
    U8                      mac_addressb[8];

    // second MAC feature_config
    BM_FW_FEATURE_CONFIG    feature_configb;

    // second MAC hw_config
    BM_FW_NIC_HW_CONFIG     hw_configb;

    BM_NIC_SHARED_CONFIG    shared_config;

    U32                     Power_Budget0;
    U32                     Power_Budget1;

    U32                     serworks_use;

    /* Primary MAC Serdes 0:15 override value */
    U16                     mac0_txSerdes_value;

    /* Secondary MAC Serdes 0:15 override value */
    U16                     mac1_txSerdes_value;

    /* size in k (2^10). value 0 = unknown */
    U16                     tpm_nvram_size;

    /* size in k (2^10). value 0 = unknown */
    U16                     mac_nvram_size;

    U32                     Power_Budget2;
    U32                     Power_Budget3;

    // 32-bit CRC
    U32                     cksum;

} BM_FW_MEDIA_MANUFACT_REGION;


#define BMAPI_FW_MAX_VPD_W_LENGTH           128

typedef struct _BM_FW_MEDIA_VPD_WRITE
{
    U8  data[BMAPI_FW_MAX_VPD_W_LENGTH];
} BM_FW_MEDIA_VPD_WRITE;


typedef struct _BM_FW_MEDIA_VPD
{
    BM_FW_MEDIA_VPD_WRITE   vpd_r;
    BM_FW_MEDIA_VPD_WRITE   vpd_w;
} BM_FW_MEDIA_VPD;


typedef struct _BM_FW_EEPROM_INFO
{
    BM_FW_MEDIA_BOOTSTRAP_REGION    bootstrap;
    BM_FW_MEDIA_CODE_OFFSET_REGION  code_offsets[BMAPI_FW_MEDIA_MAX_LOAD_STAGES];
    BM_FW_MEDIA_MANUFACT_REGION     manufact;
    BM_FW_MEDIA_VPD                 vpd;

} BM_FW_EEPROM_INFO;


#define BMAPI_FW_INFO_VER   5

typedef struct _BM_FW_INFO
{
    //  Version is defined as BMAPI_FW_INFO_VER.
    //  'version' is required upon input
    U32                 version;

    // On Linux, perm mac address can be retrieved by 
    // BmapiGetBRCMNicInfoEx() or by bBmapiGetPhyNic().
    // if the NIC is for selfboot.
    // Use 'is_selfboot' to find out the NIC selfboot or not.
    BM_FW_EEPROM_INFO   eeprom_info;

    // Boot code version description string.
    U8                  firmware_ver_desc[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // PXE version description string.
    // Not valid if the NIC is set for selfboot.
    // Use 'is_selfboot' to find out the NIC selfboot or not.
    U8                  pxe_ver_desc[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // Boolean flag to indicate whether the NIC is SW selfboot or not.
    U32                 is_selfboot;

    // '0' for SW selfboot format 0, '1' for SW selfboot format 1, etc.
    // Not valid if the NIC is NOT selfboot.
    U32                 selfboot_format;

    // iSCSI versions.
    U8                  iscsi[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // Boolean flag to indicate whether the NIC is HW selfboot or not.
    U32                 is_hw_selfboot;

} BM_FW_INFO;


#define BMAPI_FW_INFO_5706_VER      2

typedef struct _BM_FW_INFO_5706
{
    //  Version is defined as BMAPI_FW_INFO_5706_VER.
    //  'version' is required upon input
    U32                 version;

    // Boot code version string.
    U8                  bc1_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  bc2_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // MBA/PXE version string.
    U8                  pxe_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // L2RXP version string.
    U8                  l2rxp_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // UMP version string.
    U8                  ump_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // IPMI versions.
    U8                  ipmi_cfg[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ipmi_init[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  ipmi_serv[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // iSCSI versions.
    U8                  iscsi[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[BMAPI_FW_MAX_DESCRIPTION_LEN];

} BM_FW_INFO_5706;


#define BMAPI_FW_INFO_57710_VER      1

typedef struct _BM_FW_INFO_57710
{
    //  Version is defined as BMAPI_FW_INFO_57710_VER.
    //  'version' is required upon input
    U32                 version;

    // Boot code version string.
    U8                  bc1_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  bc2_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // MBA/PXE version string.
    U8                  pxe_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // UMP version string.
    U8                  ump_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // IPMI versions.
    U8                  ipmi_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // iSCSI versions.
    U8                  iscsib[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsi_cprg[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg[BMAPI_FW_MAX_DESCRIPTION_LEN];
    U8                  iscsib_cfg2[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // NCSI versions.
    U8                  ncsi_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // TSTORM versions.
    U8                  l2t_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // CSTORM versions.
    U8                  l2c_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // XSTORM versions.
    U8                  l2x_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // USTORM versions.
    U8                  l2u_ver[BMAPI_FW_MAX_DESCRIPTION_LEN];

    // VPD data
    BM_FW_MEDIA_VPD     vpd;

} BM_FW_INFO_57710;


/****************************************************************************
 *  APIs Definition
 ****************************************************************************/
void    BmapiGetVersion( U32 *pMajorVersion, U32 *pMinorVersion,
            U32 *pBuildVersion );
U32     BmapiInitialize( void );
U32     BmapiUninitialize( void );
U32     BmapiGetNumPhyNic( U32 *pNumOfPhy );
U32     BmapiGetAllPhyNic( BM_ADAPTER_INFO *pPhyList, U32 uNumOfPhy );
U32     BmapiGetServiceName( U32 handle, U8 *pServiceName, U32 uBufLen );
U32     BmapiInitializeEx( U32 bKeepCom );
U32     BmapiIsInitialized();
U32     BmapiGetHandleByServiceName( U8 *pServiceName, U32 *handle );
U32     BmapiGetNicPciInfo( U32 handle, BM_NIC_PCI_INFO *pNicPciInfo );
U32     BmapiInitDiag( U32 handle );
U32     BmapiUnInitDiag( U32 handle );
U32     BmapiGetNumPhyNicEx( U32 *pNumOfPhy );
U32     BmapiGetAllPhyNicHandles( U32 *pHandleList, U32 uNumOfPhy );
U32     BmapiGetPhyNic( U32 handle, BM_ADAPTER_INFO_EX *pNicInfoEx );
U32     BmapiGetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
U32     BmapiSetASFTable( U32 handle, BM_ASF_TABLE *pNicASF );
U32     BmapiGetBIOS( U64 start_addr, void *buffer, U32 length );
U32     BmapiGetSystemASFTables( BM_ASF_TABLE *pAsfTbls );
U32     BmapiWriteFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );
U32     BmapiReadFirmware( U32 handle, U32 uOffset, U32 *pDataBuf,
            U32 uBufLen, U8 *pChk );
U32     BmapiDoNicIOCTL( U32 handle, U32 ioctlCode, void *pInBuf,
                U32 inBufSize, void *pOutBuf, U32 *pOutBufSize,
                U32 *pResult );
U32     BmapiSuspendDriverEx( U32 handle );
U32     BmapiResumeDriverEx( U32 handle );
U32     BmapiEnableDevice( U32 handle, U32 uEnable );
U32     BmapiTestControlRegistersEx( U32 handle );
U32     BmapiTestMIIRegistersEx( U32 handle );
U32     BmapiTestInternalMemoryEx( U32 handle );
//U32     BmapiTestExternalMemoryEx( U32 handle, U32 ExtMemSize );
U32     BmapiTestInterruptEx( U32 handle );
U32     BmapiTestLoopBackEx( U32 handle, U32 Lbtype );
U32     BmapiTestCPUEx( U32 handle );
U32     BmapiTestLEDsEx( U32 handle, U32 BlinkDurationSec );
U32     BmapiTestEEPROMEx( U32 handle );
U32     BmapiTestASF( U32 handle );
U32     BmapiRefreshData();
U32     BmapiGetBRCMNicInfoEx( U32 handle,
                BM_BRCM_ADAPTER_INFO_EX *pBRCMNicInfoEx );
U32     BmapiReadNicMem( U32 handle, U32 uType, U32 uOffset, U32 *pData,
                U8 *pChk );
U32     BmapiWriteNicMem( U32 handle, U32 uType, U32 uOffset, U32 uData,
                U8 *pChk );
U32     BmapiGetBRCMNicStatistics( U32 handle,
                BM_BRCM_STATISTICS *pBrcmStatistics );
U32     BmapiGetFirmwareInfo( U32 handle, BM_FW_INFO *pFWInfo );
U32     BmapiWriteFirmwareInfo( U32 handle, BM_FW_INFO *pFWInfo, U32 uOption );
U32     BmapiGet5706FwInfo( U32 handle, BM_FW_INFO_5706 *pFwInfo );
U32     BmapiGet57710FwInfo( U32 handle, BM_FW_INFO_57710 *pFwInfo );




#ifdef __cplusplus
};
#endif

#endif /* __BMAPI_h__ */
