﻿using System.Data;
using System.Data.SqlClient;
using System.Reflection;
using System.Web;
using System.Linq;

namespace Utility
{
    public class SetSqlParameters
    {
        public static SqlConnection GetCmd(SqlConnection conn, out SqlCommand cmd, object obj, string spName)
        {
            cmd = conn.CreateCommand();
            cmd.CommandType = CommandType.StoredProcedure;
            cmd.CommandText = spName;
            SetParameters(cmd, obj);
            return conn;
        }

        private static void SetParameters(SqlCommand cmd, object obj)
        {
            string spReturnType = null;
            PropertyInfo[] properties = obj.GetType().GetProperties();
            foreach (var propertyInfo in properties)
            {
                object value = propertyInfo.GetValue(obj, null);
                if (value != null)
                {
                    if (HttpContext.Current.Cache["SqlParasMap"] == null)
                    {
                        var ds = new DataSet();
                        ds.ReadXml(HttpContext.Current.Server.MapPath("~/SqlParasMap.xml"));
                        HttpContext.Current.Cache["SqlParasMap"] = ds.Tables[0];
                    }
                    DataRow[] dr =
                        ((DataTable) HttpContext.Current.Cache["SqlParasMap"]).Select("System='" +
                                                                                      propertyInfo.PropertyType.Name +
                                                                                      "'");
                    if (dr.Count() > 0 && !value.ToString().Equals(dr[0]["Filter"]))
                    {
                        cmd.Parameters.Add(new SqlParameter("@" + propertyInfo.Name, dr[0]["SqlDbType"]));
                        cmd.Parameters["@" + propertyInfo.Name].Value = value;
                    }
                    if (propertyInfo.PropertyType.Name.Equals("SPReturnTypes"))
                    {
                        spReturnType = value.ToString();
                    }
                }
            }
            cmd.Parameters.Add(new SqlParameter("@SPReturnType", DbType.String));
            cmd.Parameters["@SPReturnType"].Value = spReturnType;
        }

        public static object SetModelByDataSet(DataSet ds, object obj)
        {
            foreach (DataRow dr1 in ds.Tables[0].Rows)
            {
                foreach (DataColumn dc in dr1.Table.Columns)
                {
                    PropertyInfo pi = obj.GetType().GetProperty(dc.ColumnName);
                    if (pi != null)
                    {
                        pi.SetValue(obj, dc.Table.Rows[0][0], null);
                    }
                }
            }
            return obj;
        }
    }
}
