﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;
using System.IO.IsolatedStorage;

namespace SampleCode.SamplePages
{
    public partial class AddRoutePage : PhoneApplicationPage
    {
        private IsolatedStorageSettings settings = IsolatedStorageSettings.ApplicationSettings;
        private List<RouteInfo> routeListData = (App.Current as App).RouteListData;

        private RouteInfo routeInfoData = new RouteInfo();
        public AddRoutePage()
        {
            (App.Current as App).route = routeInfoData;

            InitializeComponent();
        }

        private void addRoute_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Uri("/SamplePages/AddRoutePointPage.xaml", UriKind.RelativeOrAbsolute));
        }

        private void addMarkers_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Uri("/SamplePages/AddMarkerPointPage.xaml", UriKind.RelativeOrAbsolute));
        }

        private void okButton_Click(object sender, RoutedEventArgs e)
        {
            //增加一条完整的道路，返回上一页面RoutePage，更新“当前路线条数”
            this.routeInfoData.RouteWidth = Convert.ToUInt32(routeWidthTextBox.Text);

            Color routeColor = this.routeInfoData.RouteColor;
            routeColor.R = Convert.ToByte(this.routeColorRedTextBox.Text);
            routeColor.G = Convert.ToByte(this.routeColorGreenTextBox.Text);
            routeColor.B = Convert.ToByte(this.routeColorBlueTextBox.Text);
            routeColor.A = (byte)255;
            this.routeInfoData.RouteColor = routeColor;

            Color routeShadowColor = this.routeInfoData.RouteShadowColor;
            routeShadowColor.R = Convert.ToByte(this.shadowColorRedTextBox.Text);
            routeShadowColor.G = Convert.ToByte(this.shadowColorGreenTextBox.Text);
            routeShadowColor.B = Convert.ToByte(this.shadowColorBlueTextBox.Text);
            routeShadowColor.A = (byte)255;
            this.routeInfoData.RouteShadowColor = routeShadowColor;

            routeListData.Add(this.routeInfoData);

            (App.Current as App).route = null;

            this.NavigationService.GoBack();
        }

        private void cancelButton_Click(object sender, RoutedEventArgs e)
        {
            this.NavigationService.GoBack();
        }

        private void LayoutRoot_Loaded(object sender, RoutedEventArgs e)
        {
            if (this.routeInfoData.RoutePointList.Count <= 0)
            {
                this.okButton.IsEnabled = false;
            }
            else
            {
                this.okButton.IsEnabled = true;
            }
        }
    }
}