﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;
using System.IO.IsolatedStorage;

namespace SampleCode.SamplePages
{
    public partial class AddRoutePointPage : PhoneApplicationPage
    {
        private RouteInfo activeRoute = (App.Current as App).route;
        public AddRoutePointPage()
        {
            InitializeComponent();

            InitalRouteByCulture();
        }

        private void InitalRouteByCulture()
        {
            if ("en-US" == (App.Current as App).CultureName)
            {
                double[] r1 = { 13.262444, 52.540867, 13.264561, 52.536691, 13.268337, 52.529172, 13.273144, 52.528337, 13.27898, 52.52583, 13.279667, 52.518728};

                for (int iLoop = 0; iLoop < r1.Length; iLoop += 2)
                {
                    NotifyGeoPoint point = new NotifyGeoPoint();
                    point.Longitude = r1[iLoop].ToString();
                    point.Latitude = r1[iLoop + 1].ToString();
                    this.routePointList.Items.Add(point);
                }
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                double[] r1 = { 13.262444, 52.540867, 13.264561, 52.536691, 13.268337, 52.529172, 13.273144, 52.528337, 13.27898, 52.52583, 13.279667, 52.518728 };

                for (int iLoop = 0; iLoop < r1.Length; iLoop += 2)
                {
                    NotifyGeoPoint point = new NotifyGeoPoint();
                    point.Longitude = r1[iLoop].ToString();
                    point.Latitude = r1[iLoop + 1].ToString();
                    this.routePointList.Items.Add(point);
                }
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                double[] r1 = { 116.3977, 39.903, 116.3967, 39.913, 116.3947, 39.923, 116.3927, 39.963, 116.3987, 39.983, 116.3977, 39.903 };

                for (int iLoop = 0; iLoop < r1.Length; iLoop += 2)
                {
                    NotifyGeoPoint point = new NotifyGeoPoint();
                    point.Longitude = r1[iLoop].ToString();
                    point.Latitude = r1[iLoop + 1].ToString();
                    this.routePointList.Items.Add(point);
                }
            }


        }

        private void addRoutePoint_Click(object sender, RoutedEventArgs e)
        {
            NotifyGeoPoint point = new NotifyGeoPoint();

            NotifyGeoPoint last = this.routePointList.Items[this.routePointList.Items.Count - 1] as NotifyGeoPoint;
            point.Longitude = (Convert.ToDouble(last.Longitude) + 0.02).ToString();
            point.Latitude = (Convert.ToDouble(last.Latitude) + 0.02).ToString();
            this.routePointList.Items.Add(point);
        }

        private void okButton_Click(object sender, RoutedEventArgs e)
        {
            //添加该路线到一个RouteInfo对象中
            if (!IsPointListValid())
            {
                MessageBoxResult result = MessageBox.Show("输入的坐标有不符合规范的，离开将不会增加到路线中。请确认是否离开？", "警告", MessageBoxButton.OKCancel);
                if (MessageBoxResult.OK == result)
                {
                    this.NavigationService.GoBack();
                    return;
                }

                return;
            }

            SampleCodeCommon.ItemGeoListToGeoPointList(this.routePointList, this.activeRoute.RoutePointList);

            this.NavigationService.GoBack();
        }

        private void cancelButton_Click(object sender, RoutedEventArgs e)
        {
            //取消
            this.NavigationService.GoBack();
        }

        private void layoutRoot_Loaded(object sender, RoutedEventArgs e)
        {
            SampleCodeCommon.GeoPointListToItemGeoList(this.activeRoute.RoutePointList, this.routePointList);
        }

        private bool IsPointListValid()
        {
            foreach (NotifyGeoPoint point in this.routePointList.Items)
            {
                if (null == point.Longitude
                    || point.Longitude.Equals("")
                    || null == point.Latitude
                    || point.Latitude.Equals(""))
                {
                    return false;
                }

                if (-180 > Convert.ToDouble(point.Longitude)
                    || 180 < Convert.ToDouble(point.Longitude)
                    || -90 > Convert.ToDouble(point.Latitude)
                    || 90 < Convert.ToDouble(point.Latitude))
                {
                    return false;
                }
            }

            return true;
        }

        private void LayoutRoot_Unloaded(object sender, RoutedEventArgs e)
        {
        }

    }
}