﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;
using System.Device.Location;

namespace SampleCode.SamplePages
{
    public partial class AdvanceDemoPage : PhoneApplicationPage
    {
        private GeoCoordinateWatcher watcher = null;

        private GeoPoint center = new GeoPoint();
        private int iLevel = 10;

        double[] difx =
        {		
        0.70312500000000000000 	,	//0
        0.35156250000000000000 	,	//1
        0.17578125000000000000 	,	//2
        0.17947009277971400000000000000 	,//3
        0.09018358755677730000000000000 	,//4
        0.04379593227461720000000000000 	,//5
        0.02199196788480160000000000000 	,//6
        0.01095409885339940000000000000 	,//7
        0.00562807962474760000000000000 	,//8
        0.00282386830320311000000000000 	,//9
        0.00140258847593963000000000000 	,//10
        0.00070522429592745000000000000 	,//11
        0.00035175421086405600000000000 	,//12
        0.00017564507758845000000000000 	,//13
        0.00008792637207778530000000000 	,//14
        0.00004407041332191440000000000 	,//15
        0.00002195722591194740000000000 	,//16
        0.00001097861295597370000000000 	,//17
        0.00000550917412709330000000000 	,//18
        0.00000274788490524119000000000 	,//19
        0.00000137584842091850000000000 	,//20
        };

        double[] dify =
        {		
        0.70312500000000000000 	        ,   //0
        0.35156250000000000000          ,	//1
        0.17578125000000000000          ,	//2
        0.21579246127700300000000000000 	,//3
        0.10779862565195300000000000000 	,//4
        0.05035084988412610000000000000 	,//5
        0.02387211113177180000000000000 	,//6
        0.01160921672098410000000000000 	,//7
        0.00570327976044238000000000000 	,//8
        0.00282763373335596000000000000 	,//9
        0.00140672468362897000000000000 	,//10
        0.00070389178800889900000000000 	,//11
        0.00035243675752082600000000000 	,//12
        0.00017558423899683800000000000 	,//13
        0.00008777103696213910000000000 	,//14
        0.00004383086686894240000000000 	,//15
        0.00002194686234958270000000000 	,//16
        0.00001096877328889950000000000 	,//17
        0.00000548438664444972000000000 	,//18
        0.00000274162945673336000000000 	,//19
        0.00000137258825044077000000000 	,//20
        };

        double xMoveSize;
        double yMoveSize;

        enum MovingSide
        {
            MovingSide_left,
            MovingSide_up,
            MovingSide_right,
            MovingSide_down
        };

        public AdvanceDemoPage()
        {
            InitializeComponent();

            xMoveSize = this.nokiaMapControl1.Width / 3.0 * this.difx[this.iLevel];
            yMoveSize = this.nokiaMapControl1.Height / 3.0 * this.dify[this.iLevel];

            center.Longitude = 116.3977;
            center.Latitude = 39.903;

            this.nokiaMapControl1.SetZoomLevel(iLevel);
            this.nokiaMapControl1.SetCenter(this.center);
            this.nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            this.nokiaMapControl1.SetScaleBarType(ScaleBarType.Kilometers);
            this.nokiaMapControl1.DownloadMapImageCompleted += downloadMapImageCompleted;
        }

        private void Location_Checked(object sender, RoutedEventArgs e)
        {
            EnableMapOperator(false);
            
            // The watcher variable was previously declared as type GeoCoordinateWatcher. 
            if (watcher == null)
            {
                // using high accuracy
                watcher = new GeoCoordinateWatcher(GeoPositionAccuracy.High);
                // use MovementThreshold to ignore noise in the signal
                watcher.MovementThreshold = 20;
            }

            watcher.StatusChanged += new EventHandler<GeoPositionStatusChangedEventArgs>(watcher_StatusChanged);
            watcher.PositionChanged += new EventHandler<GeoPositionChangedEventArgs<GeoCoordinate>>(watcher_PositionChanged);

            watcher.Start();
        }

        private void Location_Unchecked(object sender, RoutedEventArgs e)
        {
            watcher.Stop();
            watcher = null;

            EnableMapOperator(true);            
        }

        private void ZoomDown_Click(object sender, RoutedEventArgs e)
        {
            if (0 < this.iLevel)
            {
                --this.iLevel;
            }
            if (0 >= this.iLevel)
            {
                this.ZoomUp.IsEnabled = false;
            }

            xMoveSize = this.nokiaMapControl1.Width / 3.0 * this.difx[this.iLevel];
            yMoveSize = this.nokiaMapControl1.Height / 3.0 * this.dify[this.iLevel];

            EnableMapOperator(false);
            this.nokiaMapControl1.SetZoomLevel(this.iLevel);
            this.nokiaMapControl1.Refresh();
        }

        private void ZoomUp_Click(object sender, RoutedEventArgs e)
        {
            if (20 > this.iLevel)
            {
                ++this.iLevel;
            }
            if (20 <= this.iLevel)
            {
                this.ZoomDown.IsEnabled = false;
            }

            xMoveSize = this.nokiaMapControl1.Width / 3.0 * this.difx[this.iLevel];
            yMoveSize = this.nokiaMapControl1.Height / 3.0 * this.dify[this.iLevel];

            EnableMapOperator(false);
            this.nokiaMapControl1.SetZoomLevel(this.iLevel);
            this.nokiaMapControl1.Refresh();
        }

        private void Down_Click(object sender, RoutedEventArgs e)
        {
            Move(MovingSide.MovingSide_down);
        }

        private void Right_Click(object sender, RoutedEventArgs e)
        {
            Move(MovingSide.MovingSide_right);
        }

        private void Left_Click(object sender, RoutedEventArgs e)
        {
            Move(MovingSide.MovingSide_left);
        }

        private void Up_Click(object sender, RoutedEventArgs e)
        {
            Move(MovingSide.MovingSide_up);
        }

        void downloadMapImageCompleted(string error)
        {
            // 定位与手动操作互斥
            if (null == this.watcher)
            {
                EnableMapOperator(true);
            }
        }

        private void EnableMapOperator(bool enable)
        {
            this.Left.IsEnabled = enable;
            this.Right.IsEnabled = enable;
            this.Up.IsEnabled = enable;
            this.Down.IsEnabled = enable;
            if (this.iLevel < 20)
            {
                this.ZoomDown.IsEnabled = enable;
            }
            if (this.iLevel > 0)
            {
                this.ZoomUp.IsEnabled = enable;
            }
        }

        private bool Move(MovingSide movingSide)
        {
            GeoPoint newCenter = new GeoPoint();
            if (!GetMovedPos(movingSide, newCenter))
            {
                return false;
            }

            if (!IsValidPos(newCenter))
            {
                return false;
            }
            EnableMapOperator(false);

            this.center = newCenter;
            this.nokiaMapControl1.SetCenter(this.center);
            this.nokiaMapControl1.Refresh();

            return false;
        }

        private bool IsValidPos(GeoPoint pos)
        {
            if (-180 > pos.Longitude
                || 180 < pos.Longitude
                || -90 > pos.Latitude
                || 90 < pos.Latitude)
            {
                return false;
            }

            return true;
        }

        private bool GetMovedPos(MovingSide movingSide, GeoPoint movedPos)
        {
            switch (movingSide)
            {
                case MovingSide.MovingSide_left:
                    movedPos.Longitude = this.center.Longitude - xMoveSize;
                    movedPos.Latitude = this.center.Latitude;
                    break;
                case MovingSide.MovingSide_up:
                    movedPos.Latitude = this.center.Latitude + yMoveSize;
                    movedPos.Longitude = this.center.Longitude;
                    break;
                case MovingSide.MovingSide_right:
                    movedPos.Longitude = this.center.Longitude + xMoveSize;
                    movedPos.Latitude = this.center.Latitude;
                    break;
                case MovingSide.MovingSide_down:
                    movedPos.Latitude = this.center.Latitude - yMoveSize;
                    movedPos.Longitude = this.center.Longitude;
                    break;
                default:
                    return false;
            }

            return true;
        }

        // Event handler for the GeoCoordinateWatcher.StatusChanged event.
        void watcher_StatusChanged(object sender, GeoPositionStatusChangedEventArgs e)
        {
            switch (e.Status)
            {
                case GeoPositionStatus.Disabled:
                    // The Location Service is disabled or unsupported.
                    // Check to see whether the user has disabled the Location Service.
                    if (watcher.Permission == GeoPositionPermission.Denied)
                    {
                        // The user has disabled the Location Service on their device.
                        MessageBox.Show("you have this application access to location.");
                    }
                    else
                    {
                        MessageBox.Show("location is not functioning on this device");
                    }
                    break;

                case GeoPositionStatus.Initializing:
                    // The Location Service is initializing.
                    // Disable the Start Location button.
                    this.Location.IsEnabled = false;
                    EnableMapOperator(false);
                    break;

                case GeoPositionStatus.NoData:
                    // The Location Service is working, but it cannot get location data.
                    // Alert the user and enable the Stop Location button.
                    MessageBox.Show("location data is not available.");
                    this.Location.IsEnabled = true;
                    break;

                case GeoPositionStatus.Ready:
                    // The Location Service is working and is receiving location data.
                    // Show the current position and enable the Stop Location button.
                    //MessageBox.Show("location data is available.");
                    this.Location.IsEnabled = true;
                    break;
            }
        }

        void watcher_PositionChanged(object sender, GeoPositionChangedEventArgs<GeoCoordinate> e)
        {
            this.center.Latitude = e.Position.Location.Latitude;
            this.center.Longitude = e.Position.Location.Longitude;

            this.nokiaMapControl1.SetCenter(this.center);
            this.nokiaMapControl1.Refresh();
        }

        private void nokiaMapControl1_Loaded(object sender, RoutedEventArgs e)
        {
            this.nokiaMapControl1.Refresh();
        }
    }
}