﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.Collections.ObjectModel;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class MarkPOIPage : PhoneApplicationPage
    {
        public ObservableCollection<NotifyGeoPoint> Items { get; set; }
        private List<GeoPoint> geoPointList;

        public NotifyGeoPoint MyGeoPoint { get; set; }

        public MarkPOIPage()
        {
            InitializeComponent();

            Items = new ObservableCollection<NotifyGeoPoint>();
            geoPointList = new List<GeoPoint>();

            InitDataByCulture();

            this.Loaded += new RoutedEventHandler(MarkPOIPage_Loaded);

            nokiaMapControl1.SetZoomLevel(10);           
        }

        private void MarkPOIPage_Loaded(object sender, RoutedEventArgs e)
        {
            this.listBox1.ItemsSource = Items;
        }

        private void InitDataByCulture()
        {
            if ("en-US" == (App.Current as App).CultureName)
            {
                NotifyGeoPoint poi1 = new NotifyGeoPoint();
                poi1.Longitude = "13.3848";
                poi1.Latitude = "52.534";
                Items.Add(poi1);

                NotifyGeoPoint poi2 = new NotifyGeoPoint();
                poi2.Longitude = "13.3748";
                poi2.Latitude = "52.544";
                Items.Add(poi2);

                NotifyGeoPoint poi3 = new NotifyGeoPoint();
                poi3.Longitude = "13.3948";
                poi3.Latitude = "52.554";
                Items.Add(poi3);

                NotifyGeoPoint poi4 = new NotifyGeoPoint();
                poi4.Longitude = "13.4348";
                poi4.Latitude = "52.584";
                Items.Add(poi4);

                NotifyGeoPoint poi5 = new NotifyGeoPoint();
                poi5.Longitude = "13.3848";
                poi5.Latitude = "52.534";
                Items.Add(poi5);
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                NotifyGeoPoint poi1 = new NotifyGeoPoint();
                poi1.Longitude = "13.3848";
                poi1.Latitude = "52.534";
                Items.Add(poi1);

                NotifyGeoPoint poi2 = new NotifyGeoPoint();
                poi2.Longitude = "13.3748";
                poi2.Latitude = "52.544";
                Items.Add(poi2);

                NotifyGeoPoint poi3 = new NotifyGeoPoint();
                poi3.Longitude = "13.3948";
                poi3.Latitude = "52.554";
                Items.Add(poi3);

                NotifyGeoPoint poi4 = new NotifyGeoPoint();
                poi4.Longitude = "13.4348";
                poi4.Latitude = "52.584";
                Items.Add(poi4);

                NotifyGeoPoint poi5 = new NotifyGeoPoint();
                poi5.Longitude = "13.3848";
                poi5.Latitude = "52.534";
                Items.Add(poi5);
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                NotifyGeoPoint poi1 = new NotifyGeoPoint();
                poi1.Longitude = "116.3977";
                poi1.Latitude = "39.903";
                Items.Add(poi1);

                NotifyGeoPoint poi2 = new NotifyGeoPoint();
                poi2.Longitude = "116.3877";
                poi2.Latitude = "39.913";
                Items.Add(poi2);

                NotifyGeoPoint poi3 = new NotifyGeoPoint();
                poi3.Longitude = "116.4077";
                poi3.Latitude = "39.923";
                Items.Add(poi3);

                NotifyGeoPoint poi4 = new NotifyGeoPoint();
                poi4.Longitude = "116.4377";
                poi4.Latitude = "39.953";
                Items.Add(poi4);

                NotifyGeoPoint poi5 = new NotifyGeoPoint();
                poi5.Longitude = "116.3977";
                poi5.Latitude = "39.903";
                Items.Add(poi5);
            }           
        }

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            geoPointList.Clear();
            foreach (NotifyGeoPoint notifyGeoPoint in Items)
            {
                GeoPoint geoPoint = new GeoPoint();
                geoPoint.Longitude = Convert.ToDouble(notifyGeoPoint.Longitude);
                geoPoint.Latitude = Convert.ToDouble(notifyGeoPoint.Latitude);
                geoPointList.Add(geoPoint);
            }

            nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            nokiaMapControl1.MarkPOIs(geoPointList);
            nokiaMapControl1.Refresh();
        }
    }
}