﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class OpenMapByCenterAndRadiusPage : PhoneApplicationPage
    {
        public OpenMapByCenterAndRadiusPage()
        {
            InitializeComponent();

            InitalElementByCulture();
        }

        private void InitalElementByCulture()
        {
            if ("en-US" == (App.Current as App).CultureName)
            {
                textBox1.Text = "13.3845";
                textBox2.Text = "52.531";
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                textBox1.Text = "13.3845";
                textBox2.Text = "52.531";
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                textBox1.Text = "116.3977";
                textBox2.Text = "39.903";
            }
        }

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            GeoPoint center = new GeoPoint();
            center.Longitude = Convert.ToDouble(textBox1.Text);
            center.Latitude = Convert.ToDouble(textBox2.Text);

            if (!System.Text.RegularExpressions.Regex.IsMatch(textBox3.Text.Trim(), @"^[0-9]+$"))
            {
                MessageBox.Show("请输入数字! ");
                return;
            }

            nokiaMapControl1.OpenMapbyCenterAndRadius(center, Convert.ToInt32(textBox3.Text));
        }
    }
}