﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using System.IO.IsolatedStorage;
using NokiaMapSDK;


namespace SampleCode.SamplePages
{
    public partial class RoutePage : PhoneApplicationPage
    {
        private IsolatedStorageSettings settings = IsolatedStorageSettings.ApplicationSettings;
        List<RouteInfo> routeListData = null;

        public RoutePage()
        {
            routeListData = (App.Current as App).RouteListData;

            InitializeComponent();
        }

        private void addRouteButton_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Uri("/SamplePages/AddRoutePage.xaml", UriKind.RelativeOrAbsolute));
        }

        private void clear_Click(object sender, RoutedEventArgs e)
        {
            this.routeListData.Clear();

            this.routeNumTextBlock.Text = this.routeListData.Count.ToString();

            refreshMapButton.IsEnabled = false;
            clearSettingButton.IsEnabled = false;
        }

        private void refreshMap_Click(object sender, RoutedEventArgs e)
        {
            nokiaMapControl1.InitMap();

            nokiaMapControl1.AddRoutes(routeListData);

            nokiaMapControl1.Refresh();
        }

        private void LayoutRoot_Loaded(object sender, RoutedEventArgs e)
        {
            this.routeNumTextBlock.Text = this.routeListData.Count.ToString();
            if (this.routeListData.Count <= 0)
            {
                refreshMapButton.IsEnabled = false;
                clearSettingButton.IsEnabled = false;
            }
            else
            {
                refreshMapButton.IsEnabled = true;
                clearSettingButton.IsEnabled = true;
            }
        }
    }
}