﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class SetInfoBoxPositionPage : PhoneApplicationPage
    {
        InfoBoxPosition infoBoxPosition = InfoBoxPosition.TopCenter;
        public SetInfoBoxPositionPage()
        {
            InitializeComponent();
        }

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            switch (listPicker1.SelectedIndex)
            {
                case 0:
                    infoBoxPosition = InfoBoxPosition.TopCenter;
                    break;
                case 1:
                    infoBoxPosition = InfoBoxPosition.AboveMarker;
                    break;
                case 2:
                    infoBoxPosition = InfoBoxPosition.LeftMarker;
                    break;
                case 3:
                    infoBoxPosition = InfoBoxPosition.RightMarker;
                    break;
                case 4:
                    infoBoxPosition = InfoBoxPosition.BelowMarker;
                    break;
                default:
                    break;
            }

            PlaceInfo placeInfo = new PlaceInfo();

            if ("en-US" == (App.Current as App).CultureName)
            {
                placeInfo.CountryName = "germany";
                placeInfo.CityName = "leipzig";
                placeInfo.StreetName = "markt";
                placeInfo.HouseNumber = "9";
                placeInfo.ZipCode = "04109";
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                placeInfo.CountryName = "germany";
                placeInfo.CityName = "leipzig";
                placeInfo.StreetName = "markt";
                placeInfo.HouseNumber = "9";
                placeInfo.ZipCode = "04109";
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                placeInfo.CountryName = "中国";
                placeInfo.CityName = "北京";
                placeInfo.StreetName = "丹棱街";
                placeInfo.HouseNumber = "9";
                placeInfo.ZipCode = "100080";
            }
            
            nokiaMapControl1.SetPlaceInfo(placeInfo);
            nokiaMapControl1.SetInfoBoxPosition(infoBoxPosition);

            nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            nokiaMapControl1.Refresh();
        }
    }
}