﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class SetLabelLanguagePage : PhoneApplicationPage
    {
        LabelLanguageType labelLanguageType = LabelLanguageType.Chinese; 
        public SetLabelLanguagePage()
        {
            InitializeComponent();

            InitalElementByCulture();
        }

        private void InitalElementByCulture()
        {
            if ("en-US" == (App.Current as App).CultureName)
            {
                listPicker1.SelectedIndex = 0;
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                listPicker1.SelectedIndex = 2;
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                listPicker1.SelectedIndex = 1;
            }
        }

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            switch (listPicker1.SelectedIndex)
            {
                case 0:
                    labelLanguageType = LabelLanguageType.English;
                    break;
                case 1:
                    labelLanguageType = LabelLanguageType.Chinese;
                    break;
                case 2:
                    labelLanguageType = LabelLanguageType.German;
                    break;
                case 3:
                    labelLanguageType = LabelLanguageType.French;
                    break;
                case 4:
                    labelLanguageType = LabelLanguageType.Italian;
                    break;
                case 5:
                    labelLanguageType = LabelLanguageType.Spanish;
                    break;
                case 6:
                    labelLanguageType = LabelLanguageType.Russian;
                    break;
                default:
                    break;
            }

            nokiaMapControl1.SetLabelLanguage(labelLanguageType);
            nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            nokiaMapControl1.Refresh();
        }
    }
}