﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class SetMergedOverlappingMarkerPage : PhoneApplicationPage
    {
        public SetMergedOverlappingMarkerPage()
        {
            InitializeComponent();

            nokiaMapControl1.SetZoomLevel(10);  
        }

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            InitDataByCulture();           

            if (checkBox1.IsChecked == true)
            {
                nokiaMapControl1.SetMergedOverlappingMarker(true);
            }
            else
            {
                nokiaMapControl1.SetMergedOverlappingMarker(false);
            }

            nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            nokiaMapControl1.Refresh();

        }

        private void InitDataByCulture()
        {
            List<GeoPoint> poiList = new List<GeoPoint>();
            
            if ("en-US" == (App.Current as App).CultureName)
            {
                GeoPoint poi1 = new GeoPoint();
                poi1.Longitude = 13.3848;
                poi1.Latitude = 52.534;
                poiList.Add(poi1);

                GeoPoint poi2 = new GeoPoint();
                poi2.Longitude = 13.3748;
                poi2.Latitude = 52.544;
                poiList.Add(poi2);

                GeoPoint poi3 = new GeoPoint();
                poi3.Longitude = 13.3948;
                poi3.Latitude = 52.554;
                poiList.Add(poi3);

                GeoPoint poi4 = new GeoPoint();
                poi4.Longitude = 13.4348;
                poi4.Latitude = 52.584;
                poiList.Add(poi4);

                GeoPoint poi5 = new GeoPoint();
                poi5.Longitude = 13.3848;
                poi5.Latitude = 52.534;
                poiList.Add(poi5);
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                GeoPoint poi1 = new GeoPoint();
                poi1.Longitude = 13.3848;
                poi1.Latitude = 52.534;
                poiList.Add(poi1);

                GeoPoint poi2 = new GeoPoint();
                poi2.Longitude = 13.3748;
                poi2.Latitude = 52.544;
                poiList.Add(poi2);

                GeoPoint poi3 = new GeoPoint();
                poi3.Longitude = 13.3948;
                poi3.Latitude = 52.554;
                poiList.Add(poi3);

                GeoPoint poi4 = new GeoPoint();
                poi4.Longitude = 13.4348;
                poi4.Latitude = 52.584;
                poiList.Add(poi4);

                GeoPoint poi5 = new GeoPoint();
                poi5.Longitude = 13.3848;
                poi5.Latitude = 52.534;
                poiList.Add(poi5);
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                GeoPoint poi1 = new GeoPoint();
                poi1.Longitude = 116.3977;
                poi1.Latitude = 39.903;
                poiList.Add(poi1);

                GeoPoint poi2 = new GeoPoint();
                poi2.Longitude = 116.3877;
                poi2.Latitude = 39.913;
                poiList.Add(poi2);

                GeoPoint poi3 = new GeoPoint();
                poi3.Longitude = 116.4077;
                poi3.Latitude = 39.923;
                poiList.Add(poi3);

                GeoPoint poi4 = new GeoPoint();
                poi4.Longitude = 116.4377;
                poi4.Latitude = 39.953;
                poiList.Add(poi4);

                GeoPoint poi5 = new GeoPoint();
                poi5.Longitude = 116.3977;
                poi5.Latitude = 39.903;
                poiList.Add(poi5);
            }

            nokiaMapControl1.MarkPOIs(poiList);
        }
    }
}