﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;

namespace SampleCode
{
    public partial class SetPlaceInfoPage : PhoneApplicationPage
    {
        public SetPlaceInfoPage()
        {
            InitializeComponent();

            InitializeElementByCulture();
        }

        private void InitializeElementByCulture()
        {
            if ("en-US" == (App.Current as App).CultureName)
            {
                textBox1.Text = "germany";
                textBox2.Text = "leipzig";
                textBox3.Text = "markt";
                textBox4.Text = "9";
                textBox5.Text = "04109";
            }
            else if ("de-DE" == (App.Current as App).CultureName)
            {
                textBox1.Text = "germany";
                textBox2.Text = "leipzig";
                textBox3.Text = "markt";
                textBox4.Text = "9";
                textBox5.Text = "04109";
            }
            else if ("zh-CN" == (App.Current as App).CultureName)
            {
                textBox1.Text = "中国";
                textBox2.Text = "北京";
                textBox3.Text = "丹棱街";
                textBox4.Text = "9";
                textBox5.Text = "100080";
            }
        }
        

        private void refreshButton_Click(object sender, RoutedEventArgs e)
        {
            PlaceInfo placeInfo = new PlaceInfo();
            placeInfo.CountryName = textBox1.Text;
            placeInfo.CityName = textBox2.Text;
            placeInfo.StreetName = textBox3.Text;
            placeInfo.HouseNumber = textBox4.Text;
            placeInfo.ZipCode = textBox5.Text;

            nokiaMapControl1.SetAppIDAndToken(DefaultSettings.GetAppID(), DefaultSettings.GetToken());
            nokiaMapControl1.SetPlaceInfo(placeInfo);

            nokiaMapControl1.Refresh();
        }
    }
}