﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using NokiaMapSDK;
using System.Collections.Generic;

namespace SampleCode
{
    public class SampleCodeCommon
    {

        /// <summary>
        /// 将ListBox控件中的经纬度，转换为List列表中的经纬度。
        /// </summary>
        /// <param name="Items">ListBox控件</param>
        /// <param name="geoPointList">List列表</param>
        public static void ItemGeoListToGeoPointList(ListBox listBoxControl, List<GeoPoint> geoPointList)
        {
            foreach (NotifyGeoPoint shapePoint in listBoxControl.Items)
            {
                GeoPoint shapeGeoPoint = new GeoPoint();
                shapeGeoPoint.Longitude = Convert.ToDouble(shapePoint.Longitude);
                shapeGeoPoint.Latitude = Convert.ToDouble(shapePoint.Latitude);
                geoPointList.Add(shapeGeoPoint);
            }
        }

        /// <summary>
        /// 将ListBox控件中的经纬度，转换为List列表中的经纬度。
        /// </summary>
        /// <param name="geoPointList">List列表</param>
        /// <param name="Items">ListBox控件</param>
        public static void GeoPointListToItemGeoList(List<GeoPoint> geoPointList, ListBox listBoxControl)
        {
            foreach (GeoPoint shapeGeoPoint in geoPointList)
            {
                NotifyGeoPoint shapePoint = new NotifyGeoPoint();
                shapePoint.Longitude = shapeGeoPoint.Longitude.ToString();
                shapePoint.Latitude = shapeGeoPoint.Latitude.ToString();
                listBoxControl.Items.Add(shapePoint);
            }
        }
    }
}
