﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;
using Microsoft.Phone.Controls;
using NokiaMapSDK;
using System.Windows.Media.Imaging;

namespace TestNokiaMap
{
    public partial class MainPage : PhoneApplicationPage
    {
        private BaseMap baseMap = null;
        private String appId = "fjYOvjjKjLFl2DXqsNQB";
        private String token = "yZVuHxhAcgcxLnFyeygTDw%3D%3D";

        // Constructor
        public MainPage()
        {
            InitializeComponent();
            #region 测试代码

            GeoPoint point = new GeoPoint();
            point.Latitude = 67.371425;
            point.Longitude = 116.387695;

            for (int i = 0; i < 100; ++i)
            {
                point.Latitude += 0.05;
                point.Longitude += 0.05;

                string strCheck = GeoEncoding.Encoding(point);

                GeoPoint pointCheck = GeoEncoding.Decoding(strCheck);

                if(!pointCheck.Equals(point))
                {
                    //string strEncode = GeoEncoding.EncodeBase64(point);
                    //string strDecode = GeoEncoding.DecodeBase64(strCheck);
                    //string strReCheck = GeoEncoding.EncodeBase64(pointCheck);
                    //if (strEncode != strDecode)
                    //{
                    //    baseMap = new BaseMap(this.appId, this.token);
                    //}
                }
            }

            #endregion 测试代码
        }

        private void baseMapButton_Click(object sender, RoutedEventArgs e)
        {
            TestBaseMap();
        }

        private void tiltingMapButton_Click(object sender, RoutedEventArgs e)
        {
            TestTiltingMap();
        }

        private void addressMapButton_Click(object sender, RoutedEventArgs e)
        {
            TestAddressMap();
        }

        private void poiMapButton_Click(object sender, RoutedEventArgs e)
        {
            TestPOIMap();
        }

        void TestBaseMap()
        {
            baseMap = new BaseMap(this.appId, this.token);
            GeoPoint centerPoint = new GeoPoint();
            centerPoint.Longitude = 116.3977;
            centerPoint.Latitude = 39.903;
            baseMap.SetCenter(centerPoint);
            baseMap.SetZoomLevel(15);
            baseMap.SetScaleBarType(ScaleBarType.KilometersAndMiles);
            baseMap.SetRadius(1000);
            Rect rect = new Rect();
            rect.Width = img.Width;
            rect.Height = img.Height;
            baseMap.SetMapSize(rect);
            baseMap.SetUncertainAreaRadius(1000);
            baseMap.SetLabelLanguage(LabelLanguageType.English);
            baseMap.EnablePIP(true);
            baseMap.DownloadMapImageCompleted += new DownloadMapImageCompletedEventHandler(baseMap_DownloadMapImageCompleted);
            baseMap.Refresh();
        }

        private void TestTiltingMap()
        {
            TiltingMap tiltingMap = new TiltingMap(this.appId, this.token);
            GeoPoint centerPoint = new GeoPoint();
            centerPoint.Longitude = 116.3977;
            centerPoint.Latitude = 39.903;
            tiltingMap.SetCenter(centerPoint);
            tiltingMap.SetTiltingAngle(60);
            tiltingMap.DownloadMapImageCompleted += new DownloadMapImageCompletedEventHandler(baseMap_DownloadMapImageCompleted);

            Rect rect = new Rect();
            rect.Width = img.Width;
            rect.Height = img.Height;
            tiltingMap.SetMapSize(rect);

            tiltingMap.Refresh();

            baseMap = tiltingMap;
        }

        void TestAddressMap()
        {
            AddressMap addressMap = new AddressMap(this.appId, this.token);
            PlaceInfo placeInfo = new PlaceInfo();
            placeInfo.CountryName = "germany";
            placeInfo.CityName = "leipzig";
            placeInfo.StreetName = "markt";
            placeInfo.HouseNumber = "9";
            placeInfo.ZipCode = "04109";
            addressMap.SetPlaceInfo(placeInfo);
            addressMap.SetInfoBoxPosition(InfoBoxPosition.BelowMarker);

            Rect rect = new Rect();
            rect.Width = img.Width;
            rect.Height = img.Height;
            addressMap.SetMapSize(rect);

            addressMap.DownloadMapImageCompleted += new DownloadMapImageCompletedEventHandler(baseMap_DownloadMapImageCompleted);
            addressMap.Refresh();

            baseMap = addressMap;
        }

        void TestPOIMap()
        {
            POIMap poiMap = new POIMap(this.appId, this.token);
            List<GeoPoint> poiList = new List<GeoPoint>();

            GeoPoint poi1 = new GeoPoint();
            poi1.Longitude = 116.3980;
            poi1.Latitude = 39.9;
            poiList.Add(poi1);

            GeoPoint poi2 = new GeoPoint();
            poi2.Longitude = 116.3977;
            poi2.Latitude = 39.913;
            poiList.Add(poi2);

            GeoPoint poi3 = new GeoPoint();
            poi3.Longitude = 116.3977;
            poi3.Latitude = 39.923;
            poiList.Add(poi3);

            poiMap.MarkPOIs(poiList);
            poiMap.SetMergedOverlappingMarker(true);
            Rect rect = new Rect();
            rect.Width = img.Width;
            rect.Height = img.Height;
            poiMap.SetMapSize(rect);

            poiMap.DownloadMapImageCompleted += new DownloadMapImageCompletedEventHandler(baseMap_DownloadMapImageCompleted);
            poiMap.Refresh();

            baseMap = poiMap;
        }

        void RouteMap()
        {
            double[] r0 = { 52.5338, 13.2966, 52.538361, 13.325329 };
            double[] r1 = { 52.540867, 13.262444, 52.536691, 13.264561, 52.529172, 13.268337, 52.528337, 13.273144, 52.52583, 13.27898, 52.518728, 13.279667 };
            double[] m0 = { 52.5338, 13.2966, 52.538361, 13.325329 };
            double[] m1 = { 52.540867, 13.262444, 52.518728, 13.279667 };
            Color lc0 = Color.FromArgb(68, 00, 00, 255);
            //int lc0 = 0x440000ff;
            // int sc0 = 0x440000ff;
            UInt32 lw0 = 6;
            //int lc1 = 0x44ff00ff;
            //int sc1 = 0x44ff00ff;
            Color lc1 = Color.FromArgb(68, 00, 00, 255);
            UInt32 lw1 = 3;

            RouteMap routeMap = new RouteMap(this.appId, this.token);

            RouteInfo route = new RouteInfo();
            setRouteInfo(route, r0, m0, lc0, lw0);
            routeMap.AddRoute(route);
            RouteInfo route2 = new RouteInfo();
            setRouteInfo(route2, r1, m1, lc1, lw1);
            routeMap.AddRoute(route2);

            Rect rect = new Rect();
            rect.Width = img.Width;
            rect.Height = img.Height;
            routeMap.SetMapSize(rect);

            routeMap.DownloadMapImageCompleted += new DownloadMapImageCompletedEventHandler(baseMap_DownloadMapImageCompleted);
            routeMap.Refresh();

            baseMap = routeMap;
        }

        private void setRouteInfo(RouteInfo route, double[] r0, double[] m0, Color lc0, UInt32 lw0)
        {
            for (int iLoop = 0; iLoop < r0.Length; iLoop += 2)
            {
                GeoPoint point = new GeoPoint();
                point.Longitude = r0[iLoop];
                point.Latitude = r0[iLoop + 1];
                route.RoutePointList.Add(point);
            }
            for (int iLoop = 0; iLoop < m0.Length; iLoop += 2)
            {
                GeoPoint point = new GeoPoint();
                point.Longitude = m0[iLoop];
                point.Latitude = m0[iLoop + 1];
                route.RouteMarkerList.Add(point);
            }
            route.RouteColor = lc0;
            route.RouteWidth = lw0;
        }

        void baseMap_DownloadMapImageCompleted(string error)
        {
            if (error != string.Empty)
            {
                MessageBox.Show(error);
            }
            else
            {
                BitmapImage bmp = baseMap.GetMapImage();

                img.Source = bmp;
            }
        }

        private void routeMapButton_Click(object sender, RoutedEventArgs e)
        {
            RouteMap();
        }
    }
}