/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource;
    private String xaDataSourceName;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:41_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory() throws ResourceException {
        block4: {
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleManagedConnectionFactory(XADataSource xads) throws ResourceException {
        block4: {
            this.xaDataSource = null;
            this.xaDataSourceName = null;
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xads));
                    OracleLog.recursiveTrace = false;
                }
                this.xaDataSource = xads;
                this.xaDataSourceName = "XADataSource";
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXADataSourceName(String xadsName) {
        block4: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(xadsName));
                    OracleLog.recursiveTrace = false;
                }
                this.xaDataSourceName = xadsName;
                if (!TRACE || OracleLog.recursiveTrace) break block4;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXADataSourceName() {
        String string;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + this.xaDataSourceName);
                    OracleLog.recursiveTrace = false;
                }
                string = this.xaDataSourceName;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        DataSource dataSource;
        block6: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(cxManager));
                    OracleLog.recursiveTrace = false;
                }
                if (this.xaDataSource == null) {
                    this.setupXADataSource();
                }
                DataSource __result__ = (DataSource)((Object)this.xaDataSource);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                dataSource = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block6;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnectionFactory() throws ResourceException {
        Object object;
        block5: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                    OracleLog.recursiveTrace = false;
                }
                Object __result__ = this.createConnectionFactory(null);
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                    OracleLog.recursiveTrace = false;
                }
                object = __result__;
                if (!TRACE || OracleLog.recursiveTrace) break block5;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return object;
    }

    /*
     * Loose catch block
     */
    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        OracleManagedConnection oracleManagedConnection;
        block9: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
                OracleLog.recursiveTrace = false;
            }
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            XAConnection xaconn = null;
            PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
            xaconn = pcred == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(pcred.getUserName(), new String(pcred.getPassword()));
            OracleManagedConnection omc = new OracleManagedConnection(xaconn);
            omc.setPasswordCredential(pcred);
            omc.setLogWriter(this.getLogWriter());
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + omc);
                OracleLog.recursiveTrace = false;
            }
            oracleManagedConnection = omc;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return oracleManagedConnection;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        block10: {
            block8: {
                block9: {
                    try {
                        if (OracleManagedConnectionFactory.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(connectionSet) + ", " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
                            OracleLog.recursiveTrace = false;
                        }
                        pcred = this.getPasswordCredential(subject, cxRequestInfo);
                        for (E obj : connectionSet) {
                            if (!(obj instanceof OracleManagedConnection) || !(omc = (OracleManagedConnection)obj).getPasswordCredential().equals((Object)pcred)) continue;
                            if (OracleManagedConnectionFactory.TRACE && !OracleLog.recursiveTrace) {
                                OracleLog.recursiveTrace = true;
                                OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + omc);
                                OracleLog.recursiveTrace = false;
                            }
                            var8_8 = omc;
                            if (!OracleManagedConnectionFactory.TRACE || OracleLog.recursiveTrace) break block8;
                            OracleLog.recursiveTrace = true;
                            break block9;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var9_9) {
                        if (OracleManagedConnectionFactory.TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                            OracleLog.recursiveTrace = false;
                        }
                        throw var9_9;
                    }
                }
                OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return var8_8;
lbl-1000:
            // 1 sources

            {
                if (OracleManagedConnectionFactory.TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                var6_6 = null;
                if (!OracleManagedConnectionFactory.TRACE || OracleLog.recursiveTrace) break block10;
                OracleLog.recursiveTrace = true;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return var6_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogWriter(PrintWriter out) throws ResourceException {
        block7: {
            try {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(out));
                    OracleLog.recursiveTrace = false;
                }
                try {
                    if (this.xaDataSource == null) {
                        this.setupXADataSource();
                    }
                    this.xaDataSource.setLogWriter(out);
                }
                catch (SQLException exc) {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                if (!TRACE || OracleLog.recursiveTrace) break block7;
                OracleLog.recursiveTrace = true;
            }
            catch (Throwable throwable) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                    OracleLog.recursiveTrace = false;
                }
                throw throwable;
            }
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
    }

    /*
     * Loose catch block
     */
    public PrintWriter getLogWriter() throws ResourceException {
        PrintWriter printWriter;
        block9: {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            PrintWriter __result__ = this.xaDataSource.getLogWriter();
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                OracleLog.recursiveTrace = false;
            }
            printWriter = __result__;
            if (!TRACE || OracleLog.recursiveTrace) break block9;
            OracleLog.recursiveTrace = true;
            OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
            OracleLog.recursiveTrace = false;
        }
        return printWriter;
        {
            catch (SQLException exc) {
                try {
                    EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
                    rexc.setLinkedException((Exception)exc);
                    throw rexc;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionFactory.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupXADataSource() throws ResourceException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument());
                OracleLog.recursiveTrace = false;
            }
            try {
                XADataSource xads;
                InitialContext ic = null;
                try {
                    Properties props = System.getProperties();
                    ic = new InitialContext(props);
                }
                catch (java.lang.SecurityException exc) {
                    // empty catch block
                }
                if (ic == null) {
                    ic = new InitialContext();
                }
                if ((xads = (XADataSource)ic.lookup(this.xaDataSourceName)) == null) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionFactory.logger().log(Level.SEVERE, "Throwing ResourceAdapterInternalException: Invalid XADataSource object");
                        OracleLog.recursiveTrace = false;
                    }
                    throw new ResourceAdapterInternalException("Invalid XADataSource object");
                }
                this.xaDataSource = xads;
            }
            catch (NamingException exc) {
                ResourceException rexc = new ResourceException("NamingException: " + exc.getMessage());
                rexc.setLinkedException((Exception)exc);
                throw rexc;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(subject) + ", " + OracleLog.argument(cxRequestInfo));
                OracleLog.recursiveTrace = false;
            }
            if (subject != null) {
                Set<PasswordCredential> creds = subject.getPrivateCredentials(PasswordCredential.class);
                for (PasswordCredential pcred : creds) {
                    if (!pcred.getManagedConnectionFactory().equals(this)) continue;
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "return: " + pcred);
                        OracleLog.recursiveTrace = false;
                    }
                    PasswordCredential passwordCredential = pcred;
                    return passwordCredential;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(Level.SEVERE, "Throwing SecurityException: Can not find user/password informationno password credential");
                    OracleLog.recursiveTrace = false;
                }
                throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
            }
            if (cxRequestInfo == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "return: " + null);
                    OracleLog.recursiveTrace = false;
                }
                PasswordCredential creds = null;
                return creds;
            }
            OracleConnectionRequestInfo info = (OracleConnectionRequestInfo)cxRequestInfo;
            PasswordCredential pcred = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
            pcred.setManagedConnectionFactory((ManagedConnectionFactory)this);
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "return: " + pcred);
                OracleLog.recursiveTrace = false;
            }
            PasswordCredential passwordCredential = pcred;
            return passwordCredential;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleManagedConnectionFactory.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.connector");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

