/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementWrapper;
import oracle.jdbc.driver.OracleResultSetImpl;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;

class ArrayLocatorResultSet
extends OracleResultSetImpl {
    static int COUNT_UNLIMITED = -1;
    Map map;
    long beginIndex;
    int count;
    long currentIndex;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_28_18:31:25_PDT_2008";
    public static boolean TRACE = false;
    private static Logger LOGGER;
    public static final boolean PRIVATE_TRACE = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLocatorResultSet(OracleConnection conn, ArrayDescriptor descriptor, byte[] locator, Map map) throws SQLException {
        this(conn, descriptor, locator, 0L, COUNT_UNLIMITED, map);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(descriptor) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayLocatorResultSet(OracleConnection conn, ArrayDescriptor descriptor, byte[] locator, long beginIndex, int count, Map map) throws SQLException {
        super((PhysicalConnection)conn, null);
        try {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(OracleLog.TRACE_16, "Enter: " + OracleLog.argument(conn) + ", " + OracleLog.argument(descriptor) + ", " + OracleLog.argument(locator) + ", " + OracleLog.argument(beginIndex) + ", " + OracleLog.argument(count) + ", " + OracleLog.argument(map));
                OracleLog.recursiveTrace = false;
            }
            if (descriptor == null || conn == null) {
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayLocatorResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 1Invalid arguments");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid arguments");
            }
            this.close_statement_on_close = true;
            this.count = count;
            this.currentIndex = 0L;
            this.beginIndex = beginIndex;
            this.map = map;
            OraclePreparedStatement pstmt = null;
            ARRAY tmpObj = new ARRAY(descriptor, conn, (Object)null);
            tmpObj.setLocator(locator);
            pstmt = descriptor.getBaseType() == 2002 || descriptor.getBaseType() == 2008 ? (OraclePreparedStatement)((OraclePreparedStatementWrapper)conn.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, SYS_NC_ROWINFO$ FROM TABLE( CAST(:1 AS ").append((String)descriptor.getName()).append((String)") )").toString())).preparedStatement : (OraclePreparedStatement)((OraclePreparedStatementWrapper)conn.prepareStatement((String)new StringBuilder().append((String)"SELECT ROWNUM, COLUMN_VALUE FROM TABLE( CAST(:1 AS ").append((String)descriptor.getName()).append((String)") )").toString())).preparedStatement;
            pstmt.setArray(1, tmpObj);
            pstmt.executeQuery();
            this.statement = pstmt;
        }
        finally {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean next() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean bl;
            block23: {
                block21: {
                    boolean bl2;
                    block22: {
                        block19: {
                            boolean bl3;
                            block20: {
                                block16: {
                                    boolean bl4;
                                    block18: {
                                        boolean bl5;
                                        try {
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                ArrayLocatorResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument());
                                                OracleLog.recursiveTrace = false;
                                            }
                                            if (this.currentIndex >= this.beginIndex) break block16;
                                            while (this.currentIndex < this.beginIndex) {
                                                ++this.currentIndex;
                                                if (super.next()) continue;
                                                if (TRACE && !OracleLog.recursiveTrace) {
                                                    OracleLog.recursiveTrace = true;
                                                    ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                                                    OracleLog.recursiveTrace = false;
                                                }
                                                bl5 = false;
                                                if (!TRACE || OracleLog.recursiveTrace) break block17;
                                                OracleLog.recursiveTrace = true;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (TRACE && !OracleLog.recursiveTrace) {
                                                OracleLog.recursiveTrace = true;
                                                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                                OracleLog.recursiveTrace = false;
                                            }
                                            throw throwable;
                                        }
                                        {
                                            block17: {
                                                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                                OracleLog.recursiveTrace = false;
                                            }
                                            return bl5;
                                        }
                                        if (TRACE && !OracleLog.recursiveTrace) {
                                            OracleLog.recursiveTrace = true;
                                            ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: true");
                                            OracleLog.recursiveTrace = false;
                                        }
                                        bl4 = true;
                                        if (!TRACE || OracleLog.recursiveTrace) break block18;
                                        OracleLog.recursiveTrace = true;
                                        ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    return bl4;
                                }
                                if (this.count != COUNT_UNLIMITED) break block19;
                                boolean __result__ = super.next();
                                if (TRACE && !OracleLog.recursiveTrace) {
                                    OracleLog.recursiveTrace = true;
                                    ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                                    OracleLog.recursiveTrace = false;
                                }
                                bl3 = __result__;
                                if (!TRACE || OracleLog.recursiveTrace) break block20;
                                OracleLog.recursiveTrace = true;
                                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return bl3;
                        }
                        if (this.currentIndex >= this.beginIndex + (long)this.count - 1L) break block21;
                        ++this.currentIndex;
                        boolean __result__ = super.next();
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                            OracleLog.recursiveTrace = false;
                        }
                        bl2 = __result__;
                        if (!TRACE || OracleLog.recursiveTrace) break block22;
                        OracleLog.recursiveTrace = true;
                        ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return bl2;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: false");
                    OracleLog.recursiveTrace = false;
                }
                bl = false;
                if (!TRACE || OracleLog.recursiveTrace) break block23;
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int columnIndex) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object object;
            block9: {
                try {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayLocatorResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnIndex));
                        OracleLog.recursiveTrace = false;
                    }
                    Object __result__ = this.getObject(columnIndex, this.map);
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: " + __result__);
                        OracleLog.recursiveTrace = false;
                    }
                    object = __result__;
                    if (!TRACE || OracleLog.recursiveTrace) break block9;
                    OracleLog.recursiveTrace = true;
                }
                catch (Throwable throwable) {
                    if (TRACE && !OracleLog.recursiveTrace) {
                        OracleLog.recursiveTrace = true;
                        ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    throw throwable;
                }
                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int findColumn(String columnName) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            block16: {
                block14: {
                    int n3;
                    block15: {
                        block12: {
                            int n4;
                            block13: {
                                try {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayLocatorResultSet.logger().log(OracleLog.callDepth++ == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Public Enter: " + OracleLog.argument(columnName));
                                        OracleLog.recursiveTrace = false;
                                    }
                                    if (!columnName.equalsIgnoreCase("index")) break block12;
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 1");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    n4 = 1;
                                    if (!TRACE || OracleLog.recursiveTrace) break block13;
                                    OracleLog.recursiveTrace = true;
                                }
                                catch (Throwable throwable) {
                                    if (TRACE && !OracleLog.recursiveTrace) {
                                        OracleLog.recursiveTrace = true;
                                        ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                        OracleLog.recursiveTrace = false;
                                    }
                                    throw throwable;
                                }
                                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                                OracleLog.recursiveTrace = false;
                            }
                            return n4;
                        }
                        if (!columnName.equalsIgnoreCase("value")) break block14;
                        if (TRACE && !OracleLog.recursiveTrace) {
                            OracleLog.recursiveTrace = true;
                            ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 2");
                            OracleLog.recursiveTrace = false;
                        }
                        n3 = 2;
                        if (!TRACE || OracleLog.recursiveTrace) break block15;
                        OracleLog.recursiveTrace = true;
                        ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                        OracleLog.recursiveTrace = false;
                    }
                    return n3;
                }
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayLocatorResultSet.logger().log(Level.SEVERE, "Throwing SQLException: 6get_column_index");
                    OracleLog.recursiveTrace = false;
                }
                DatabaseError.throwSqlException(this.getConnectionDuringExceptionHandling(), 6, "get_column_index");
                if (TRACE && !OracleLog.recursiveTrace) {
                    OracleLog.recursiveTrace = true;
                    ArrayLocatorResultSet.logger().log(OracleLog.callDepth == 1 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "return: 0");
                    OracleLog.recursiveTrace = false;
                }
                n2 = 0;
                if (!TRACE || OracleLog.recursiveTrace) break block16;
                OracleLog.recursiveTrace = true;
                ArrayLocatorResultSet.logger().log(--OracleLog.callDepth == 0 ? OracleLog.TRACE_1 : OracleLog.TRACE_16, "Exit");
                OracleLog.recursiveTrace = false;
            }
            return n2;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.ArrayLocatorResultSet"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

